/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class TchVipRegistryWorksheetHandler
extends BasePoiWorksheetHandler<TchVipTicket> {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<TchVipTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        if (data.getTickets().isEmpty()) {
            return;
        }
        HashMap ticketsMap = new HashMap();
        for (Batch batch : Batch.values()) {
            ticketsMap.put(batch, new ArrayList());
        }
        block1: for (TchVipTicket ticket : data.getTickets()) {
            Batch[] batchArray = Batch.values();
            int batch = batchArray.length;
            for (int i = 0; i < batch; ++i) {
                Batch batch2 = batchArray[i];
                if (!batch2.accept(ticket)) continue;
                ((List)ticketsMap.get((Object)batch2)).add(ticket);
                continue block1;
            }
        }
        for (Batch batch : Batch.values()) {
            Collections.sort((List)ticketsMap.get((Object)batch), new Comparator<TchVipTicket>(){

                @Override
                public int compare(TchVipTicket o1, TchVipTicket o2) {
                    return TextUtil.compare((String)o1.getTicketBlankNumber(), (String)o2.getTicketBlankNumber(), (boolean)false, (boolean)false);
                }
            });
        }
        int currentRow = 9;
        int totalIndex = 1;
        for (Batch batch2 : Batch.values()) {
            List tickets = (List)ticketsMap.get((Object)batch2);
            int batchStartRow = currentRow;
            int batchIndex = 1;
            if (!tickets.isEmpty()) {
                if (tickets.size() > 1) {
                    for (int n = 1; n < tickets.size(); ++n) {
                        ExcelUtils.copyRows((HSSFSheet)sheet, (int)(batchStartRow - 1), (int)(batchStartRow - 1));
                    }
                }
                for (TchVipTicket ticket : tickets) {
                    int xOffset = currentRow;
                    int yOffset = 1;
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)1, (int)totalIndex);
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)2, (int)batchIndex);
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)3, (String)ticket.getTicketSeries());
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)4, (String)ticket.getTicketBlankNumber());
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)5, (BigDecimal)ticket.getEquivalentFare());
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)6, (BigDecimal)ticket.getTaxForBlankAmount());
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)7, (BigDecimal)ticket.getOtherTaxesAmount());
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)8, (String)String.format("E%s+F%1$s+G%1$s", Integer.toString(currentRow)));
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)9, (BigDecimal)ticket.getSupplierCommissionPercent());
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)10, (BigDecimal)ticket.getSupplierCommissonAmount());
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)xOffset, (int)yOffset, (int)1, (int)11, (String)String.format("H%s-J%1$s", Integer.toString(currentRow)));
                    ++currentRow;
                    ++totalIndex;
                    ++batchIndex;
                }
            }
            if (tickets.isEmpty()) {
                sheet.getRow(currentRow - 1).setHeight((short)0);
                ++currentRow;
            }
            if (batch2.isHasTotalSection()) {
                HSSFRow row = sheet.getRow(currentRow - 1);
                for (int n = 4; n <= 10; ++n) {
                    if (n == 8) continue;
                    row.getCell(n).setCellFormula(String.format("SUM(%s%s:%1$s%s)", ExcelUtils.indexToLetter((int)(n + 1)), Integer.toString(batchStartRow), Integer.toString(currentRow - 1)));
                }
                ++currentRow;
            }
            ++currentRow;
        }
        sheet.setForceFormulaRecalculation(true);
    }

    static enum Batch {
        VOID{

            @Override
            boolean accept(TchVipTicket ticket) {
                return ticket.getProductCategory() == ProductCategory.AIR && (ticket.getStatus() == ProductStatus.VOID || ticket.getStatus() == ProductStatus.VOID_BOOKING);
            }

            @Override
            boolean isHasTotalSection() {
                return false;
            }
        }
        ,
        EXCHANGE{

            @Override
            boolean accept(TchVipTicket ticket) {
                return ticket.getStatus() == ProductStatus.EXCHANGE && ticket.getProductCategory() == ProductCategory.AIR;
            }
        }
        ,
        SELL{

            @Override
            boolean accept(TchVipTicket ticket) {
                return ticket.getStatus() == ProductStatus.SELL && ticket.getProductCategory() == ProductCategory.AIR;
            }
        }
        ,
        REFUND{

            @Override
            boolean accept(TchVipTicket ticket) {
                return ticket.getStatus() == ProductStatus.REFUND && ticket.getProductCategory() == ProductCategory.AIR;
            }
        }
        ,
        MCO{

            @Override
            boolean accept(TchVipTicket ticket) {
                return ticket.getProductCategory() == ProductCategory.MCO;
            }
        };


        abstract boolean accept(TchVipTicket var1);

        boolean isHasTotalSection() {
            return true;
        }
    }
}

