/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BaseTchWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.SplitTicketsHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

abstract class BaseTchCCListWorksheetHandler
extends BaseTchWorksheetHandler<TchTicket> {
    private final CCListTicketHandler handler;

    BaseTchCCListWorksheetHandler(CCListTicketHandler ticketHandler) {
        this.handler = ticketHandler;
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<TchTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        List<TchReportItem> items = this.prepareItems(data.getTickets());
        if (items.size() == 0) {
            boolean hasClientFee = data.getTickets().stream().anyMatch(t -> BigDecimal.ZERO.compareTo(t.getPkClientFeeEquivalentValue()) != 0);
            if (!hasClientFee) {
                wb.removeSheetAt(wb.getSheetIndex((Sheet)sheet));
                return;
            }
            for (int n = 6; n < 23; ++n) {
                ExcelUtils.removeRow((HSSFSheet)sheet, (int)6);
            }
            return;
        }
        wb.setSheetName(wb.getSheetIndex((Sheet)sheet), this.handler.getSheetName());
        for (int n = 0; n < items.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)6, (int)19);
        }
        int currentIndex = 7;
        int lineNumber = 1;
        StringBuilder summFare = new StringBuilder();
        StringBuilder summFareOut = new StringBuilder();
        StringBuilder summPenalty = new StringBuilder();
        StringBuilder summComission = new StringBuilder();
        StringBuilder summComissionOut = new StringBuilder();
        StringBuilder summAgs = new StringBuilder();
        StringBuilder summAgsOut = new StringBuilder();
        StringBuilder summTaxTch = new StringBuilder();
        StringBuilder summSumTch = new StringBuilder();
        StringBuilder summSumTchOut = new StringBuilder();
        for (TchReportItem item : items) {
            int firstRow;
            int m;
            int titleIndex = currentIndex;
            int cardItemsCount = 0;
            for (int n = 0; n < 7; ++n) {
                int originX = currentIndex;
                int originY = 7;
                BigDecimal fareValue = item.fare[n];
                BigDecimal penaltyValue = item.penalty[n];
                BigDecimal tchTax = item.taxTch[n];
                BigDecimal xtTax = item.agsTch[n];
                if (fareValue == null && penaltyValue == null && tchTax == null && xtTax == null) {
                    ExcelUtils.removeRow((HSSFSheet)sheet, (int)(currentIndex - 1));
                    ExcelUtils.removeRow((HSSFSheet)sheet, (int)(currentIndex - 1));
                    continue;
                }
                ++cardItemsCount;
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)1, (BigDecimal)fareValue, (boolean)true);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)1, (BigDecimal)item.fareOut[n], (boolean)true);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)2, (BigDecimal)item.penalty[n], (boolean)true);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)3, (BigDecimal)item.comission[n], (boolean)true);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)3, (BigDecimal)item.comissionOut[n], (boolean)true);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)4, (BigDecimal)item.agsTch[n], (boolean)true);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)4, (BigDecimal)item.agsTchOut[n], (boolean)true);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)5, (BigDecimal)item.taxTch[n], (boolean)true);
                if (item.summTch[n] != null && item.summTch[n].doubleValue() != 0.0) {
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)6, (String)("=G" + currentIndex + "+H" + currentIndex + "+J" + currentIndex + "+K" + currentIndex));
                }
                if (item.summTchOut[n] != null && item.summTchOut[n].doubleValue() != 0.0) {
                    ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)6, (String)("=G" + (currentIndex + 1)));
                }
                currentIndex += 2;
            }
            for (m = 0; m < cardItemsCount; ++m) {
                firstRow = titleIndex - 1 + 2 * m;
                org.apache.poi.hssf.util.CellRangeAddress range = new org.apache.poi.hssf.util.CellRangeAddress(firstRow, firstRow + 1, 4, 4);
                sheet.addMergedRegion((CellRangeAddress)range);
            }
            for (m = 0; m < 4; ++m) {
                firstRow = titleIndex - 1;
                int lastRow = firstRow + 2 * cardItemsCount - 1;
                org.apache.poi.hssf.util.CellRangeAddress range = new org.apache.poi.hssf.util.CellRangeAddress(firstRow, lastRow, m, m);
                sheet.addMergedRegion((CellRangeAddress)range);
            }
            int originX = titleIndex;
            int originY = 1;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)1, (int)lineNumber);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)2, (String)item.carrierNumber);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)3, (String)item.carrierCode);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)4, (String)item.carrierName);
            this.addSummItem(summFare, item.fare[6], "G", currentIndex - 2);
            this.addSummItem(summFareOut, item.fareOut[6], "G", currentIndex - 1);
            this.addSummItem(summPenalty, item.penalty[6], "H", currentIndex - 2);
            this.addSummItem(summComission, item.comission[6], "I", currentIndex - 2);
            this.addSummItem(summComissionOut, item.comissionOut[6], "I", currentIndex - 1);
            this.addSummItem(summAgs, item.agsTch[6], "J", currentIndex - 2);
            this.addSummItem(summAgsOut, item.agsTchOut[6], "J", currentIndex - 1);
            this.addSummItem(summTaxTch, item.taxTch[6], "K", currentIndex - 2);
            this.addSummItem(summSumTch, item.summTch[6], "L", currentIndex - 2);
            this.addSummItem(summSumTchOut, item.summTchOut[6], "L", currentIndex - 1);
            ++lineNumber;
        }
        int originX = currentIndex;
        int originY = 1;
        this.updateField(sheet, originX, originY, 1, 7, summFare);
        this.updateField(sheet, originX, originY, 2, 7, summFareOut);
        this.updateField(sheet, originX, originY, 1, 8, summPenalty);
        this.updateField(sheet, originX, originY, 1, 9, summComission);
        this.updateField(sheet, originX, originY, 2, 9, summComissionOut);
        this.updateField(sheet, originX, originY, 1, 10, summAgs);
        this.updateField(sheet, originX, originY, 2, 10, summAgsOut);
        this.updateField(sheet, originX, originY, 1, 11, summTaxTch);
        this.updateField(sheet, originX, originY, 1, 12, summSumTch);
        this.updateField(sheet, originX, originY, 2, 12, summSumTchOut);
        for (int n = 0; n < 7; ++n) {
            HSSFRow row = sheet.getRow(currentIndex + n + 2);
            if (row == null) continue;
            row.setHeightInPoints(12.0f);
        }
    }

    private List<TchReportItem> prepareItems(Collection<TchTicket> tickets) throws Exception {
        ArrayList<TchReportItem> result = new ArrayList<TchReportItem>();
        for (TchTicket ticket : tickets) {
            ProductStatus status;
            TchReportItem item;
            if (ticket.isConjunctedTicket() || ticket.isAdditionalSegment()) continue;
            int cardType = 0;
            if (CardVendor.MIR.equals((Object)ticket.getCardVendor())) {
                cardType = 5;
            } else if (CardVendor.DINERS_CLUB.equals((Object)ticket.getCardVendor())) {
                cardType = 4;
            } else if (CardVendor.JCB.equals((Object)ticket.getCardVendor())) {
                cardType = 3;
            } else if (CardVendor.AMEX.equals((Object)ticket.getCardVendor())) {
                cardType = 2;
            } else if (CardVendor.MASTERCARD.equals((Object)ticket.getCardVendor())) {
                cardType = 1;
            } else {
                if (!CardVendor.VISA.equals((Object)ticket.getCardVendor())) continue;
                cardType = 0;
            }
            BigDecimal fare = this.handler.getFare(ticket);
            BigDecimal xtTax = this.handler.getXtTax(ticket);
            BigDecimal tchTax = this.handler.getTchTax(ticket);
            BigDecimal penalty = this.handler.getPenalty(ticket);
            BigDecimal clientFee = this.handler.getClientFee(ticket);
            if (fare.doubleValue() == 0.0 && xtTax.doubleValue() == 0.0 && tchTax.doubleValue() == 0.0 && penalty.doubleValue() == 0.0) continue;
            BigDecimal commission = this.getBigDecimal(ticket.getVendorEquivalentCommission());
            BigDecimal totalFare = ticket.getFareCash().add(fare);
            commission = totalFare.doubleValue() > 0.0 ? commission.multiply(fare).divide(totalFare, 2, 1) : BigDecimal.ZERO;
            boolean vatIncluded = ticket.isVatIncluded();
            boolean penaltyMco = ticket.getProductCategory() == ProductCategory.MCO && (ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING);
            String carrierNumber = ticket.getCarrierNumber();
            if (carrierNumber == null) {
                carrierNumber = "";
            }
            String[] carrierCodes = ticket.getCarrierCodes();
            String[] carrierNames = ticket.getCarrierNames();
            if (carrierCodes == null) {
                carrierCodes = new String[]{};
                carrierNames = new String[]{};
            }
            if (AirProductHelper.isFewCarriersAggreementCarrierNumber((String)carrierNumber)) {
                item = new TchReportItem();
                item.carrierNumber = carrierNumber;
                item.carrierCode = carrierCodes[0];
                item.carrierName = carrierNames[0];
                status = ticket.getStatus();
                if (penaltyMco) {
                    fare = BigDecimal.ZERO;
                    penalty = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? fare.negate() : fare;
                }
                this.initializeItem(item, status, fare, penalty, tchTax, xtTax, commission, vatIncluded, penaltyMco, cardType);
                this.addItem(item, result, cardType);
                continue;
            }
            item = new TchReportItem();
            item.carrierNumber = carrierNumber;
            item.carrierCode = "";
            item.carrierName = "";
            if (AirProductHelper.isSpecialSchemeTourCode((String)carrierNumber) && carrierCodes.length != 0) {
                int n;
                StringBuilder sbCodes = new StringBuilder(carrierCodes[0]);
                StringBuilder sbNames = new StringBuilder(carrierNames[0]);
                for (n = 1; n < carrierCodes.length; ++n) {
                    sbCodes.append("/").append(carrierCodes[n]);
                }
                for (n = 1; n < carrierNames.length; ++n) {
                    sbNames.append("/").append(carrierNames[n]);
                }
                item.carrierCode = sbCodes.toString();
                item.carrierName = sbNames.toString();
            } else {
                item.carrierCode = ticket.getCarrierCode();
                item.carrierName = ticket.getCarrierName();
            }
            status = ticket.getStatus();
            if (penaltyMco) {
                fare = BigDecimal.ZERO;
                penalty = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? this.getBigDecimal(fare).negate() : fare;
            }
            this.initializeItem(item, status, fare, penalty, tchTax, xtTax, commission, vatIncluded, penaltyMco, cardType);
            this.addItem(item, result, cardType);
        }
        Collections.sort(result, new Comparator<TchReportItem>(){

            @Override
            public int compare(TchReportItem item1, TchReportItem item2) {
                int compare = SplitTicketsHelper.getSchemeIndex(item1.carrierNumber) - SplitTicketsHelper.getSchemeIndex(item2.carrierNumber);
                if (compare != 0) {
                    return compare;
                }
                compare = TextUtil.compare((String)(item1 != null ? item1.carrierNumber : null), (String)(item2 != null ? item2.carrierNumber : null), (boolean)false, (boolean)true);
                if (compare != 0) {
                    return compare;
                }
                compare = TextUtil.compare((String)(item1 != null ? item1.carrierCode : null), (String)(item2 != null ? item2.carrierCode : null), (boolean)false, (boolean)true);
                if (compare != 0) {
                    return compare;
                }
                return TextUtil.compare((String)(item1 != null ? item1.carrierName : null), (String)(item2 != null ? item2.carrierName : null), (boolean)false, (boolean)true);
            }
        });
        return result;
    }

    private void addItem(TchReportItem item, List<TchReportItem> result, int cardType) throws Exception {
        Object item3 = null;
        for (TchReportItem item2 : result) {
            if (!item.equals(item2)) continue;
            item3 = item2;
            break;
        }
        if (item3 == null) {
            result.add(item);
            return;
        }
        for (Field field : item3.getClass().getDeclaredFields()) {
            Object obj = field.get(item);
            Object obj3 = field.get(item3);
            if (!(obj instanceof BigDecimal[])) continue;
            BigDecimal[] fieldValue = (BigDecimal[])obj;
            BigDecimal[] fieldValue3 = (BigDecimal[])obj3;
            if (fieldValue[cardType] != null) {
                fieldValue3[cardType] = fieldValue3[cardType] == null ? new BigDecimal(fieldValue[cardType].doubleValue()) : new BigDecimal(fieldValue[cardType].doubleValue() + fieldValue3[cardType].doubleValue());
            }
            if (fieldValue[6] == null) continue;
            fieldValue3[6] = fieldValue3[6] == null ? new BigDecimal(fieldValue[6].doubleValue()) : new BigDecimal(fieldValue[6].doubleValue() + fieldValue3[6].doubleValue());
        }
    }

    private void initializeItem(TchReportItem item, ProductStatus status, BigDecimal fare, BigDecimal penalty, BigDecimal tchTax, BigDecimal xtTax, BigDecimal commission, boolean vatIncluded, boolean penaltyMco, int cardType) {
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            item.fare[cardType] = fare.negate();
            item.comission[cardType] = commission.negate();
            if (!vatIncluded) {
                item.fareOut[cardType] = fare.negate();
                item.comissionOut[cardType] = commission.negate();
                item.agsTchOut[cardType] = this.getNonZeroBigDecimal(xtTax.negate());
            }
            item.taxTch[cardType] = this.getNonZeroBigDecimal(tchTax.negate());
            item.penalty[cardType] = this.getNonZeroBigDecimal(penalty);
            item.agsTch[cardType] = this.getNonZeroBigDecimal(xtTax.negate());
            item.summTch[cardType] = this.getNonZeroBigDecimal(fare.negate(), penalty, tchTax.negate(), xtTax.negate());
            if (!vatIncluded) {
                item.summTchOut[cardType] = item.fareOut[cardType];
            }
        } else {
            item.fare[cardType] = fare;
            item.comission[cardType] = commission;
            if (!vatIncluded) {
                item.fareOut[cardType] = fare;
                item.comissionOut[cardType] = commission;
                item.agsTchOut[cardType] = this.getNonZeroBigDecimal(xtTax);
            }
            item.taxTch[cardType] = this.getNonZeroBigDecimal(tchTax);
            item.agsTch[cardType] = this.getNonZeroBigDecimal(xtTax);
            item.penalty[cardType] = this.getNonZeroBigDecimal(penalty);
            item.summTch[cardType] = this.getNonZeroBigDecimal(fare, penalty, xtTax, tchTax);
            if (!vatIncluded) {
                item.summTchOut[cardType] = item.fareOut[cardType];
            }
        }
        item.fare[6] = item.fare[cardType];
        item.comission[6] = item.comission[cardType];
        item.comissionOut[6] = item.comissionOut[cardType];
        item.penalty[6] = item.penalty[cardType];
        item.fareOut[6] = item.fareOut[cardType];
        item.taxTch[6] = item.taxTch[cardType];
        item.agsTch[6] = item.agsTch[cardType];
        item.agsTchOut[6] = item.agsTchOut[cardType];
        item.summTch[6] = item.summTch[cardType];
        item.summTchOut[6] = item.summTchOut[cardType];
    }

    static class TchReportItem {
        String carrierNumber;
        String carrierCode;
        String carrierName;
        BigDecimal[] fare = new BigDecimal[7];
        BigDecimal[] fareOut = new BigDecimal[7];
        BigDecimal[] penalty = new BigDecimal[7];
        BigDecimal[] comission = new BigDecimal[7];
        BigDecimal[] comissionOut = new BigDecimal[7];
        BigDecimal[] agsTch = new BigDecimal[7];
        BigDecimal[] agsTchOut = new BigDecimal[7];
        BigDecimal[] summTch = new BigDecimal[7];
        BigDecimal[] summTchOut = new BigDecimal[7];
        BigDecimal[] taxTch = new BigDecimal[7];

        TchReportItem() {
        }

        public boolean equals(Object obj) {
            String name2;
            if (!(obj instanceof TchReportItem)) {
                return false;
            }
            TchReportItem item2 = (TchReportItem)obj;
            String number1 = this.carrierNumber == null ? "" : this.carrierNumber;
            String number2 = item2.carrierNumber == null ? "" : item2.carrierNumber;
            String code1 = this.carrierCode == null ? "" : this.carrierCode;
            String code2 = item2.carrierCode == null ? "" : item2.carrierCode;
            String name1 = this.carrierName == null ? "" : this.carrierName;
            String string = name2 = item2.carrierName == null ? "" : item2.carrierName;
            return number1.equals(number2) && code1.equals(code2) && name1.equals(name2);
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.carrierNumber, this.carrierCode, this.carrierName});
        }
    }

    static interface CCListTicketHandler {
        public String getSheetName();

        public BigDecimal getFare(TchTicket var1);

        public BigDecimal getXtTax(TchTicket var1);

        public BigDecimal getTchTax(TchTicket var1);

        public BigDecimal getPenalty(TchTicket var1);

        public BigDecimal getClientFee(TchTicket var1);
    }
}

