/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TchCreditCardAccompanyingDocumentType;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TicketsGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class SplitTicketsHelper {
    static final List<String> subsidizedAirlinesCodes = Arrays.asList("SU", "\u0421\u0423", "R3", "\u042f\u041a", "UN", "\u0423\u041d", "UT", "\u042e\u0422", "Y7", "\u0422\u0418", "6R", "\u042f\u041c");

    static List<TicketsGroup> splitTickets(Collection<TchTicket> tickets, boolean use2015Scheme, TchReportRegistriesSetType registriesType) {
        if (tickets == null || tickets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TicketsGroup> result = new ArrayList<TicketsGroup>();
        TicketsGroup etPta = new TicketsGroup();
        etPta.setGroupCode("ETPTA");
        TicketsGroup etNotPta = new TicketsGroup();
        etNotPta.setGroupCode("ETSELL");
        TicketsGroup tPta = new TicketsGroup();
        tPta.setGroupCode("TPTA");
        TicketsGroup tNotPta = new TicketsGroup();
        tNotPta.setGroupCode("TSELL");
        TicketsGroup etCCA4 = new TicketsGroup();
        etCCA4.setGroupCode("ETCCA4");
        TicketsGroup etPKA4 = new TicketsGroup();
        etPKA4.setGroupCode("ETPKA4");
        for (TchTicket ticket : tickets) {
            TicketsGroup group;
            String batchId;
            TchReportRegistriesSetType ticketRegistryType;
            boolean subsidized = SplitTicketsHelper.isSubsidized(ticket);
            boolean ccTicket = SplitTicketsHelper.isCC(ticket);
            boolean pkTicket = SplitTicketsHelper.isPK(ticket);
            if (use2015Scheme && registriesType != (ticketRegistryType = !(!ccTicket && !pkTicket || !ticket.isEticket() || ticket.getCreditCardAccompanyingDocumentType() != TchCreditCardAccompanyingDocumentType.A4_AUTOMATIC && ticket.getCreditCardAccompanyingDocumentType() != null) ? (subsidized && ticket.getCarrierCode() != null && subsidizedAirlinesCodes.contains(ticket.getCarrierCode()) ? TchReportRegistriesSetType.REQUIRED : TchReportRegistriesSetType.ADDITTIONAL) : (subsidized ? (ticket.getCarrierCode() != null && subsidizedAirlinesCodes.contains(ticket.getCarrierCode()) ? TchReportRegistriesSetType.REQUIRED : TchReportRegistriesSetType.ADDITTIONAL) : TchReportRegistriesSetType.REQUIRED))) continue;
            if (ccTicket) {
                batchId = null;
                group = null;
                if (use2015Scheme) {
                    if (ticket.isEticket()) {
                        if (ticket.getCreditCardAccompanyingDocumentType() == TchCreditCardAccompanyingDocumentType.C98_MANUAL) {
                            group = etNotPta;
                            batchId = "CCC98M";
                        } else {
                            group = etCCA4;
                            batchId = "CC";
                        }
                    } else {
                        group = tNotPta;
                        batchId = "CC";
                    }
                } else {
                    group = ticket.isEticket() ? etNotPta : tNotPta;
                    batchId = "CC";
                }
                SplitTicketsHelper.addTicket(ticket, group, subsidized ? SplitTicketsHelper.getSubsidizedTicketPackId(ticket) : batchId);
                continue;
            }
            if (pkTicket) {
                batchId = null;
                group = null;
                if (use2015Scheme) {
                    if (ticket.isEticket()) {
                        if (ticket.getCreditCardAccompanyingDocumentType() == TchCreditCardAccompanyingDocumentType.C98_MANUAL) {
                            group = etNotPta;
                            batchId = "PKC98M";
                        } else {
                            group = etPKA4;
                            batchId = "PK";
                        }
                    } else {
                        group = tNotPta;
                        batchId = "PK";
                    }
                } else {
                    group = ticket.isEticket() ? etNotPta : tNotPta;
                    batchId = "PK";
                }
                SplitTicketsHelper.addTicket(ticket, group, subsidized ? SplitTicketsHelper.getSubsidizedTicketPackId(ticket) : batchId);
                continue;
            }
            if (subsidized) {
                SplitTicketsHelper.addTicket(ticket, ticket.isEticket() ? etNotPta : tNotPta, SplitTicketsHelper.getSubsidizedTicketPackId(ticket));
                continue;
            }
            if (SplitTicketsHelper.isCredit(ticket)) {
                SplitTicketsHelper.addTicket(ticket, ticket.isEticket() ? etNotPta : tNotPta, "VPD");
                continue;
            }
            if (SplitTicketsHelper.isCash(ticket)) {
                SplitTicketsHelper.addTicket(ticket, ticket.isEticket() ? etNotPta : tNotPta, "CA");
            }
            if (!SplitTicketsHelper.isPTA(ticket)) continue;
            SplitTicketsHelper.addTicket(ticket, ticket.isEticket() ? etPta : tPta, "PTA");
        }
        if (!etPta.getTickets().keySet().isEmpty()) {
            result.add(etPta);
        }
        if (!etNotPta.getTickets().keySet().isEmpty()) {
            result.add(etNotPta);
        }
        if (!tPta.getTickets().keySet().isEmpty()) {
            result.add(tPta);
        }
        if (!tNotPta.getTickets().keySet().isEmpty()) {
            result.add(tNotPta);
        }
        if (!etCCA4.getTickets().keySet().isEmpty()) {
            result.add(etCCA4);
        }
        if (!etPKA4.getTickets().keySet().isEmpty()) {
            result.add(etPKA4);
        }
        SplitTicketsHelper.reorderSubsidizedBatches(result);
        return result;
    }

    private static void reorderSubsidizedBatches(List<TicketsGroup> result) {
        for (TicketsGroup group : result) {
            final HashMap<String, Integer> originalOrder = new HashMap<String, Integer>();
            int n = 0;
            for (String batchId : group.getTickets().keySet()) {
                originalOrder.put(batchId, n);
                ++n;
            }
            ArrayList<String> keys = new ArrayList<String>(group.getTickets().keySet());
            Collections.sort(keys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int res = this.getSubsidizedOrder(o1) - this.getSubsidizedOrder(o2);
                    if (res != 0) {
                        return res;
                    }
                    return this.getOriginalOrder(o1) - this.getOriginalOrder(o2);
                }

                private int getOriginalOrder(String o1) {
                    return (Integer)originalOrder.get(o1);
                }

                private int getSubsidizedOrder(String o1) {
                    return o1.startsWith("SUB ") ? 0 : 1;
                }
            });
            LinkedHashMap<String, List<TchTicket>> sortedBatches = new LinkedHashMap<String, List<TchTicket>>();
            for (String batchId : keys) {
                sortedBatches.put(batchId, group.getTickets().get(batchId));
            }
            group.getTickets().clear();
            group.getTickets().putAll(sortedBatches);
        }
    }

    private static String getSubsidizedTicketPackId(TchTicket ticket) {
        return String.format("SUB %s", ticket.getSubsidizedPackId());
    }

    private static boolean isSubsidized(TchTicket ticket) {
        return ticket.isSubsidizedTariff();
    }

    private static void addTicket(TchTicket ticket, TicketsGroup ticketsGroup, String ticketsBatchCash) {
        List<TchTicket> tickets = ticketsGroup.getTickets().get(ticketsBatchCash);
        if (tickets == null) {
            tickets = new ArrayList<TchTicket>();
            ticketsGroup.getTickets().put(ticketsBatchCash, tickets);
        }
        tickets.add(ticket);
    }

    private static boolean isCash(TchTicket ticket) {
        if (ticket.getStatus() == ProductStatus.VOID) {
            return true;
        }
        HashSet<ProductFop> fops = new HashSet<ProductFop>(ticket.getFops());
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.INFORMATION) {
            fops.addAll(ticket.getRelatedProductFops());
        }
        return SalesReportHelper.isHasFop(fops, PaymentType.CASH) || SalesReportHelper.isHasFop(fops, PaymentType.INVOICE);
    }

    private static boolean isCC(TchTicket ticket) {
        if (ticket.getStatus() == ProductStatus.VOID) {
            return false;
        }
        HashSet<ProductFop> fops = new HashSet<ProductFop>(ticket.getFops());
        if (ticket.getProductCategory() == ProductCategory.MCO && (ticket.getMcoCategory() == MCOCategory.INFORMATION || ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING)) {
            fops.addAll(ticket.getRelatedProductFops());
        }
        return SalesReportHelper.isHasFop(fops, PaymentType.CREDIT_CARD);
    }

    private static boolean isPK(TchTicket ticket) {
        if (ticket.getStatus() == ProductStatus.VOID) {
            return false;
        }
        HashSet<ProductFop> fops = new HashSet<ProductFop>(ticket.getFops());
        if (ticket.getProductCategory() == ProductCategory.MCO && (ticket.getMcoCategory() == MCOCategory.INFORMATION || ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING)) {
            fops.addAll(ticket.getRelatedProductFops());
        }
        return SalesReportHelper.isHasFop(fops, PaymentType.CREDIT_CARD_TCH);
    }

    private static boolean isPTA(TchTicket ticket) {
        if (ticket.getStatus() == ProductStatus.VOID) {
            return false;
        }
        HashSet<ProductFop> fops = new HashSet<ProductFop>(ticket.getFops());
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.INFORMATION) {
            fops.addAll(ticket.getRelatedProductFops());
        }
        return SalesReportHelper.isHasFop(fops, PaymentType.PTA);
    }

    private static boolean isCredit(TchTicket ticket) {
        if (ticket.getStatus() == ProductStatus.VOID) {
            return false;
        }
        HashSet<ProductFop> fops = new HashSet<ProductFop>(ticket.getFops());
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.INFORMATION) {
            fops.addAll(ticket.getRelatedProductFops());
        }
        return SalesReportHelper.isHasFop(fops, PaymentType.CREDIT);
    }

    static int getSchemeIndex(String carrierNumber) {
        if (AirProductHelper.isSpecialSchemeTourCode((String)carrierNumber)) {
            return 2;
        }
        if ("99A".equals(carrierNumber)) {
            return 1;
        }
        return 0;
    }

    static enum TchReportRegistriesSetType {
        REQUIRED,
        ADDITTIONAL;

    }
}

