/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BaseTchWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.SplitTicketsHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

class TchCashListWorksheetHandler
extends BaseTchWorksheetHandler<TchTicket> {
    TchCashListWorksheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<TchTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        List<TchReportItem> items = this.prepareItems(data.getTickets());
        if (items.size() == 0) {
            wb.removeSheetAt(wb.getSheetIndex((Sheet)sheet));
            return;
        }
        for (int n = 0; n < items.size() - 1; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)6, (int)8);
        }
        wb.setSheetName(wb.getSheetIndex((Sheet)sheet), "\u041d\u0410\u041b");
        int currentIndex = 7;
        int lineNumber = 1;
        StringBuilder summFare = new StringBuilder();
        StringBuilder summFareOut = new StringBuilder();
        StringBuilder summFareADM = new StringBuilder();
        StringBuilder summPenalty = new StringBuilder();
        StringBuilder summPenaltyADM = new StringBuilder();
        StringBuilder summComission = new StringBuilder();
        StringBuilder summComissionOut = new StringBuilder();
        StringBuilder summComissionADM = new StringBuilder();
        StringBuilder summAgs = new StringBuilder();
        StringBuilder summAgsADM = new StringBuilder();
        StringBuilder summAgsOut = new StringBuilder();
        StringBuilder summAgsDirect = new StringBuilder();
        StringBuilder summAgsDirectOut = new StringBuilder();
        StringBuilder summSummTch = new StringBuilder();
        StringBuilder summSummTchADM = new StringBuilder();
        StringBuilder summSummTchOut = new StringBuilder();
        StringBuilder summSummDirect = new StringBuilder();
        StringBuilder summSummDirectOut = new StringBuilder();
        StringBuilder summTaxTch = new StringBuilder();
        StringBuilder summTaxTchADM = new StringBuilder();
        for (TchReportItem item : items) {
            int originX = currentIndex;
            int originY = 1;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)1, (int)lineNumber);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)2, (String)item.carrierNumber);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)3, (String)item.carrierCode);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)4, (String)item.carrierName);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)6, (BigDecimal)item.fareADM);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)6, (BigDecimal)item.fare);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)3, (int)6, (BigDecimal)item.fareOut);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)7, (BigDecimal)item.penaltyADM);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)7, (BigDecimal)item.penalty);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)8, (BigDecimal)item.comissionADM);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)8, (BigDecimal)item.comission);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)3, (int)8, (BigDecimal)item.comissionOut);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)9, (BigDecimal)item.agsTchADM);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)9, (BigDecimal)item.agsTch);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)3, (int)9, (BigDecimal)item.agsTchOut);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)10, (BigDecimal)item.agsDirect);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)3, (int)10, (BigDecimal)item.agsDirectOut);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)13, (BigDecimal)item.taxTchADM);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)13, (BigDecimal)item.taxTch);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)11, (BigDecimal)item.summTchADM);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)11, (BigDecimal)item.summTch);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)3, (int)11, (BigDecimal)item.summTchOut);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)2, (int)12, (BigDecimal)item.summDirect);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)3, (int)12, (BigDecimal)item.summDirectOut);
            this.addSummItem(summFareADM, item.fareADM, "F", currentIndex);
            this.addSummItem(summFare, item.fare, "F", currentIndex + 1);
            this.addSummItem(summFareOut, item.fareOut, "F", currentIndex + 2);
            this.addSummItem(summPenaltyADM, item.penaltyADM, "G", currentIndex);
            this.addSummItem(summPenalty, item.penalty, "G", currentIndex + 1);
            this.addSummItem(summComissionADM, item.comissionADM, "H", currentIndex);
            this.addSummItem(summComission, item.comission, "H", currentIndex + 1);
            this.addSummItem(summComissionOut, item.comissionOut, "H", currentIndex + 2);
            this.addSummItem(summAgsADM, item.agsTchADM, "I", currentIndex);
            this.addSummItem(summAgs, item.agsTch, "I", currentIndex + 1);
            this.addSummItem(summAgsOut, item.agsTchOut, "I", currentIndex + 2);
            this.addSummItem(summAgsDirect, item.agsDirect, "J", currentIndex + 1);
            this.addSummItem(summAgsDirectOut, item.agsDirect, "J", currentIndex + 2);
            this.addSummItem(summSummTchADM, item.summTchADM, "K", currentIndex);
            this.addSummItem(summSummTch, item.summTch, "K", currentIndex + 1);
            this.addSummItem(summSummTchOut, item.summTchOut, "K", currentIndex + 2);
            this.addSummItem(summSummDirect, item.summDirect, "L", currentIndex + 1);
            this.addSummItem(summSummDirectOut, item.summDirectOut, "L", currentIndex + 2);
            this.addSummItem(summTaxTchADM, item.taxTchADM, "M", currentIndex);
            this.addSummItem(summTaxTch, item.taxTch, "M", currentIndex + 1);
            currentIndex += 3;
            ++lineNumber;
        }
        int originX = currentIndex;
        int originY = 1;
        this.updateField(sheet, originX, originY, 1, 6, summFareADM);
        this.updateField(sheet, originX, originY, 2, 6, summFare);
        this.updateField(sheet, originX, originY, 3, 6, summFareOut);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)4, (int)6, (String)String.format("=F%s+F%s", Integer.toString(currentIndex), Integer.toString(currentIndex + 1)));
        this.updateField(sheet, originX, originY, 1, 7, summPenaltyADM);
        this.updateField(sheet, originX, originY, 2, 7, summPenalty);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)4, (int)7, (String)String.format("=G%s+G%s", Integer.toString(currentIndex), Integer.toString(currentIndex + 1)));
        this.updateField(sheet, originX, originY, 1, 8, summComissionADM);
        this.updateField(sheet, originX, originY, 2, 8, summComission);
        this.updateField(sheet, originX, originY, 3, 8, summComissionOut);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)4, (int)8, (String)String.format("=H%s+H%s", Integer.toString(currentIndex), Integer.toString(currentIndex + 1)));
        this.updateField(sheet, originX, originY, 1, 9, summAgsADM);
        this.updateField(sheet, originX, originY, 2, 9, summAgs);
        this.updateField(sheet, originX, originY, 3, 9, summAgsOut);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)4, (int)9, (String)String.format("=I%s+I%s", Integer.toString(currentIndex), Integer.toString(currentIndex + 1)));
        this.updateField(sheet, originX, originY, 2, 10, summAgsDirect);
        this.updateField(sheet, originX, originY, 3, 10, summAgsDirectOut);
        this.updateField(sheet, originX, originY, 1, 11, summSummTchADM);
        this.updateField(sheet, originX, originY, 2, 11, summSummTch);
        this.updateField(sheet, originX, originY, 3, 11, summSummTchOut);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)4, (int)11, (String)String.format("=K%s+K%s", Integer.toString(currentIndex), Integer.toString(currentIndex + 1)));
        this.updateField(sheet, originX, originY, 2, 12, summSummDirect);
        this.updateField(sheet, originX, originY, 3, 12, summSummDirectOut);
        this.updateField(sheet, originX, originY, 1, 13, summTaxTchADM);
        this.updateField(sheet, originX, originY, 2, 13, summTaxTch);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)originX, (int)originY, (int)4, (int)13, (String)String.format("=M%s+M%s", Integer.toString(currentIndex), Integer.toString(currentIndex + 1)));
        if (Boolean.TRUE.equals(globalData.get("key-is-has-cc"))) {
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)3, (int)1, (String)"=\u041f\u041a!A3");
        } else {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)3, (int)1, (BigDecimal)BigDecimal.ZERO);
        }
    }

    private List<TchReportItem> prepareItems(Collection<TchTicket> tickets) throws Exception {
        ArrayList<TchReportItem> result = new ArrayList<TchReportItem>();
        for (TchTicket ticket : tickets) {
            ProductStatus status;
            BigDecimal fare;
            BigDecimal xtTax;
            BigDecimal tchTax;
            BigDecimal penalty;
            TchReportItem item;
            if (ticket.isConjunctedTicket() || ticket.isAdditionalSegment()) continue;
            BigDecimal commission = this.getBigDecimal(ticket.getVendorEquivalentCommission());
            if (ticket.getFareCash().doubleValue() == 0.0 && ticket.getXtTaxCash().doubleValue() == 0.0 && ticket.getTchTaxCash().doubleValue() == 0.0 && commission.compareTo(BigDecimal.ZERO) == 0 && (!ticket.isAgencyMemo() || ticket.getPenaltyCash().compareTo(BigDecimal.ZERO) <= 0)) continue;
            boolean agencyMemo = ticket.isAgencyMemo();
            boolean isDirect = ticket.isDirectContract();
            BigDecimal totalFare = ticket.getFareCash().add(ticket.getFareCC());
            if (totalFare.doubleValue() > 0.0) {
                commission = commission.multiply(ticket.getFareCash()).divide(totalFare, 2, 1);
            }
            boolean vatIncluded = ticket.isVatIncluded();
            boolean penaltyMco = ticket.getProductCategory() == ProductCategory.MCO && (ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING);
            boolean otherMco = !penaltyMco && ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE;
            String carrierNumber = ticket.getCarrierNumber();
            if (carrierNumber == null) {
                carrierNumber = "";
            }
            String[] carrierCodes = ticket.getCarrierCodes();
            String[] carrierNames = ticket.getCarrierNames();
            if (carrierCodes == null) {
                carrierCodes = new String[]{};
                carrierNames = new String[]{};
            }
            if (AirProductHelper.isFewCarriersAggreementCarrierNumber((String)carrierNumber)) {
                item = new TchReportItem();
                item.carrierNumber = carrierNumber;
                item.carrierCode = carrierCodes[0];
                item.carrierName = carrierNames[0];
                penalty = ticket.getPenaltyCash();
                tchTax = ticket.getTchTaxCash();
                xtTax = ticket.getXtTaxCash();
                fare = this.getBigDecimal(ticket.getFareCash());
                status = ticket.getStatus();
                if (penaltyMco) {
                    fare = BigDecimal.ZERO;
                    BigDecimal bigDecimal = penalty = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? ticket.getFareCash().negate() : ticket.getFareCash();
                }
                if (otherMco) {
                    fare = BigDecimal.ZERO;
                    xtTax = MiscUtil.sum((BigDecimal[])new BigDecimal[]{ticket.getXtTaxCash(), ticket.getFareCash()});
                }
                this.initializeItem(item, status, fare, penalty, tchTax, xtTax, commission, isDirect, vatIncluded, penaltyMco, agencyMemo);
                this.addItem(item, result);
                continue;
            }
            item = new TchReportItem();
            item.carrierNumber = carrierNumber;
            item.carrierCode = "";
            item.carrierName = "";
            if (AirProductHelper.isSpecialSchemeTourCode((String)carrierNumber) && carrierCodes.length != 0) {
                int n;
                StringBuilder sbCodes = new StringBuilder(carrierCodes[0]);
                StringBuilder sbNames = new StringBuilder(carrierNames[0]);
                for (n = 1; n < carrierCodes.length; ++n) {
                    sbCodes.append("/").append(carrierCodes[n]);
                }
                for (n = 1; n < carrierNames.length; ++n) {
                    sbNames.append("/").append(carrierNames[n]);
                }
                item.carrierCode = sbCodes.toString();
                item.carrierName = sbNames.toString();
            } else {
                item.carrierCode = ticket.getCarrierCode();
                item.carrierName = ticket.getCarrierName();
            }
            penalty = ticket.getPenaltyCash();
            tchTax = ticket.getTchTaxCash();
            xtTax = ticket.getXtTaxCash();
            fare = this.getBigDecimal(ticket.getFareCash());
            status = ticket.getStatus();
            if (penaltyMco) {
                fare = BigDecimal.ZERO;
                BigDecimal bigDecimal = penalty = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? ticket.getFareCash().negate() : ticket.getFareCash();
            }
            if (otherMco) {
                fare = BigDecimal.ZERO;
                xtTax = MiscUtil.sum((BigDecimal[])new BigDecimal[]{ticket.getXtTaxCash(), ticket.getFareCash()});
            }
            if (ticket.isAgencyMemo()) {
                penalty = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? ticket.getPenaltyCash().negate() : ticket.getPenaltyCash();
            }
            this.initializeItem(item, status, fare, penalty, tchTax, xtTax, commission, isDirect, vatIncluded, penaltyMco, agencyMemo);
            this.addItem(item, result);
        }
        Collections.sort(result, new Comparator<TchReportItem>(){

            @Override
            public int compare(TchReportItem item1, TchReportItem item2) {
                if (item1 == null && item2 == null) {
                    return 0;
                }
                int compare = 0;
                if (item1 != null) {
                    compare = SplitTicketsHelper.getSchemeIndex(item1.carrierNumber) - SplitTicketsHelper.getSchemeIndex(item2.carrierNumber);
                }
                if (compare != 0) {
                    return compare;
                }
                compare = TextUtil.compare((String)(item1 != null ? item1.carrierNumber : null), (String)(item2 != null ? item2.carrierNumber : null), (boolean)false, (boolean)true);
                if (compare != 0) {
                    return compare;
                }
                compare = TextUtil.compare((String)(item1 != null ? item1.carrierCode : null), (String)(item2 != null ? item2.carrierCode : null), (boolean)false, (boolean)true);
                if (compare != 0) {
                    return compare;
                }
                return TextUtil.compare((String)(item1 != null ? item1.carrierName : null), (String)(item2 != null ? item2.carrierName : null), (boolean)false, (boolean)true);
            }
        });
        return result;
    }

    private void addItem(TchReportItem item, List<TchReportItem> result) throws Exception {
        Object item3 = null;
        for (TchReportItem item2 : result) {
            if (!item.equals(item2)) continue;
            item3 = item2;
            break;
        }
        if (item3 == null) {
            result.add(item);
            return;
        }
        for (Field field : item3.getClass().getDeclaredFields()) {
            Object obj = field.get(item);
            Object obj3 = field.get(item3);
            if (!(obj instanceof BigDecimal) || !(obj3 instanceof BigDecimal) && obj3 != null) continue;
            BigDecimal fieldValue = (BigDecimal)obj;
            if (obj3 == null) {
                field.set(item3, fieldValue);
                continue;
            }
            BigDecimal fieldValue3 = (BigDecimal)obj3;
            field.set(item3, fieldValue.add(fieldValue3));
        }
    }

    private void initializeItem(TchReportItem item, ProductStatus status, BigDecimal fare, BigDecimal penalty, BigDecimal tchTax, BigDecimal xtTax, BigDecimal commission, boolean isDirect, boolean vatIncluded, boolean penaltyMco, boolean agencyMemo) {
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            item.fare = fare.negate();
            item.comission = this.getNonZeroBigDecimal(commission.negate());
            if (!vatIncluded) {
                item.fareOut = this.getNonZeroBigDecimal(fare.negate());
                item.comissionOut = this.getNonZeroBigDecimal(commission.negate());
                item.agsTchOut = !isDirect ? this.getNonZeroBigDecimal(xtTax.negate()) : null;
                item.agsDirectOut = isDirect ? this.getNonZeroBigDecimal(xtTax.negate()) : null;
            }
            item.taxTch = this.getNonZeroBigDecimal(tchTax.negate());
            item.penalty = this.getNonZeroBigDecimal(penalty);
            item.agsTch = !isDirect ? this.getNonZeroBigDecimal(xtTax.negate()) : null;
            item.agsDirect = isDirect ? this.getNonZeroBigDecimal(xtTax.negate()) : null;
            BigDecimal bigDecimal = item.summTch = !isDirect ? this.getNonZeroBigDecimal(fare.negate(), penalty, commission) : null;
            if (!vatIncluded) {
                item.summTchOut = !isDirect ? this.getNonZeroBigDecimal(fare.negate(), penalty, commission) : null;
            }
            BigDecimal bigDecimal2 = item.summDirect = isDirect ? this.getNonZeroBigDecimal(fare.negate(), penalty, commission) : null;
            if (!vatIncluded) {
                item.summDirectOut = isDirect ? this.getNonZeroBigDecimal(fare.negate(), penalty, commission) : null;
            }
        } else if (agencyMemo) {
            item.fareADM = fare;
            item.comissionADM = this.getNonZeroBigDecimal(commission);
            item.taxTchADM = this.getNonZeroBigDecimal(tchTax);
            item.agsTchADM = this.getNonZeroBigDecimal(xtTax);
            item.penaltyADM = this.getNonZeroBigDecimal(penalty);
            item.summTchADM = this.getNonZeroBigDecimal(fare, penalty, this.getBigDecimal(commission).negate());
        } else {
            item.fare = fare;
            item.comission = this.getNonZeroBigDecimal(commission);
            if (!vatIncluded) {
                item.fareOut = fare;
                item.comissionOut = this.getNonZeroBigDecimal(commission);
                item.agsTchOut = !isDirect ? this.getNonZeroBigDecimal(xtTax) : null;
                item.agsDirectOut = isDirect ? this.getNonZeroBigDecimal(xtTax) : null;
            }
            item.taxTch = this.getNonZeroBigDecimal(tchTax);
            item.agsTch = !isDirect ? this.getNonZeroBigDecimal(xtTax) : null;
            item.agsDirect = isDirect ? this.getNonZeroBigDecimal(xtTax) : null;
            item.penalty = this.getNonZeroBigDecimal(penalty);
            BigDecimal bigDecimal = item.summTch = !isDirect ? this.getNonZeroBigDecimal(fare, penalty, this.getBigDecimal(commission).negate()) : null;
            if (!vatIncluded) {
                item.summTchOut = !isDirect ? this.getNonZeroBigDecimal(fare, penalty, this.getBigDecimal(commission).negate()) : null;
            }
            BigDecimal bigDecimal3 = item.summDirect = isDirect ? this.getNonZeroBigDecimal(fare, penalty, this.getBigDecimal(commission).negate()) : null;
            if (!vatIncluded) {
                item.summDirectOut = isDirect ? this.getNonZeroBigDecimal(fare, penalty, this.getBigDecimal(commission).negate()) : null;
            }
        }
    }

    class TchReportItem {
        String carrierNumber;
        String carrierCode;
        String carrierName;
        BigDecimal fareADM;
        BigDecimal fare;
        BigDecimal fareOut;
        BigDecimal penaltyADM;
        BigDecimal penalty;
        BigDecimal comission;
        BigDecimal comissionOut;
        BigDecimal comissionADM;
        BigDecimal agsTch;
        BigDecimal agsTchOut;
        BigDecimal agsTchADM;
        BigDecimal agsDirect;
        BigDecimal agsDirectOut;
        BigDecimal summTch;
        BigDecimal summTchOut;
        BigDecimal summTchADM;
        BigDecimal summDirect;
        BigDecimal summDirectOut;
        BigDecimal taxTch;
        BigDecimal taxTchADM;

        TchReportItem() {
        }

        public boolean equals(Object obj) {
            String name2;
            if (!(obj instanceof TchReportItem)) {
                return false;
            }
            TchReportItem item2 = (TchReportItem)obj;
            String number1 = this.carrierNumber == null ? "" : this.carrierNumber;
            String number2 = item2.carrierNumber == null ? "" : item2.carrierNumber;
            String code1 = this.carrierCode == null ? "" : this.carrierCode;
            String code2 = item2.carrierCode == null ? "" : item2.carrierCode;
            String name1 = this.carrierName == null ? "" : this.carrierName;
            String string = name2 = item2.carrierName == null ? "" : item2.carrierName;
            return number1.equals(number2) && code1.equals(code2) && name1.equals(name2);
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.carrierNumber, this.carrierCode, this.carrierName});
        }
    }
}

