/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BaseTchCCListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;

class TchPKListWorksheetHandler
extends BaseTchCCListWorksheetHandler {
    private static final CardVendor[] CARD_VENDORS = new CardVendor[]{CardVendor.VISA, CardVendor.MASTERCARD, CardVendor.AMEX, CardVendor.JCB, CardVendor.DINERS_CLUB, CardVendor.MIR};
    private static BaseTchCCListWorksheetHandler.CCListTicketHandler pkHandler = new BaseTchCCListWorksheetHandler.CCListTicketHandler(){

        @Override
        public String getSheetName() {
            return "\u041f\u041a(\u0422\u041a\u041f)";
        }

        @Override
        public BigDecimal getFare(TchTicket ticket) {
            return ticket.getFarePK();
        }

        @Override
        public BigDecimal getXtTax(TchTicket ticket) {
            return ticket.getXtTaxPK();
        }

        @Override
        public BigDecimal getTchTax(TchTicket ticket) {
            return ticket.getTchTaxPK();
        }

        @Override
        public BigDecimal getPenalty(TchTicket ticket) {
            return ticket.getPenaltyPK();
        }

        @Override
        public BigDecimal getClientFee(TchTicket ticket) {
            return ticket.getPkClientFeeEquivalentValue();
        }
    };

    TchPKListWorksheetHandler() {
        super(pkHandler);
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<TchTicket> data, Map<String, Object> globalData) throws Exception {
        BigDecimal value;
        int rowIndex;
        super.fill(wb, sheet, data, globalData);
        if (wb.getSheet(pkHandler.getSheetName()) == null) {
            return;
        }
        HashMap<CardVendor, BigDecimal> clientFees = new HashMap<CardVendor, BigDecimal>();
        HashMap<CardVendor, BigDecimal> tchFees = new HashMap<CardVendor, BigDecimal>();
        for (TchTicket ticket : data.getTickets()) {
            CardVendor cardVendor = ticket.getCardVendor();
            if (cardVendor == null) continue;
            clientFees.put(cardVendor, MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)clientFees.get(cardVendor), ticket.getPkClientFeeEquivalentValue()}));
            tchFees.put(cardVendor, MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)tchFees.get(cardVendor), ticket.getPkFeeValue()}));
        }
        if (data.getTickets().isEmpty()) {
            return;
        }
        HSSFCell cell = ExcelUtils.findCell((HSSFSheet)sheet, (String)"CLIENT_FEE_TABLE");
        cell.setCellType(3);
        int startIndex = rowIndex = cell.getRowIndex();
        ArrayList<String> airFeeRows = new ArrayList<String>();
        for (CardVendor vendor : CARD_VENDORS) {
            value = (BigDecimal)clientFees.get(vendor);
            if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                ExcelUtils.removeRow((HSSFSheet)sheet, (int)rowIndex);
                ExcelUtils.removeRow((HSSFSheet)sheet, (int)rowIndex);
                continue;
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)7, (int)2, (int)1, (BigDecimal)value);
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)7, (int)2, (int)6, (String)String.format("=G%s", Integer.toString(rowIndex + 2)));
            airFeeRows.add(String.format("G%s", Integer.toString(rowIndex + 2)));
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + 1, 4, 4));
            ++rowIndex;
            ++rowIndex;
        }
        if (!airFeeRows.isEmpty()) {
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)7, (int)2, (int)1, (String)String.format("=%s", CollectionUtil.collectionToString(airFeeRows, (String)"+", (boolean)false)));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)7, (int)2, (int)6, (String)String.format("=G%s", Integer.toString(rowIndex + 2)));
        }
        sheet.addMergedRegion(new CellRangeAddress(startIndex, rowIndex + 2, 0, 0));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(startIndex + 1), (int)1, (int)1, (int)1, (String)"---");
        sheet.addMergedRegion(new CellRangeAddress(startIndex, rowIndex + 2, 1, 1));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(startIndex + 1), (int)1, (int)1, (int)2, (String)"99C");
        sheet.addMergedRegion(new CellRangeAddress(startIndex, rowIndex + 2, 2, 2));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(startIndex + 1), (int)1, (int)1, (int)3, (String)"---");
        sheet.addMergedRegion(new CellRangeAddress(startIndex, rowIndex + 2, 3, 3));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(startIndex + 1), (int)1, (int)1, (int)4, (String)"----------");
        sheet.getRow(rowIndex + 2).setHeightInPoints(20.0f);
        cell = ExcelUtils.findCell((HSSFSheet)sheet, (String)"TCH_FEE_TABLE");
        cell.setCellType(3);
        startIndex = rowIndex = cell.getRowIndex();
        ArrayList<String> feeRows = new ArrayList<String>();
        for (CardVendor vendor : CARD_VENDORS) {
            value = (BigDecimal)tchFees.get(vendor);
            if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                ExcelUtils.removeRow((HSSFSheet)sheet, (int)rowIndex);
                continue;
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)6, (int)1, (int)1, (BigDecimal)value);
            feeRows.add(String.format("F%s", Integer.toString(rowIndex + 1)));
            ++rowIndex;
        }
        if (!feeRows.isEmpty()) {
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)6, (int)1, (int)1, (String)String.format("=%s", CollectionUtil.collectionToString(feeRows, (String)"+", (boolean)false)));
        }
        sheet.addMergedRegion(new CellRangeAddress(startIndex, rowIndex, 0, 3));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(startIndex + 1), (int)1, (int)1, (int)1, (String)"\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0440\u0430\u0431\u043e\u0442 \u0438 \u0443\u0441\u043b\u0443\u0433 \u043f\u043e \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0438 \u0443\u0447\u0435\u0442\u0443 \u043f\u0440\u043e\u0434\u0430\u0436 \u043f\u043e \u041f\u041f (\u0441 \u043a\u043e\u0434\u043e\u043c \u041f\u041a) \u0438 \u043f\u043e \u041f\u041a \u0441 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u043c \u043a\u043e\u0434\u043e\u043c 99\u0421 ");
    }
}

