/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BaseTchWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BatchTotalInfo;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.CashierInfo;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

class TchSummaryListWorksheetHandler
extends BaseTchWorksheetHandler<TchTicket> {
    TchSummaryListWorksheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<TchTicket> data, Map<String, Object> globalData) throws Exception {
        int n;
        List totalInfos = (List)globalData.get("key-summary-data");
        if (totalInfos == null || totalInfos.isEmpty()) {
            wb.removeSheetAt(wb.getSheetIndex((Sheet)sheet));
            return;
        }
        wb.setSheetName(wb.getSheetIndex((Sheet)sheet), L10nResourcesManager.createL10nMessage((String)Messages.TchSummaryListWorksheetHandler_sheetName, (Object[])new Object[0]).toString());
        int size = totalInfos.size();
        for (n = 1; n < size; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)(10 * n - 10), (int)(10 * n - 1));
        }
        for (n = 0; n < size; ++n) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(10 * n + 1), (int)1, (int)1, (int)1, (String)((BatchTotalInfo)totalInfos.get(n)).getGroupName());
        }
        int index = 5;
        for (int n2 = 0; n2 < size; ++n2) {
            BatchTotalInfo totalInfo = (BatchTotalInfo)totalInfos.get(n2);
            int totalTicketNo = totalInfo.getTotalTicketNo();
            int totalCouponNo = totalInfo.getTotalCouponNo();
            BigDecimal totalCash = totalInfo.getTotalCash();
            BigDecimal totalCard = totalInfo.getTotalCard();
            BigDecimal totalVZ = totalInfo.getTotalVZ();
            BigDecimal totalKR = totalInfo.getTotalKR();
            BigDecimal totalPTA = totalInfo.getTotalPTA();
            int originX = index;
            int originY = 1;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)4, (BigDecimal)this.getNonZeroBigDecimal(totalCash));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)7, (BigDecimal)this.getNonZeroBigDecimal(totalCard));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)5, (BigDecimal)this.getNonZeroBigDecimal(totalKR));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)6, (BigDecimal)this.getNonZeroBigDecimal(totalVZ));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)8, (BigDecimal)this.getNonZeroBigDecimal(totalPTA));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)1, (int)totalTicketNo);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)2, (int)totalCouponNo);
            List<CashierInfo> cashierInfos = totalInfo.getCashierInfos();
            Collections.sort(cashierInfos, new Comparator<CashierInfo>(){

                @Override
                public int compare(CashierInfo o1, CashierInfo o2) {
                    int diffBatchNo1 = o1.getBatchNo() - o2.getBatchNo();
                    if (diffBatchNo1 != 0) {
                        return diffBatchNo1;
                    }
                    int diffVal = TextUtil.compare((String)o1.getValidator(), (String)o2.getValidator(), (boolean)false, (boolean)true);
                    if (diffVal != 0) {
                        return diffVal;
                    }
                    return TextUtil.compare((String)o1.getCashier(), (String)o2.getCashier(), (boolean)false, (boolean)true);
                }
            });
            int infoSize = cashierInfos.size();
            for (int m = 0; m < infoSize; ++m) {
                if (m != 0) {
                    ExcelUtils.copyRows((HSSFSheet)sheet, (int)(index + 2 + m), (int)(index + 2 + m));
                }
                originX = index + 4 + m;
                originY = 1;
                CashierInfo info = cashierInfos.get(m);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)1, (int)info.getBatchNo());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)2, (String)info.getValidator());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)3, (String)info.getCashier());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)4, (int)info.getTicketsCount());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)originX, (int)originY, (int)1, (int)5, (int)info.getCouponsCount());
            }
            index = index + 9 + infoSize;
        }
    }
}

