/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.u6;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class U6SalesReportTicket
extends BaseSalesReportTicket
implements Comparable<U6SalesReportTicket> {
    private static final long serialVersionUID = -3254657649204276389L;
    private final Product product;
    private Commission commission = null;
    private Double commissionRate = 0.0;
    private BigDecimal fees = BigDecimal.ZERO;
    private BigDecimal fuelFee = BigDecimal.ZERO;
    private String scn = null;
    private boolean duplicate = false;
    private String fopCodes = null;
    private String flightNumber = null;
    private double luggageAmount = 0.0;
    private int conjunctionCount = 0;
    private String itinerary = null;
    private TransportationType transportationType = null;
    private String tariffCodes = null;
    private Date sellDate = null;
    private U6SalesReportTicket exchangedTicket = null;
    private BigDecimal addFareCommission = BigDecimal.ZERO;
    private String relatedTicketNumber = null;
    private boolean mtd = false;

    public U6SalesReportTicket(Product aProduct, List<Message> messages) throws Exception {
        super(aProduct, messages);
        this.product = aProduct;
        if (aProduct.getProductCategory() == ProductCategory.AIR) {
            this.fillCommissions(this.product);
            for (Object tax : this.product.getTaxes()) {
                if (tax.getCode() == null || tax.getEquivalentAmount() == null) continue;
                if (!tax.getCode().equalsIgnoreCase("YQ")) {
                    this.fees = this.fees.add(tax.getEquivalentAmount());
                    continue;
                }
                this.fuelFee = this.fuelFee.add(tax.getEquivalentAmount());
            }
            this.tariffCodes = this.product.getSegmentTariffs().stream().map(SegmentTariff::getSegments).flatMap(Collection::stream).map(Segment::getFareBasis).filter(TextUtil::nonBlank).distinct().collect(Collectors.joining(","));
            if (this.isExchangeTicket() || this.isRefundTicket()) {
                if (aProduct.getPenalty() != null) {
                    this.penalty = aProduct.getPenalty();
                }
                if (this.penalty == null) {
                    Collection mcos = AirProductHelper.getMcoByRelatedProduct((Product)this.product);
                    for (Product mco : mcos) {
                        if (mco.getMcoCategory() != MCOCategory.REBOOKING && mco.getMcoCategory() != MCOCategory.PENALTY) continue;
                        this.penalty = AirProductHelper.getEquivalentFare((Product)mco);
                        break;
                    }
                }
            }
        }
        if (aProduct.getProductCategory() == ProductCategory.MCO) {
            this.fillCommissions(this.product);
            Optional first = this.product.getRelatedProducts().stream().findFirst();
            first.ifPresent(p -> {
                this.relatedTicketNumber = p.getCarrierNumber() + " " + p.getSystemNumber();
            });
        }
        this.duplicate = this.product.isDuplicate();
        this.status = this.product.getStatus();
        if (this.product.getScns() != null && !this.product.getScns().isEmpty()) {
            this.scn = (String)this.product.getScns().get(0);
        }
        this.conjunctionCount = this.product.getConjCount();
        this.transportationType = AirProductHelper.getTransportationType((Product)this.product);
        this.itinerary = AirProductHelper.getRouteLine((Product)aProduct);
        this.sellDate = this.product.getIssueDate();
        if (this.isExchangeTicket()) {
            this.exchangedTicket = new U6SalesReportTicket(this.product.getPreviousProduct(), messages);
            if (this.exchangedTicket.getCommission() != null && this.exchangedTicket.getCommission().getEquivalentAmount() != null && this.getCommission() != null && this.getCommission().getEquivalentAmount() != null) {
                this.addFareCommission = this.exchangedTicket.getCommission().getEquivalentAmount().subtract(this.getCommission().getEquivalentAmount());
            }
        }
        block2: for (SegmentTariff st : this.product.getSegmentTariffs()) {
            for (Segment s : st.getSegments()) {
                if (TextUtil.isBlank((String)s.getFlightNo())) continue;
                this.flightNumber = s.getFlightNo();
                break block2;
            }
        }
        if (this.product.getLuggageWeight() != null) {
            this.luggageAmount = this.product.getLuggageWeight();
        }
        for (ProductFop vendorFop : AirProductHelper.getVendorFops((Product)this.product)) {
            if (vendorFop.getType() != PaymentType.CREDIT && vendorFop.getType() != PaymentType.MTD) continue;
            this.mtd = true;
        }
    }

    public Commission getCommission() {
        return this.commission;
    }

    private void fillCommissions(Product product) {
        if (product.getStatus() != ProductStatus.VOID) {
            Iterator iterator = AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR).iterator();
            while (iterator.hasNext()) {
                Commission aCommission;
                this.commission = aCommission = (Commission)iterator.next();
                this.commissionRate = aCommission.getRate();
            }
        }
    }

    public String getFullTicketNumber() {
        return this.product.getCarrierNumber() + " " + this.getTicketNumber();
    }

    public BigDecimal getFee() {
        return this.fees;
    }

    public BigDecimal getFuelFee() {
        return this.fuelFee;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public boolean isVoidTicket() {
        return this.status == ProductStatus.VOID;
    }

    public String getRelatedTicketNumber() {
        return this.relatedTicketNumber;
    }

    public boolean isMtd() {
        return this.mtd;
    }

    public boolean isSellTicket() {
        return this.status == ProductStatus.SELL && this.product.getPreviousProduct() == null;
    }

    public boolean isExchangeTicket() {
        return this.status == ProductStatus.SELL && this.product.getPreviousProduct() != null && this.product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
    }

    public boolean isRefundTicket() {
        return this.status == ProductStatus.REFUND;
    }

    public boolean isPenaltyMCO() {
        return this.status == ProductStatus.SELL && this.product.getProductCategory() == ProductCategory.MCO && this.product.getMcoCategory() == MCOCategory.PENALTY;
    }

    public boolean isVVL() {
        return this.transportationType != null && this.transportationType == TransportationType.DOMESTIC;
    }

    public boolean isMVL() {
        return this.transportationType != null && this.transportationType == TransportationType.INTERNATIONAL;
    }

    public BigDecimal getPrice() {
        return AirProductHelper.calculateTotalEquivalentFare((Product)this.product);
    }

    public String getScn() {
        return this.scn;
    }

    public String getFopCodes() {
        if (this.fops == null) {
            return null;
        }
        if (this.fopCodes == null) {
            StringBuilder result = new StringBuilder();
            for (ProductFop fop : this.fops) {
                if (fop == null || fop.getType() == null) continue;
                String fopType = fop.getType().name().substring(0, 2);
                if (result.toString().indexOf(fopType) >= 0) continue;
                result.append(fopType).append(";");
            }
            this.fopCodes = result.toString();
            if (this.fopCodes.endsWith(";")) {
                this.fopCodes = this.fopCodes.substring(0, this.fopCodes.length() - 1);
            }
        }
        return this.fopCodes;
    }

    public int getConjunctionCount() {
        return this.conjunctionCount;
    }

    public String getAgentGDSCode() {
        Person agent;
        EntityContainer container = EntityStorage.get().resolve(this.getAgent());
        if (container != null && (agent = (Person)container.getEntity()).getGdsReferences().stream().findFirst().isPresent()) {
            return ((GdsReference)agent.getGdsReferences().stream().findFirst().get()).getReference();
        }
        return "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e";
    }

    public boolean isCashFop() {
        boolean result = false;
        for (ProductFop vendorFop : AirProductHelper.getVendorContractRelation((Product)this.product).getFops()) {
            if (vendorFop.getType() != PaymentType.CASH) continue;
            result = true;
            break;
        }
        return result;
    }

    public Product getSourceProduct() {
        return this.product;
    }

    public String getItinerary() {
        return this.itinerary;
    }

    public String getTariffCodes() {
        return this.tariffCodes;
    }

    public Date getSellDate() {
        return this.sellDate;
    }

    public U6SalesReportTicket getExchangedTicket() {
        return this.exchangedTicket;
    }

    public Double getCommissionRate() {
        return this.commissionRate;
    }

    public BigDecimal getAddFareCommission() {
        return this.addFareCommission;
    }

    @Override
    public int compareTo(U6SalesReportTicket o) {
        return this.getTicketNumber().compareTo(o.getTicketNumber());
    }

    public int hashCode() {
        return MiscUtil.hash((Object[])new Object[]{this.ticketNumber});
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof U6SalesReportTicket)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        U6SalesReportTicket item2 = (U6SalesReportTicket)obj;
        return TextUtil.isSame((String)this.ticketNumber, (String)item2.getTicketNumber());
    }

    public String getFlightNumber() {
        return this.flightNumber;
    }

    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    public double getLuggageAmount() {
        return this.luggageAmount;
    }
}

