/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.u6;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.finance.VendorReportPaymentType;
import com.gridnine.xtrip.common.model.helpers.BillingTransactionHelper;
import com.gridnine.xtrip.common.model.support.reports.ReportCreditBankTransferOrderInfo;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.BaseU6ReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.U6SalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.U6SalesSummaryReportItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class U6SalesSummaryReportWorksheetHandler
extends BaseU6ReportWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<U6SalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        ReportParameters params = (ReportParameters)globalData.get("key-report-params");
        BigDecimal balanceStart = BillingTransactionHelper.calculateBillingTransactionsSum((ContractType)ContractType.VENDOR, (EntityReference)params.getAgency(), (EntityReference)params.getBlankOwner(), null, (BillingTransactionCategory)BillingTransactionCategory.DEBIT, (BillingTransactionStatus)BillingTransactionStatus.ACTIVE, null, (Date)params.getPeriodBegin());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)10, (int)6, (BigDecimal)balanceStart, (boolean)true);
        HashMap salesSummaryItems = (HashMap)globalData.get("SUMMARY_INFO");
        U6SalesSummaryReportItem vatPresentSellData = (U6SalesSummaryReportItem)salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_PRESENT_SELL.name());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)12, (int)4, (double)vatPresentSellData.getTotalTariff(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)14, (int)4, (double)vatPresentSellData.getTotalFuelFee(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)15, (int)4, (double)vatPresentSellData.getTotalFee(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)16, (int)4, (double)vatPresentSellData.getTotalPenalty(), (boolean)true);
        U6SalesSummaryReportItem vatAbsentSellData = (U6SalesSummaryReportItem)salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_ABSENT_SELL.name());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)12, (int)5, (double)vatAbsentSellData.getTotalTariff(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)14, (int)5, (double)vatAbsentSellData.getTotalFuelFee(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)15, (int)5, (double)vatAbsentSellData.getTotalFee(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)16, (int)5, (double)vatAbsentSellData.getTotalPenalty(), (boolean)true);
        U6SalesSummaryReportItem vatPresentRefundData = (U6SalesSummaryReportItem)salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_PRESENT_REFUND.name());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)18, (int)4, (double)vatPresentRefundData.getTotalTariff(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)20, (int)4, (double)vatPresentRefundData.getTotalFuelFee(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)21, (int)4, (double)vatPresentRefundData.getTotalFee(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)22, (int)4, (double)vatPresentRefundData.getTotalPenalty(), (boolean)true);
        U6SalesSummaryReportItem vatAbsentRefundData = (U6SalesSummaryReportItem)salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_ABSENT_REFUND.name());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)18, (int)5, (double)vatAbsentRefundData.getTotalTariff(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)20, (int)5, (double)vatAbsentRefundData.getTotalFuelFee(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)21, (int)5, (double)vatAbsentRefundData.getTotalFee(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)22, (int)5, (double)vatAbsentRefundData.getTotalPenalty(), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)26, (int)4, (double)(vatPresentSellData.getTotalCommission() - vatPresentRefundData.getTotalCommission()), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)26, (int)5, (double)(vatAbsentSellData.getTotalCommission() - vatAbsentRefundData.getTotalCommission()), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)28, (int)4, (double)(vatPresentSellData.getTotalMtdCommission() - vatPresentRefundData.getTotalMtdCommission()), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)28, (int)5, (double)(vatAbsentSellData.getTotalMtdCommission() - vatAbsentRefundData.getTotalMtdCommission()), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)33, (int)4, (double)(vatPresentSellData.getTotalMtdValue() - vatPresentRefundData.getTotalMtdValue()), (boolean)true);
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)33, (int)5, (double)(vatAbsentSellData.getTotalMtdValue() - vatAbsentRefundData.getTotalMtdValue()), (boolean)true);
        if (globalData.get("key-bank-transfer-orders-list") != null) {
            List btos = (List)globalData.get("key-bank-transfer-orders-list");
            int totalBtoRows = 0;
            if (btos.size() > 4) {
                sheet.shiftRows(40, 50, btos.size() - 4);
            }
            for (ReportCreditBankTransferOrderInfo bto : btos) {
                this.formatRow(wb, sheet, 39 + totalBtoRows);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(39 + totalBtoRows), (int)1, (String)bto.getName());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)(39 + totalBtoRows), (int)(bto.getPaymentType() == VendorReportPaymentType.MVL ? 5 : 4), (BigDecimal)bto.getAmount(), (boolean)true);
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)(39 + totalBtoRows), (int)6, (String)String.format("SUM(D%s:F%s)", Integer.toString(39 + totalBtoRows), Integer.toString(39 + totalBtoRows)));
                ++totalBtoRows;
            }
        }
    }

    private void formatRow(HSSFWorkbook wb, HSSFSheet sheet, int currentRow) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        HSSFRow prevRow = sheet.getRow(currentRow - 2);
        HSSFRow row = sheet.getRow(currentRow - 1);
        row.setHeight(prevRow.getHeight());
        HSSFCell cell = null;
        for (int i = 0; i < 6; ++i) {
            cell = row.getCell(i);
            if (cell == null) {
                cell = row.createCell(i);
            }
            cell.setCellStyle(prevRow.getCell(i).getCellStyle());
            if (i != 1) continue;
            sheet.addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(currentRow - 1, currentRow - 1, 0, 1));
        }
    }
}

