/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.un.xls;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.BaseUNSummarySheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNRegistrySellSheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNReportTicket;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

class UNRegistryRefundSheetHandler
extends BaseUNSummarySheetHandler {
    UNRegistryRefundSheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<UNReportTicket> data, Map<String, Object> globalData) throws Exception {
        int n;
        super.fill(wb, sheet, data, globalData);
        List<UNReportTicket> tickets = data.getTickets();
        Collections.sort(tickets, UNRegistrySellSheetHandler.ticketCcomparator);
        int startRow = 8;
        for (n = 1; n < tickets.size() - 1; ++n) {
            UNReportTicket ticket = tickets.get(n);
            if (ticket.getRoute() == null || ticket.getRoute().isEmpty()) continue;
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)startRow, (int)startRow);
        }
        n = 0;
        for (UNReportTicket ticket : tickets) {
            if (ticket.getRoute() == null || ticket.getRoute().isEmpty()) continue;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)1, (int)(n + 1));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)2, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)3, (String)UNRegistrySellSheetHandler.createDateFormat().format(ticket.getIssueDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)4, (String)ticket.getRoute());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)5, (BigDecimal)ticket.getTotal());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)6, (BigDecimal)ticket.getTotalEquivalentTaxFee());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)7, (BigDecimal)ticket.getClientCommission());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)8, (BigDecimal)ticket.getRefundCommission());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)9, (String)String.format("%s%%", UNRegistrySellSheetHandler.decimalFormat.format(ticket.getCommissionRate())));
            ++n;
        }
        int row = startRow + 1 + (n > 0 ? n : 1);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)5, (String)String.format("=SUM(E3:E%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)6, (String)String.format("=SUM(F3:F%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)7, (String)String.format("=SUM(G3:G%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)8, (String)String.format("=SUM(H3:H%s)", Integer.toString(row - 1)));
    }
}

