/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.un.xls;

import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.BaseUNSummarySheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNReportTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

class UNRegistrySellSheetHandler
extends BaseUNSummarySheetHandler {
    protected static DecimalFormat decimalFormat = new DecimalFormat("0.#");
    static Comparator<UNReportTicket> ticketCcomparator = new Comparator<UNReportTicket>(){

        @Override
        public int compare(UNReportTicket o1, UNReportTicket o2) {
            int res = TextUtil.compare((String)o1.getSortingTicketNumber(), (String)o2.getSortingTicketNumber(), (boolean)false, (boolean)true);
            if (res != 0) {
                return res;
            }
            return this.getCategory(o1) - this.getCategory(o2);
        }

        private int getCategory(UNReportTicket o1) {
            if (o1.getMcoCategory() == MCOCategory.INFORMATION) {
                return 0;
            }
            if (o1.getMcoCategory() == MCOCategory.PENALTY) {
                return 1;
            }
            return 2;
        }
    };

    UNRegistrySellSheetHandler() {
    }

    protected static DateFormat createDateFormat() {
        return new SimpleDateFormat("dd'.'MM'.'yyyy");
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<UNReportTicket> data, Map<String, Object> globalData) throws Exception {
        int n;
        super.fill(wb, sheet, data, globalData);
        List<UNReportTicket> tickets = data.getTickets();
        Collections.sort(tickets, ticketCcomparator);
        int startRow = 8;
        for (n = 1; n < tickets.size(); ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)startRow, (int)startRow);
        }
        for (n = 0; n < tickets.size(); ++n) {
            UNReportTicket ticket = tickets.get(n);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)1, (int)(n + 1));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)2, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)3, (String)ticket.getRoute());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)4, (BigDecimal)ticket.getTotal());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)5, (BigDecimal)ticket.getTotalEquivalentTaxFee());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)6, (String)String.format("%s%%", decimalFormat.format(ticket.getCommissionRate())));
        }
        int row = startRow + 1 + (tickets.size() > 0 ? tickets.size() : 1);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)4, (String)String.format("=SUM(D3:D%s)", Integer.toString(row - 1)));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)5, (String)String.format("=SUM(E3:E%s)", Integer.toString(row - 1)));
    }
}

