/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.un.xls;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.BasePoiReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNMVLSheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNRegistryRefundSheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNRegistrySellSheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNVVLSheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNVoidSheetHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UNSalesReportRenderHandler
extends BasePoiReportRenderHandler<UNReportTicket> {
    @Override
    protected List<PoiWorksheetData<UNReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<UNReportTicket>> result = new ArrayList<PoiWorksheetData<UNReportTicket>>();
        result.add(new BaseWorksheetData<UNReportTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.MVL.getWorksheetTemplateName();
            }

            @Override
            public PoiWorksheetDefinition<UNReportTicket> getDefinition() {
                return Definitions.MVL;
            }

            @Override
            public int getProirity() {
                return 0;
            }
        });
        result.add(new BaseWorksheetData<UNReportTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.VVL.getWorksheetTemplateName();
            }

            @Override
            public PoiWorksheetDefinition<UNReportTicket> getDefinition() {
                return Definitions.VVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<UNReportTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.REGISTRY_SELL.getWorksheetTemplateName();
            }

            @Override
            public PoiWorksheetDefinition<UNReportTicket> getDefinition() {
                return Definitions.REGISTRY_SELL;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        result.add(new BaseWorksheetData<UNReportTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.REGISTRY_REFUND.getWorksheetTemplateName();
            }

            @Override
            public PoiWorksheetDefinition<UNReportTicket> getDefinition() {
                return Definitions.REGISTRY_REFUND;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<UNReportTicket>(){

            @Override
            public String getBatchId() {
                return Definitions.VOID.getWorksheetTemplateName();
            }

            @Override
            public PoiWorksheetDefinition<UNReportTicket> getDefinition() {
                return Definitions.VOID;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        return result;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        StringBuilder sb = new StringBuilder();
        sb.append(params.getPeriodBegin() != null ? sdf.format(params.getPeriodBegin()) : "null");
        sb.append("-");
        sdf = new SimpleDateFormat("dd.MM.yyyy");
        sb.append(params.getPeriodEnd() != null ? sdf.format(params.getPeriodEnd()) : "null");
        return L10nResourcesManager.createL10nMessage((String)Messages.UNSalesReportRenderHandler_reportTitle, (Object[])new Object[]{sb.toString()}).toString();
    }

    @Override
    public String getId() {
        return "un-sales-report-xls";
    }

    @Override
    protected EntityContainer<? extends BaseReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        EntityContainer result = new EntityContainer(ReportDocument.class);
        ((ReportDocument)result.getEntity()).getFiles().add(file);
        ((ReportDocument)result.getEntity()).setReportType(ReportType.VENDOR);
        List messages = (List)data.get("key-messages");
        ((ReportDocument)result.getEntity()).getMessages().addAll(messages);
        ((ReportDocument)result.getEntity()).setParameters((ReportParameters)data.get("key-report-params"));
        return result;
    }

    @Override
    protected InputStream getInputStream(Map<String, Object> data) throws Exception {
        byte[] template = (byte[])data.get("KEY_TEMPLATE_DATA");
        if (template == null || template.length == 0) {
            throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.UNBSPSalesReportRenderHandler_unableToLoadTemplate, (Object[])new Object[0]).toString());
        }
        return new ByteArrayInputStream(template);
    }

    @Override
    public void initializeDataList(List<PoiWorksheetData<UNReportTicket>> dataList, Map<String, Object> data) {
        List messages = (List)data.get("key-messages");
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList == null) {
            SystemHelper.addMessage((Collection)messages, (String)"BasePoiRenderHandler_noBatchesPrepared", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        for (ReportBatchData batchData : batchDataList) {
            PoiWorksheetData<UNReportTicket> worksheetData = null;
            for (PoiWorksheetData<UNReportTicket> wd : dataList) {
                if (!wd.getBatchId().equals(batchData.getBatchId())) continue;
                worksheetData = wd;
                break;
            }
            if (worksheetData == null) {
                SystemHelper.addMessage((Collection)messages, (String)"unableToFindWorksheetDataForBatch", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{batchData.getBatchId()});
                continue;
            }
            worksheetData.getTickets().addAll(batchData.getTickets());
        }
    }

    public static enum Definitions implements PoiWorksheetDefinition<UNReportTicket>
    {
        MVL{

            @Override
            public PoiWorksheetHandler<UNReportTicket> getHandler() {
                return new UNMVLSheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "MVL";
            }
        }
        ,
        VVL{

            @Override
            public PoiWorksheetHandler<UNReportTicket> getHandler() {
                return new UNVVLSheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "VVL";
            }
        }
        ,
        REGISTRY_SELL{

            @Override
            public PoiWorksheetHandler<UNReportTicket> getHandler() {
                return new UNRegistrySellSheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "RegistrySell";
            }
        }
        ,
        REGISTRY_REFUND{

            @Override
            public PoiWorksheetHandler<UNReportTicket> getHandler() {
                return new UNRegistryRefundSheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "RegistryRefund";
            }
        }
        ,
        VOID{

            @Override
            public PoiWorksheetHandler<UNReportTicket> getHandler() {
                return new UNVoidSheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return "Void";
            }
        };


        @Override
        public abstract String getWorksheetTemplateName();

        @Override
        public abstract PoiWorksheetHandler<UNReportTicket> getHandler();
    }
}

