/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.un.xml;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LuggageUnits;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class UNXmlBatchHandler {
    private boolean isBatchCancel;
    private boolean isMcoTicketReturn;
    private boolean isMcoSeatPrereservation;
    protected final DecimalFormat decimalFormat = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));

    protected abstract String getTransactionType(SuTicket var1);

    public void renderReportBatch(Document doc, Element parent, SuSalesReportBatchData<SuTicket> batchData) {
        if (batchData.getTickets().isEmpty()) {
            return;
        }
        this.isBatchCancel = batchData.getBatchId().equals("CANCEL");
        Element xmlBatch = null;
        for (SuTicket ticket : batchData.getTickets()) {
            if (ticket.getTransactionNo() == 1) {
                xmlBatch = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "BATCH", "");
                xmlBatch.setAttributeNS(null, "NO", Integer.toString(ticket.getBatchNo()));
                xmlBatch.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "NAME", ticket.getBatchId()));
                parent.appendChild(xmlBatch);
            }
            this.isMcoTicketReturn = ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.RETURN_TICKET;
            this.isMcoSeatPrereservation = ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.SEAT_RESERVATION;
            this.addTicketTransaction(doc, xmlBatch, ticket, ticket.getTransactionNo());
        }
        parent.appendChild(xmlBatch);
    }

    protected void addMcoTicketTransaction(Document doc, Element parent, SuTicket mco, int ticketNo) {
        Element xmlTctItem = this.getTicketElement(parent, mco);
        if (mco.getMcoCategory() == MCOCategory.STICKER) {
            for (Product prod : mco.getRelatedProducts()) {
                if (prod.getStatus() == ProductStatus.SELL) break;
            }
        }
        if (xmlTctItem != null) {
            Element xmlTransaction;
            String tourCode;
            xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", UNXmlBatchHandler.getFirstBlankCouponsNames(mco)));
            MCOCategory mcoCategory = mco.getMcoCategory();
            xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PXNM", mco.getPassengerName()));
            Element xmlFareItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FARE", null);
            if (mcoCategory == MCOCategory.PENALTY || mcoCategory == MCOCategory.REBOOKING || mcoCategory == MCOCategory.STICKER || mcoCategory == MCOCategory.RETURN_TICKET || mcoCategory == MCOCategory.ADDITIONAL_TARIFF || mcoCategory == MCOCategory.DUPLICATE_TICKET || mcoCategory == MCOCategory.INFORMATION) {
                if (!this.isBatchCancel) {
                    this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, mco);
                }
            } else if (mcoCategory == MCOCategory.GROUP_PENALTY) {
                if (!this.isBatchCancel) {
                    Element xmlFareAmountItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
                    xmlFareItem.appendChild(xmlFareAmountItem);
                    if (xmlFareAmountItem != null) {
                        xmlFareAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", this.decimalFormat.format(mco.getBaseFare() == null ? Integer.valueOf(0) : mco.getBaseFare().getValue())));
                        xmlFareAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", doc.getElementsByTagName("CURRENCY").item(0).getTextContent()));
                        xmlFareAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", mco.getFareRate().doubleValue()));
                        xmlFareAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", this.decimalFormat.format(mco.getEquivalentFare())));
                        Element xmlFareCommissionItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COMMISSION", null);
                        String commRate = "0";
                        String commVal = this.decimalFormat.format((Object)0.0);
                        xmlFareCommissionItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CORT", commRate));
                        xmlFareCommissionItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COAM", commVal));
                        xmlFareItem.appendChild(xmlFareCommissionItem);
                    }
                }
            } else if (!this.isBatchCancel) {
                this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, mco);
            }
            xmlTctItem.appendChild(xmlFareItem);
            if (!this.isBatchCancel && (this.isMcoTicketReturn || this.isMcoSeatPrereservation || mco.getMcoCategory() == MCOCategory.GROUP_PENALTY || mco.getMcoCategory() == MCOCategory.GROUP_PREPAYMENT || mco.getMcoCategory() == MCOCategory.UNESCORTED_MINOR || mco.getMcoCategory() == MCOCategory.NOT_SOLD_SEATS || mco.getMcoCategory() == MCOCategory.COMFORT_PLUS || mco.getMcoCategory() == MCOCategory.SPECIAL_FOOD || mco.getMcoCategory() == MCOCategory.PAPER_SURCHARGE)) {
                this.appendTaxesElement(xmlTctItem, mco, doc, parent);
            }
            if (mcoCategory != null) {
                switch (mcoCategory) {
                    case PTA: {
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "PTA"));
                        break;
                    }
                    case RETURN_FARE_DIFFERENCE: {
                        Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                        Product[] xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                        String relatedTicketNumber = "";
                        if (mco.getRelatedProducts() != null && mco.getRelatedProducts().length > 0) {
                            relatedTicketNumber = mco.getRelatedProducts()[0].getBlankOwnerNumber() + " " + mco.getRelatedProducts()[0].getSystemNumber();
                        }
                        Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedTicketNumber);
                        xmlMainDoc.appendChild(xmlMainDocTDNR);
                        xmlMainDocs.appendChild((Node)xmlMainDoc);
                        xmlTctItem.appendChild(xmlMainDocs);
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u0421\u043f\u0440\u0430\u0432\u043a\u0430"));
                        break;
                    }
                    case GROUP_PREPAYMENT: {
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u041f\u0440\u043e\u0447\u0435\u0435"));
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "OTHER_KIND", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0433\u0440\u0443\u043f\u043f"));
                        break;
                    }
                    case PENALTY: 
                    case REBOOKING: 
                    case STICKER: 
                    case ADDITIONAL_TARIFF: 
                    case DUPLICATE_TICKET: 
                    case INFORMATION: {
                        Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                        Product[] xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                        String relatedTicketNumber = "";
                        if (mco.getRelatedProducts() != null && mco.getRelatedProducts().length > 0) {
                            relatedTicketNumber = mco.getRelatedProducts()[0].getBlankOwnerNumber() + " " + mco.getRelatedProducts()[0].getSystemNumber();
                        }
                        Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedTicketNumber);
                        xmlMainDoc.appendChild(xmlMainDocTDNR);
                        xmlMainDocs.appendChild((Node)xmlMainDoc);
                        xmlTctItem.appendChild(xmlMainDocs);
                        String usageCode = "\u0421\u043f\u0440\u0430\u0432\u043a\u0430";
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", usageCode));
                        break;
                    }
                    case GROUP_PENALTY: {
                        if (mco.getRelatedProducts() != null && mco.getRelatedProducts().length > 0) {
                            Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                            for (Product relProduct : mco.getRelatedProducts()) {
                                Element xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                                String relatedMcoNumber = (String)relProduct.getScns().get(0);
                                Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedMcoNumber);
                                xmlMainDoc.appendChild(xmlMainDocTDNR);
                                xmlMainDocs.appendChild(xmlMainDoc);
                            }
                            xmlTctItem.appendChild(xmlMainDocs);
                        }
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u041f\u0440\u043e\u0447\u0435\u0435"));
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "OTHER_KIND", "\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u0443"));
                        break;
                    }
                    case SEAT_RESERVATION: {
                        if (mco.getRelatedProducts() != null && mco.getRelatedProducts().length > 0) {
                            Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                            for (Product relProduct : mco.getRelatedProducts()) {
                                Element xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                                String relatedTicketNumber = relProduct.getBlankOwnerNumber() + " " + relProduct.getSystemNumber();
                                Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedTicketNumber);
                                xmlMainDoc.appendChild(xmlMainDocTDNR);
                                xmlMainDocs.appendChild(xmlMainDoc);
                            }
                            xmlTctItem.appendChild(xmlMainDocs);
                        }
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u041f\u0440\u043e\u0447\u0435\u0435"));
                        break;
                    }
                    case SPECIAL_FOOD: {
                        if (mco.getRelatedProducts() != null && mco.getRelatedProducts().length > 0) {
                            Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                            for (Product relProduct : mco.getRelatedProducts()) {
                                Element xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                                String relatedTicketNumber = relProduct.getBlankOwnerNumber() + " " + relProduct.getSystemNumber();
                                Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedTicketNumber);
                                xmlMainDoc.appendChild(xmlMainDocTDNR);
                                xmlMainDocs.appendChild(xmlMainDoc);
                            }
                            xmlTctItem.appendChild(xmlMainDocs);
                        }
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u041f\u0440\u043e\u0447\u0435\u0435"));
                        break;
                    }
                    case UNESCORTED_MINOR: {
                        if (mco.getRelatedProducts() != null && mco.getRelatedProducts().length > 0) {
                            Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                            for (Product relProduct : mco.getRelatedProducts()) {
                                Element xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                                String relatedTicketNumber = relProduct.getBlankOwnerNumber() + " " + relProduct.getSystemNumber();
                                Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedTicketNumber);
                                xmlMainDoc.appendChild(xmlMainDocTDNR);
                                xmlMainDocs.appendChild(xmlMainDoc);
                            }
                            xmlTctItem.appendChild(xmlMainDocs);
                        }
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u041f\u0440\u043e\u0447\u0435\u0435"));
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "OTHER_KIND", "\u0414\u0435\u0442\u0438 \u0431\u0435\u0437 \u0441\u043e\u043f\u0440\u043e\u0432"));
                        break;
                    }
                    case COMFORT_PLUS: {
                        if (mco.getRelatedProducts() != null && mco.getRelatedProducts().length > 0) {
                            Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                            for (Product relProduct : mco.getRelatedProducts()) {
                                Element xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                                String relatedTicketNumber = relProduct.getBlankOwnerNumber() + " " + relProduct.getSystemNumber();
                                Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedTicketNumber);
                                xmlMainDoc.appendChild(xmlMainDocTDNR);
                                xmlMainDocs.appendChild(xmlMainDoc);
                            }
                            xmlTctItem.appendChild(xmlMainDocs);
                        }
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u041f\u0440\u043e\u0447\u0435\u0435"));
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "OTHER_KIND", "\u041a\u043e\u043c\u0444\u043e\u0440\u0442 +"));
                        break;
                    }
                    case PAPER_SURCHARGE: {
                        if (mco.getRelatedProducts() != null && mco.getRelatedProducts().length > 0) {
                            Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                            for (Product relProduct : mco.getRelatedProducts()) {
                                Element xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                                String relatedTicketNumber = relProduct.getBlankOwnerNumber() + " " + relProduct.getSystemNumber();
                                Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", relatedTicketNumber);
                                xmlMainDoc.appendChild(xmlMainDocTDNR);
                                xmlMainDocs.appendChild(xmlMainDoc);
                            }
                            xmlTctItem.appendChild(xmlMainDocs);
                        }
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u041f\u0440\u043e\u0447\u0435\u0435"));
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "OTHER_KIND", "\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0441\u0431\u043e\u0440"));
                        break;
                    }
                    case NOT_SOLD_SEATS: {
                        xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "USAGECODE", "\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u043d\u0435\u043f\u0440\u043e\u0434\u0430\u043d\u043d\u044b\u0435 \u0431/\u043c\u0435\u0441\u0442\u0430"));
                        break;
                    }
                }
            }
            if (!TextUtil.isBlank((String)(tourCode = mco.getTourCode())) && mcoCategory == MCOCategory.RETURN_TICKET) {
                xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TOUR", tourCode));
            }
            if ((xmlTransaction = UNXmlBatchHandler.getChildElement(parent, "TRANSACTION")) != null && !this.isBatchCancel) {
                this.addFopSection(doc, parent, xmlTransaction, mco);
            }
        }
    }

    private void appendCouponsElement(Element xmlTctItem, SuTicket ticket, Document doc, Element parent) {
        List<Segment> segments = this.getActiveCoupons(ticket);
        if (!segments.isEmpty()) {
            Element xmlCouponsItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
            for (Segment segment : segments) {
                Element xmlCouponItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                xmlCouponItem.setAttributeNS(null, "NO", "" + segment.getRecordNumber());
                xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", UNXmlBatchHandler.getCouponName(ticket)));
                xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", ("" + segment.getAirline().getCode()).trim()));
                if (segment.getFlightNo() != null) {
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                } else {
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", "OPEN"));
                }
                xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                if (segment.getStartDate() != null) {
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", new SimpleDateFormat("yyyy-MM-dd").format(segment.getStartDate())));
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDT", new SimpleDateFormat("HH:mm:ss").format(segment.getStartDate())));
                }
                xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RBKD", segment.getClassOfService()));
                xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBAL", this.getLuggageFBAL(ticket.getLuggageWeight(), ticket.getLuggageUnits())));
                xmlCouponsItem.appendChild(xmlCouponItem);
            }
            xmlTctItem.appendChild(xmlCouponsItem);
        }
    }

    protected void addDocTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) throws Exception {
        Element xmlTctItem = UNXmlBatchHandler.getTicketElement(parent);
        if (xmlTctItem != null) {
            String tourCode;
            if (!this.isBatchCancel) {
                xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", ticket.isSticker() ? ticket.getStickerCouponNames() : UNXmlBatchHandler.getFirstBlankCouponsNames(ticket)));
                xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PXNM", ticket.getPassengerName()));
                Element xmlFareItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FARE", null);
                this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, ticket);
                xmlTctItem.appendChild(xmlFareItem);
                this.appendTaxesElement(xmlTctItem, ticket, doc, parent);
                xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "PNRR", !TextUtil.isBlank((String)ticket.getLatinPnr()) ? ticket.getLatinPnr() : ticket.getPnr()));
            }
            if (!TextUtil.isBlank((String)(tourCode = ticket.getTourCode()))) {
                xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TOUR", tourCode));
            }
            this.appendCouponsElement(xmlTctItem, ticket, doc, parent);
            Element xmlTransaction = UNXmlBatchHandler.getChildElement(parent, "TRANSACTION");
            if (xmlTransaction != null && !this.isBatchCancel) {
                this.addFopSection(doc, parent, xmlTransaction, ticket);
            }
        }
        if (xmlTctItem != null && !this.isBatchCancel) {
            String[] conjunctions = ticket.getConjunctions();
            if (conjunctions.length > 0) {
                Element xmlConjanctionsItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTIONS", null);
                for (int conjTicketNo = 1; conjTicketNo <= conjunctions.length; ++conjTicketNo) {
                    Element xmlConjanctionDocItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTION_DOC", null);
                    xmlConjanctionDocItem.setAttributeNS(null, "NO", Integer.toString(conjTicketNo));
                    xmlConjanctionDocItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " " + conjunctions[conjTicketNo - 1]));
                    if (ticket.getConjunctionScns().length > 0) {
                        xmlConjanctionDocItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SCNR", ticket.getConjunctionScns()[conjTicketNo - 1]));
                    }
                    xmlConjanctionDocItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", UNXmlBatchHandler.getCouponNames(ticket, conjTicketNo)));
                    Element xmlConjCouponsItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                    for (Segment segment : this.getConjCoupons(ticket, conjTicketNo)) {
                        Element xmlConjCouponItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                        xmlConjCouponItem.setAttributeNS(null, "NO", "" + this.getConjRecordNumber(ticket.getCouponsCount(), segment.getRecordNumber()));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", UNXmlBatchHandler.getCouponName(ticket)));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", segment.getAirline().getCode()));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", new SimpleDateFormat("yyyy-MM-dd").format(segment.getStartDate())));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDT", new SimpleDateFormat("HH:mm:ss").format(segment.getStartDate())));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RBKD", segment.getClassOfService()));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBAL", this.getLuggageFBAL(ticket.getLuggageWeight(), ticket.getLuggageUnits())));
                        xmlConjCouponsItem.appendChild(xmlConjCouponItem);
                    }
                    xmlConjanctionDocItem.appendChild(xmlConjCouponsItem);
                    xmlConjanctionsItem.appendChild(xmlConjanctionDocItem);
                    xmlTctItem.appendChild(xmlConjanctionsItem);
                }
            }
            xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ENRS", ticket.getEndorsement()));
            xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FRCA", ticket.getFareCalculationData()));
        }
    }

    protected void addAdmTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) throws Exception {
        Element memoElement = UNXmlBatchHandler.getMemoElement(parent);
        if (memoElement != null) {
            String fromTo = null;
            if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ACM) {
                fromTo = "AG";
            } else if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ADM) {
                fromTo = "AL";
            }
            memoElement.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FROM_TO", fromTo));
            memoElement.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TRANSPCATE", "PAX"));
            Element amountElement = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
            memoElement.appendChild(amountElement);
            String baseFare = ticket.getBaseFare() != null && ticket.getBaseFare().getValue() != null ? this.decimalFormat.format(ticket.getBaseFare().getValue()) : "0";
            String baseCurrency = ticket.getBaseFare() != null && ticket.getBaseFare().getCurrency() != null ? ticket.getBaseFare().getCurrency() : DictHelper.getLocalCurrency2();
            String equivalentFare = ticket.getEquivalentFare() != null ? this.decimalFormat.format(ticket.getEquivalentFare()) : "0";
            amountElement.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", baseFare));
            amountElement.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", baseCurrency == null ? "" : baseCurrency));
            amountElement.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", ticket.getFareRate() != null ? ticket.getFareRate().doubleValue() : 1.0));
            amountElement.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", equivalentFare));
            Element itemsElement = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ITEMS", null);
            memoElement.appendChild(itemsElement);
            int counter = 1;
            for (AgencyMemoProductItemGroup agencyMemoProductItemGroup : ticket.getAgencyMemoProductItemGroups()) {
                Element itemElement = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ITEM", "");
                itemElement.setAttributeNS(null, "NO", Integer.toString(counter));
                itemsElement.appendChild(itemElement);
                String agencyMemoItemTitle = null;
                if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.BONUS) {
                    agencyMemoItemTitle = "\u0411\u043e\u043d\u0443\u0441\u043d\u044b\u0435 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u043e\u043d\u043d\u044b\u0435";
                } else if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.COMMISSION) {
                    agencyMemoItemTitle = "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u043e\u043d\u043d\u044b\u0435";
                } else if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.PENALTY || agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.CONTRACT_PENALTY) {
                    agencyMemoItemTitle = "\u0428\u0442\u0440\u0430\u0444\u044b";
                } else if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TARIFF) {
                    agencyMemoItemTitle = "\u0422\u0430\u0440\u0438\u0444";
                } else if (agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TAX_CARRIER || agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TAX_FUEL || agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TAX_STATE || agencyMemoProductItemGroup.getType() == AgencyMemoProductEntryType.TAX_OTHERS) {
                    agencyMemoItemTitle = "\u0422\u0430\u043a\u0441\u044b";
                }
                String agencyMemoItemAmount = agencyMemoProductItemGroup.getAmount() != null && agencyMemoProductItemGroup.getAmount().getValue() != null ? this.decimalFormat.format(agencyMemoProductItemGroup.getAmount().getValue()) : "0";
                itemElement.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ITEM_TITLE", agencyMemoItemTitle));
                itemElement.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", agencyMemoItemAmount));
                ++counter;
            }
        }
    }

    protected void addFopSection(Document doc, Element parent, Element xmlTransaction, SuTicket ticket) {
        boolean isSuBlankOwner = ticket.getBlankOwnerCode() != null && ticket.getBlankOwnerCode().equals("SU");
        Element xmlFops = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FOP", null);
        xmlTransaction.appendChild(xmlFops);
        if (xmlFops != null) {
            String fopTypeStr = "";
            String fopPaymentTypeStr = "";
            String fopDocNumber = "";
            int fopNumber = 0;
            boolean blockCharter = false;
            boolean groupTariff = false;
            Object cashFop = null;
            fopTypeStr = "CASH";
            fopPaymentTypeStr = "CA";
            if (TariffType.BLOCKCHARTER.equals((Object)ticket.getTariffType())) {
                blockCharter = true;
            }
            if (TariffType.CHARTER.equals((Object)ticket.getTariffType())) {
                blockCharter = true;
            }
            if (TariffType.GROUP.equals((Object)ticket.getTariffType())) {
                groupTariff = true;
            }
            boolean hasPoFop = false;
            if (ticket.isSticker() && this.hasNeighbourETicketMcoSticker(ticket)) {
                for (ProductFop fop : ticket.getFops()) {
                    if (ticket.getCashValue() == null || fop.getAmount() == null || !ticket.getCashValue().equals(fop.getAmount().getValue())) continue;
                    hasPoFop = true;
                    break;
                }
            }
            if (ticket.getFops().isEmpty() || hasPoFop) {
                Element xmlFopItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), fopTypeStr, null);
                xmlFopItem.setAttributeNS(null, "NO", String.valueOf(++fopNumber));
                xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPTP", fopPaymentTypeStr));
                Element xmlFopAmountItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
                xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", this.decimalFormat.format(BigDecimal.ZERO)));
                xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", DictHelper.getLocalCurrency()));
                xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", "1"));
                xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", this.decimalFormat.format(BigDecimal.ZERO)));
                xmlFopItem.appendChild(xmlFopAmountItem);
                xmlFops.appendChild(xmlFopItem);
                return;
            }
            for (ProductFop fop : ticket.getFops()) {
                if (PaymentType.TICKET.equals((Object)fop.getType()) || fop.getAmount() == null || ticket.getCashValue() != null && ticket.getCashValue().compareTo(fop.getAmount().getValue()) == 0 && ticket.isSticker() && this.hasNeighbourETicketMcoSticker(ticket) || blockCharter && ticket.getFops().size() > 1 && fop.getType() == PaymentType.TICKET) continue;
                ++fopNumber;
                if (fop.getType() == null) {
                    return;
                }
                switch (fop.getType()) {
                    case CASH: {
                        fopTypeStr = "CASH";
                        fopPaymentTypeStr = "CA";
                        break;
                    }
                    case INVOICE: {
                        if ((TextUtil.isBlank((String)ticket.getEndorsement()) || !ticket.getEndorsement().contains("RD")) && TextUtil.isBlank((String)ticket.getTelexNumber())) break;
                        fopTypeStr = "INVOICE";
                        fopPaymentTypeStr = "TX";
                        break;
                    }
                    case CREDIT_CARD: {
                        fopTypeStr = "CREDIT_CARD";
                        fopPaymentTypeStr = "CC";
                        break;
                    }
                    case MCO: {
                        fopTypeStr = "EXCHANGE";
                        fopPaymentTypeStr = "MC";
                        break;
                    }
                    case TICKET: {
                        fopTypeStr = "CASH";
                        fopPaymentTypeStr = "CA";
                        if (!ticket.isDuplicate()) break;
                        fopTypeStr = "EXCHANGE";
                        fopPaymentTypeStr = isSuBlankOwner ? "DL" : "DU";
                        break;
                    }
                    case MTD: {
                        fopTypeStr = "INVOICE";
                        fopPaymentTypeStr = "AI";
                        break;
                    }
                }
                if (blockCharter) {
                    fopTypeStr = "INVOICE";
                    fopPaymentTypeStr = fop.getAmount().getValue() != null && fop.getAmount().getValue().doubleValue() != 0.0 ? "BC" : "CH";
                }
                Element xmlFopItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), fopTypeStr, null);
                xmlFopItem.setAttributeNS(null, "NO", String.valueOf(fopNumber));
                xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPTP", fopPaymentTypeStr));
                Element xmlFopAmountItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
                xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", this.decimalFormat.format(fop.getAmount().getValue())));
                xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", fop.getAmount().getCurrency()));
                xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", "1"));
                xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", this.decimalFormat.format(fop.getAmount().getValue())));
                xmlFopItem.appendChild(xmlFopAmountItem);
                if (blockCharter) {
                    xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", ticket.getBlockCharterContractNo()));
                    xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CLID", ticket.getBlockCharterAgenencyId()));
                } else {
                    switch (fop.getType()) {
                        case CREDIT_CARD: {
                            String cardOwner;
                            String securityCode;
                            if (fop.getCard() == null) break;
                            CardVendor cardVendor = fop.getCard().getVendor();
                            if (cardVendor != null) {
                                String cardVendorCode = null;
                                switch (cardVendor) {
                                    case VISA: {
                                        cardVendorCode = "VI";
                                        break;
                                    }
                                    case MASTERCARD: {
                                        cardVendorCode = "MC";
                                        break;
                                    }
                                    case AMEX: {
                                        cardVendorCode = "AX";
                                        break;
                                    }
                                    case JCB: {
                                        cardVendorCode = "JB";
                                        break;
                                    }
                                    case DINERS_CLUB: {
                                        cardVendorCode = "DC";
                                        break;
                                    }
                                    case AIR_TRAVEL_CARD: {
                                        cardVendorCode = "TP";
                                        break;
                                    }
                                    case MIR: {
                                        cardVendorCode = "MR";
                                    }
                                }
                                if (!TextUtil.isBlank((String)cardVendorCode)) {
                                    xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CCCC", cardVendorCode));
                                }
                            }
                            if (fop.getCard().getNumber() != null) {
                                String cardNumber;
                                fopDocNumber = cardNumber = fop.getCard().getNumber();
                            }
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", fopDocNumber));
                            Date expiration = fop.getCard().getExpiration();
                            if (expiration != null) {
                                xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "EXDA", new SimpleDateFormat("yyyy-MM-dd").format(expiration)));
                            }
                            if ((securityCode = fop.getCard().getSecurityCode()) != null) {
                                xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "APLC", securityCode));
                            }
                            if (TextUtil.isBlank((String)(cardOwner = fop.getCard().getNameOnCard()))) break;
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CCHN", cardOwner));
                            break;
                        }
                        case INVOICE: {
                            if (!groupTariff || TextUtil.isBlank((String)ticket.getTelexNumber())) break;
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", ticket.getTelexNumber()));
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CLID", "*"));
                            break;
                        }
                        case MCO: {
                            fopDocNumber = ticket.getTicketSeries() + " " + fop.getRelatedTicketNumber();
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", fopDocNumber));
                            String coupons = "";
                            if (!TextUtil.isBlank((String)fopDocNumber)) {
                                if (fopDocNumber.matches("[ 0-9]{0,4}401[0-9]{7}")) {
                                    coupons = "R";
                                }
                                if (fopDocNumber.matches("[ 0-9]{0,4}402[0-9]{7}")) {
                                    coupons = "RR";
                                }
                            }
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", coupons));
                            break;
                        }
                        case TICKET: {
                            if (!ticket.isDuplicate()) break;
                            fopDocNumber = ticket.getTicketSeries() + " " + fop.getRelatedTicketNumber();
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", fopDocNumber));
                            String coupons = isSuBlankOwner ? this.getSuRefundedCoupons(ticket) : this.getS7RefundedCoupons(ticket);
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", coupons));
                            break;
                        }
                        case MTD: {
                            String mtdNumber = fop.getRelatedTicketNumber();
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FPAC", TextUtil.isBlank((String)mtdNumber) ? "*" : mtdNumber.trim()));
                            String mtdType = null;
                            PassengerStatus passengerStatus = fop.getPassengerStatus();
                            mtdType = passengerStatus == PassengerStatus.VS_MVD ? "424954" : (passengerStatus == PassengerStatus.VS_MO ? "\u041c\u041e" : "*");
                            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CLID", mtdType));
                        }
                    }
                }
                xmlFops.appendChild(xmlFopItem);
            }
            if ("UN".equals(ticket.getBlankOwnerCode()) && ProductStatus.SELL.equals((Object)ticket.getStatus()) && ticket.getPrevTicket() != null && ProductStatus.EXCHANGE.equals((Object)ticket.getPrevTicket().getStatus())) {
                ArrayList<String> ticketNumbers = new ArrayList<String>();
                int couponsMax = 4;
                if (ticket.getPrevTicket().getPreviousProduct() != null) {
                    ticketNumbers.add(ticket.getPrevTicket().getPreviousProduct().getBlankOwnerNumber() + " " + ticket.getPrevTicket().getPreviousProduct().getSystemNumber());
                    String[] conjunctions = AirProductHelper.getConjunctions((Product)ticket.getPrevTicket().getPreviousProduct());
                    for (String c : conjunctions) {
                        ticketNumbers.add(ticket.getPrevTicket().getPreviousProduct().getBlankOwnerNumber() + " " + c);
                    }
                    if (ticket.getPrevTicket().getPreviousProduct().getBlankType() != null) {
                        BlankType bt = (BlankType)DictionaryCache.get().resolveReference(ticket.getPrevTicket().getPreviousProduct().getBlankType());
                        couponsMax = bt.getCouponsCount();
                    }
                } else {
                    ticketNumbers.add(ticket.getRelatedTicketNumber());
                }
                StringBuilder coupons = new StringBuilder("               ");
                for (Segment s : ticket.getSegments()) {
                    if (s.getRecordNumber() - 1 >= coupons.length()) continue;
                    coupons.setCharAt(s.getRecordNumber() - 1, 'R');
                }
                String currency = ticket.getBaseFare() != null && ticket.getBaseFare().getCurrency() != null ? ticket.getBaseFare().getCurrency() : DictHelper.getLocalCurrency();
                List<Element> xmlFopItems = this.createExchangeFopElements(fopNumber, ticketNumbers, coupons.toString(), couponsMax, doc, parent.getNamespaceURI(), currency);
                for (Element xmlFopItem : xmlFopItems) {
                    xmlFops.appendChild(xmlFopItem);
                }
            }
        }
    }

    private List<Element> createExchangeFopElements(int fopNumber, List<String> ticketNumbers, String coupons, int couponsMax, Document doc, String namespaceURI, String currency) {
        ArrayList<Element> res = new ArrayList<Element>();
        int num = 0;
        for (String ticketNumber : ticketNumbers) {
            Element xmlFopItem = UNXmlBatchHandler.writeElement(doc, namespaceURI, "EXCHANGE", null);
            xmlFopItem.setAttributeNS(null, "NO", String.valueOf(++fopNumber));
            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "FPTP", "EX"));
            Element xmlFopAmountItem = UNXmlBatchHandler.writeElement(doc, namespaceURI, "AMOUNT", null);
            xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "SOURCE", "0"));
            xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "CUTP", currency != null ? currency : ""));
            xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "RATE", "1"));
            xmlFopAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "AMNT", "0"));
            xmlFopItem.appendChild(xmlFopAmountItem);
            Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, namespaceURI, "TDNR", ticketNumber);
            xmlFopItem.appendChild(xmlMainDocTDNR);
            String couponsString = "";
            if (num * couponsMax < coupons.length()) {
                int end = (num + 1) * couponsMax < coupons.length() ? (num + 1) * couponsMax : coupons.length() - 1;
                couponsString = coupons.substring(num * couponsMax, end);
            }
            ++num;
            xmlFopItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "CPUI", couponsString.replaceAll("\\s+$", "")));
            res.add(xmlFopItem);
        }
        return res;
    }

    protected void appendTaxesElement(Element xmlTctItem, SuTicket ticket, Document doc, Element parent) {
        if (ticket.getTaxes() == null || ticket.getTaxes().isEmpty()) {
            return;
        }
        Element xmlTaxesItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TAXES", null);
        int taxNumber = 0;
        for (Tax tax : ticket.getTaxes()) {
            if (tax.getEquivalentAmount().doubleValue() == 0.0) continue;
            Element xmlTaxTaxesItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TAX", null);
            xmlTaxTaxesItem.setAttributeNS(null, "NO", Integer.toString(++taxNumber));
            Element taxesAmountItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMOUNT", null);
            double taxValue = tax.getEquivalentAmount().doubleValue();
            taxesAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SOURCE", this.decimalFormat.format(taxValue)));
            taxesAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CUTP", SalesReportHelper.getEquivCurrency(null)));
            taxesAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "RATE", "1"));
            taxesAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AMNT", this.decimalFormat.format(taxValue)));
            xmlTaxTaxesItem.appendChild(taxesAmountItem);
            xmlTaxTaxesItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TMFT", tax.getCode().toUpperCase()));
            xmlTaxesItem.appendChild(xmlTaxTaxesItem);
        }
        if (taxNumber > 0) {
            xmlTctItem.appendChild(xmlTaxesItem);
        }
    }

    private boolean hasNeighbourETicketMcoSticker(SuTicket ticket) {
        boolean result = false;
        if (ticket.getProduct() != null && ticket.getProduct().getReservation() != null) {
            String sellProductNumber = ticket.getProduct().getSystemNumber();
            for (BaseProduct p : ticket.getProduct().getReservation().getProducts()) {
                if (!(p instanceof Product) || !MCOCategory.STICKER.equals((Object)((Product)p).getMcoCategory()) || !((Product)p).isEticket()) continue;
                boolean mcoForThatSell = false;
                for (Product p2 : ((Product)p).getRelatedProducts()) {
                    if (!TextUtil.isSame((String)p2.getSystemNumber(), (String)sellProductNumber)) continue;
                    mcoForThatSell = true;
                    break;
                }
                if (!mcoForThatSell) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void addFareItem(Document doc, String namespaceURI, Element xmlFareItem, SuTicket ticket) {
        String commVal;
        String commRate;
        boolean zeroMco = ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING || ticket.getMcoCategory() == MCOCategory.STICKER || ticket.getMcoCategory() == MCOCategory.ADDITIONAL_TARIFF || ticket.getMcoCategory() == MCOCategory.UNESCORTED_MINOR || ticket.getMcoCategory() == MCOCategory.INFORMATION || ticket.getMcoCategory() == MCOCategory.COMFORT_PLUS;
        Element xmlFareAmountItem = UNXmlBatchHandler.writeElement(doc, namespaceURI, "AMOUNT", null);
        xmlFareItem.appendChild(xmlFareAmountItem);
        if (xmlFareAmountItem != null) {
            String baseFare = !zeroMco && ticket.getBaseFare() != null && ticket.getBaseFare().getValue() != null ? this.decimalFormat.format(ticket.getBaseFare().getValue()) : "0";
            String equivFare = !zeroMco && ticket.getEquivalentFare() != null ? this.decimalFormat.format(ticket.getEquivalentFare()) : "0";
            String curr = ticket.getBaseFare() != null && ticket.getBaseFare().getCurrency() != null ? ticket.getBaseFare().getCurrency() : DictHelper.getLocalCurrency();
            xmlFareAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "SOURCE", baseFare));
            xmlFareAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "CUTP", curr == null ? "" : curr));
            xmlFareAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "RATE", !zeroMco && ticket.getFareRate() != null ? ticket.getFareRate().doubleValue() : 1.0));
            xmlFareAmountItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "AMNT", equivFare));
        }
        Element xmlFareCommissionItem = UNXmlBatchHandler.writeElement(doc, namespaceURI, "COMMISSION", null);
        try {
            commRate = this.decimalFormat.format(ticket.getVendorCommissionRate() != null ? ticket.getVendorCommissionRate() : 0.0);
        }
        catch (IllegalArgumentException iae) {
            commRate = "";
        }
        try {
            commVal = this.decimalFormat.format(ticket.getVendorEquivalentCommission());
        }
        catch (IllegalArgumentException iae) {
            commVal = "";
        }
        xmlFareCommissionItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "CORT", commRate));
        xmlFareCommissionItem.appendChild(UNXmlBatchHandler.writeElement(doc, namespaceURI, "COAM", commVal));
        xmlFareItem.appendChild(xmlFareCommissionItem);
    }

    protected void addTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) {
        try {
            if (ticket.getReportTicketType() == BaseSalesReportTicket.ReportTicketType.MEMO) {
                this.beginMemoTransaction(doc, parent, ticket, ticketNo);
                this.addAdmTicketTransaction(doc, parent, ticket, ticketNo);
            } else {
                this.beginTicketTransaction(doc, parent, ticket, ticketNo);
                if (ticket.getProductCategory() == ProductCategory.MCO && !this.isMcoTicketReturn && ticket.getStatus() != ProductStatus.VOID) {
                    this.addMcoTicketTransaction(doc, parent, ticket, ticketNo);
                } else if (ticket.getProductCategory() == ProductCategory.EXCESS_BAGAGE) {
                    this.addEbtTicketTransaction(doc, parent, ticket, ticketNo);
                } else {
                    this.addDocTicketTransaction(doc, parent, ticket, ticketNo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void beginTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) {
        Element xmlTransaction = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TRANSACTION", null);
        xmlTransaction.setAttributeNS(null, "NO", Integer.toString(ticketNo));
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DAIS", ticket.getIssueDate() == null ? "" : new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(ticket.getIssueDate())));
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AGTN", ticket.getValidatorCode()));
        String transactionCode = this.getTransactionType(ticket);
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TRANS_TYPE", transactionCode));
        if ("SALE".equals(transactionCode)) {
            transactionCode = "\u041f\u0440\u043e\u0434\u0430\u0436\u0430";
        } else if ("REFUND".equals(transactionCode)) {
            transactionCode = "\u0412\u043e\u0437\u0432\u0440\u0430\u0442";
        } else if ("CANCEL".equals(transactionCode)) {
            transactionCode = "\u0418\u0441\u043f\u043e\u0440\u0447\u0435\u043d";
        } else if ("STICKER".equals(transactionCode)) {
            transactionCode = "\u0421\u0442\u0438\u043a\u0435\u0440";
        } else if ("ANNUL".equals(transactionCode)) {
            transactionCode = "\u0410\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d";
        }
        ticket.setTransactionCode(transactionCode);
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "VAT", ticket.isVatIncluded() ? "YES" : "NO"));
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CURRENCY", doc.getElementsByTagName("CURRENCY").item(0).getTextContent()));
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "E_TICKET", ticket.isEticket() ? "YES" : "NO"));
        if (!TextUtil.isBlank((String)ticket.getPcc())) {
            xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "AGTA", ticket.getPcc()));
        }
        Element xmlDocItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DOC", null);
        Element xmlTctItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), UNXmlBatchHandler.getTicketElementName(ticket), null);
        if (TextUtil.isBlank((String)ticket.getTicketNumber())) {
            if (!TextUtil.isBlank((String)ticket.getScn())) {
                xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " 05" + ticket.getScn().substring(2)));
            }
        } else {
            xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " " + ticket.getTicketNumber()));
        }
        if (ticket.getProductCategory() != ProductCategory.MCO && ticket.getProductCategory() != ProductCategory.EXCESS_BAGAGE && !TextUtil.isBlank((String)ticket.getScn()) && !ticket.isEticket()) {
            xmlTctItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SCNR", ticket.getScn()));
        }
        xmlDocItem.appendChild(xmlTctItem);
        xmlTransaction.appendChild(xmlDocItem);
        parent.appendChild(xmlTransaction);
    }

    protected void beginMemoTransaction(Document document, Element parent, SuTicket ticket, int ticketNo) {
        Element xmlTransaction = UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "TRANSACTION", null);
        xmlTransaction.setAttributeNS(null, "NO", Integer.toString(ticketNo));
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "DAIS", ticket.getIssueDate() == null ? "" : new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(ticket.getIssueDate())));
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "AGTN", ticket.getValidatorCode()));
        String transactionCode = this.getTransactionType(ticket);
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "TRANS_TYPE", transactionCode));
        if ("SALE".equals(transactionCode)) {
            transactionCode = "\u041f\u0440\u043e\u0434\u0430\u0436\u0430";
        }
        ticket.setTransactionCode(transactionCode);
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "VAT", ticket.isVatIncluded() ? "YES" : "NO"));
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "CURRENCY", document.getElementsByTagName("CURRENCY").item(0).getTextContent()));
        xmlTransaction.appendChild(UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "E_TICKET", ticket.isEticket() ? "YES" : "NO"));
        Element xmlDocItem = UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "DOC", null);
        Element xmlMemoItem = UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), UNXmlBatchHandler.getTicketElementName(ticket), null);
        xmlMemoItem.appendChild(UNXmlBatchHandler.writeElement(document, parent.getNamespaceURI(), "TDNR", String.format("%s %s", ticket.getTicketSeries(), ticket.getTicketNumber())));
        xmlDocItem.appendChild(xmlMemoItem);
        xmlTransaction.appendChild(xmlDocItem);
        parent.appendChild(xmlTransaction);
    }

    protected static Element writeElement(Document doc, String namespaceUri, String name, Object value) {
        Element result = doc.createElementNS(namespaceUri, name);
        if (value != null) {
            result.appendChild(doc.createTextNode(value.toString()));
        }
        return result;
    }

    protected static String getCouponName(SuTicket ticket) {
        String result = "";
        switch (ticket.getStatus()) {
            case EXCHANGE: 
            case REFUND: {
                result = "R";
                break;
            }
            case SELL: {
                result = "F";
                break;
            }
            case VOID: {
                result = "V";
                break;
            }
        }
        return result;
    }

    protected static String getTicketElementName(SuTicket ticket) {
        if (ticket.getReportTicketType() == BaseSalesReportTicket.ReportTicketType.MEMO) {
            return "ADM";
        }
        if (ticket.getStatus() == ProductStatus.VOID) {
            return "CANCEL";
        }
        switch (ticket.getProductCategory()) {
            case AIR: {
                return "TCT";
            }
            case MCO: {
                if (ticket.getMcoCategory() == MCOCategory.RETURN_TICKET) {
                    return "TCT";
                }
                return "MCO";
            }
            case EXCESS_BAGAGE: {
                return "EBT";
            }
        }
        return null;
    }

    protected static Element getChildElement(Element parent, String name) {
        NodeList nodes = parent.getElementsByTagNameNS(parent.getNamespaceURI(), name);
        if (nodes.getLength() >= 1) {
            return (Element)nodes.item(nodes.getLength() - 1);
        }
        return null;
    }

    protected static Element getDocElement(Element parent) {
        Element xmlTransaction = UNXmlBatchHandler.getChildElement(parent, "TRANSACTION");
        if (xmlTransaction != null) {
            return UNXmlBatchHandler.getChildElement(xmlTransaction, "DOC");
        }
        return null;
    }

    protected static Element getFopElement(Element parent) {
        Element xmlTransaction = UNXmlBatchHandler.getChildElement(parent, "TRANSACTION");
        if (xmlTransaction != null) {
            return UNXmlBatchHandler.getChildElement(xmlTransaction, "FOP");
        }
        return null;
    }

    protected static Element getTicketElement(Element parent) {
        Element docElement = UNXmlBatchHandler.getDocElement(parent);
        if (docElement != null) {
            return UNXmlBatchHandler.getChildElement(docElement, "TCT");
        }
        return null;
    }

    protected static Element getMemoElement(Element parent) {
        Element docElement = UNXmlBatchHandler.getDocElement(parent);
        if (docElement != null) {
            return UNXmlBatchHandler.getChildElement(docElement, "ADM");
        }
        return null;
    }

    protected static Element getBagageElement(Element parent) {
        Element docElement = UNXmlBatchHandler.getDocElement(parent);
        if (docElement != null) {
            return UNXmlBatchHandler.getChildElement(docElement, "EBT");
        }
        return null;
    }

    protected Element getTicketElement(Element parent, SuTicket ticket) {
        Element docElement = UNXmlBatchHandler.getDocElement(parent);
        if (docElement != null) {
            switch (ticket.getProductCategory()) {
                case AIR: {
                    if (ticket.getStatus() == ProductStatus.VOID) {
                        return UNXmlBatchHandler.getChildElement(docElement, "CANCEL");
                    }
                    return UNXmlBatchHandler.getChildElement(docElement, "TCT");
                }
                case MCO: {
                    return UNXmlBatchHandler.getChildElement(docElement, "MCO");
                }
            }
        }
        return null;
    }

    protected List<Segment> getConjCoupons(SuTicket ticket, int conjIndex) {
        ArrayList<Segment> activeCoupons = new ArrayList<Segment>();
        for (Segment segment : ticket.getSegments()) {
            if (segment.getRecordNumber() <= ticket.getCouponsCount() * conjIndex) continue;
            if (segment.getRecordNumber() > ticket.getCouponsCount() * (conjIndex + 1)) break;
            activeCoupons.add(segment);
        }
        return activeCoupons;
    }

    protected static String getFirstBlankCouponsNames(SuTicket ticket) {
        StringBuilder buf = new StringBuilder();
        switch (ticket.getStatus()) {
            case EXCHANGE: 
            case REFUND: 
            case SELL: {
                buf.append(UNXmlBatchHandler.getCouponNames(ticket, 0));
                break;
            }
        }
        return buf.toString();
    }

    protected static String getCouponNames(SuTicket ticket, int blankIndex) {
        int i;
        StringBuilder result = new StringBuilder();
        int couponsCnt = ticket.getCouponsCount();
        int segmentMaxNo = couponsCnt * (ticket.getConjCount() + 1);
        String[] segmentsTab = new String[segmentMaxNo];
        String voidCoupon = " ";
        String notVoidCoupon = "R";
        switch (ticket.getStatus()) {
            case SELL: {
                voidCoupon = "V";
                notVoidCoupon = "F";
                break;
            }
        }
        for (int i2 = 0; i2 < segmentMaxNo; ++i2) {
            segmentsTab[i2] = voidCoupon;
        }
        for (Segment seg : ticket.getSegments()) {
            if (seg.getRecordNumber() <= 0 || seg.getRecordNumber() > segmentMaxNo) continue;
            segmentsTab[seg.getRecordNumber() - 1] = notVoidCoupon;
        }
        for (i = 0; i < segmentMaxNo - 1; ++i) {
            if (!segmentsTab[i].equals("V") || !segmentsTab[i + 1].equals("F")) continue;
            segmentsTab[i] = "S";
        }
        for (i = 0; i < couponsCnt; ++i) {
            result.append(segmentsTab[i + blankIndex * couponsCnt]);
        }
        return result.toString();
    }

    protected String getExchangeMarker() throws Exception {
        return "\u041d\u0415\u0422";
    }

    private List<Segment> getActiveCoupons(SuTicket ticket) {
        return this.getConjCoupons(ticket, 0);
    }

    private int getConjRecordNumber(int couponsCount, int recordNumber) {
        if (recordNumber > couponsCount) {
            int recNo = recordNumber % couponsCount;
            return recNo == 0 ? couponsCount : recNo;
        }
        return recordNumber;
    }

    protected void addEbtTicketTransaction(Document doc, Element parent, SuTicket ticket, int ticketNo) throws Exception {
        Element xmlEbtItem = UNXmlBatchHandler.getBagageElement(parent);
        if (xmlEbtItem != null) {
            String[] conjunctions;
            Element xmlTransaction;
            xmlEbtItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", ticket.isSticker() ? ticket.getStickerCouponNames() : UNXmlBatchHandler.getFirstBlankCouponsNames(ticket)));
            Element xmlFareItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FARE", null);
            this.addFareItem(doc, parent.getNamespaceURI(), xmlFareItem, ticket);
            xmlEbtItem.appendChild(xmlFareItem);
            this.appendTaxesElement(xmlEbtItem, ticket, doc, parent);
            if (!TextUtil.isBlank((String)ticket.getMainTicketNumber())) {
                String mainTicketNumber = (!TextUtil.isBlank((String)ticket.getMainTicketSeries()) ? ticket.getMainTicketSeries() : ticket.getTicketSeries()) + " " + ticket.getMainTicketNumber();
                Element xmlMainDocs = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOCS", null);
                Element xmlMainDoc = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "MAIN_DOC", null);
                Element xmlMainDocTDNR = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", mainTicketNumber);
                xmlMainDoc.appendChild(xmlMainDocTDNR);
                xmlMainDocs.appendChild(xmlMainDoc);
                xmlEbtItem.appendChild(xmlMainDocs);
            }
            Element xmlWeightItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "WEIGHT", Integer.toString((int)ticket.getLuggageWeight()));
            xmlEbtItem.appendChild(xmlWeightItem);
            Element xmlWeightRateItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "WEIGHT_RATE", "0");
            xmlEbtItem.appendChild(xmlWeightRateItem);
            List<Segment> segments = this.getActiveCoupons(ticket);
            if (!segments.isEmpty()) {
                Element xmlCouponsItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                for (Segment segment : segments) {
                    Element xmlCouponItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                    xmlCouponItem.setAttributeNS(null, "NO", "" + segment.getRecordNumber());
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", UNXmlBatchHandler.getCouponName(ticket)));
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", ("" + segment.getAirline().getCode()).trim()));
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                    xmlCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                    xmlCouponsItem.appendChild(xmlCouponItem);
                }
                xmlEbtItem.appendChild(xmlCouponsItem);
            }
            if ((xmlTransaction = UNXmlBatchHandler.getChildElement(parent, "TRANSACTION")) != null) {
                this.addFopSection(doc, parent, xmlTransaction, ticket);
            }
            if (!this.isBatchCancel && (conjunctions = ticket.getConjunctions()).length > 0) {
                Element xmlConjanctionsItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTIONS", null);
                for (int conjTicketNo = 1; conjTicketNo <= conjunctions.length; ++conjTicketNo) {
                    Element xmlConjanctionDocItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CONJUNCTION_DOC", null);
                    xmlConjanctionDocItem.setAttributeNS(null, "NO", Integer.toString(conjTicketNo));
                    xmlConjanctionDocItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "TDNR", ticket.getTicketSeries() + " " + conjunctions[conjTicketNo - 1]));
                    if (ticket.getConjunctionScns().length > 0) {
                        xmlConjanctionDocItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "SCNR", ticket.getConjunctionScns()[conjTicketNo - 1]));
                    }
                    xmlConjanctionDocItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", UNXmlBatchHandler.getCouponNames(ticket, conjTicketNo)));
                    Element xmlConjCouponsItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPONS", null);
                    for (Segment segment : this.getConjCoupons(ticket, conjTicketNo)) {
                        Element xmlConjCouponItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "COUPON", null);
                        xmlConjCouponItem.setAttributeNS(null, "NO", "" + this.getConjRecordNumber(ticket.getCouponsCount(), segment.getRecordNumber()));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CPUI", UNXmlBatchHandler.getCouponName(ticket)));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "CARR", segment.getAirline().getCode()));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTNR", segment.getFlightNo()));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "ORAC", DictHelper.getAirportCode((DictionaryReference)segment.getDepartureLocation(), (CodeSystem)CodeSystem.IATA)));
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "DSTC", DictHelper.getAirportCode((DictionaryReference)segment.getArriveLocation(), (CodeSystem)CodeSystem.IATA)));
                        if (segment.getStartDate() != null) {
                            xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDA", new SimpleDateFormat("yyyy-MM-dd").format(segment.getStartDate())));
                            xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FTDT", new SimpleDateFormat("HH:mm:ss").format(segment.getStartDate())));
                        }
                        xmlConjCouponItem.appendChild(UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "FBTD", segment.getFareBasis()));
                        xmlConjCouponsItem.appendChild(xmlConjCouponItem);
                    }
                    xmlConjanctionDocItem.appendChild(xmlConjCouponsItem);
                    xmlConjanctionsItem.appendChild(xmlConjanctionDocItem);
                    xmlEbtItem.appendChild(xmlConjanctionsItem);
                }
            }
            Element xmlLuggageUnitsItem = UNXmlBatchHandler.writeElement(doc, parent.getNamespaceURI(), "BAGGAGE_ALLOWANCE", ticket.getLuggageUnits() == LuggageUnits.WEIGHT_KG ? "K" : "P");
            xmlEbtItem.appendChild(xmlLuggageUnitsItem);
        }
    }

    private String getSuRefundedCoupons(SuTicket ticket) {
        int couponsCnt = ticket.getCouponsCount();
        int segmentMaxNo = couponsCnt * (ticket.getConjCount() + 1);
        char[] coupons = new char[segmentMaxNo];
        for (int i = 0; i < segmentMaxNo; ++i) {
            coupons[i] = 32;
        }
        for (Segment seg : ticket.getSegments()) {
            if (seg.getRecordNumber() <= 0 || seg.getRecordNumber() > segmentMaxNo) continue;
            coupons[seg.getRecordNumber() - 1] = Character.forDigit(seg.getRecordNumber(), 10);
        }
        return new String(coupons);
    }

    private String getS7RefundedCoupons(SuTicket ticket) {
        int couponsCnt = ticket.getSegments().size();
        char[] coupons = new char[couponsCnt];
        for (Segment seg : ticket.getSegments()) {
            if (seg.getRecordNumber() <= 0 || seg.getRecordNumber() > couponsCnt) continue;
            coupons[seg.getRecordNumber() - 1] = 82;
        }
        return new String(coupons);
    }

    private String getLuggageFBAL(double luggageWeight, LuggageUnits luggageUnits) {
        String res = "NO";
        if (luggageWeight > 0.0) {
            String units = "K";
            String amount = String.valueOf(Math.round(luggageWeight));
            if (amount.length() > 2) {
                amount = amount.substring(0, 2);
            }
            if (luggageUnits == LuggageUnits.PIECE) {
                units = "PC";
                if (amount.length() > 1) {
                    amount = amount.substring(0, 1);
                }
            }
            res = amount + units;
        }
        return res;
    }
}

