/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.vv;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSuRegistryWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class VvRegisterWorksheetHandler<T extends SuTicket>
extends BaseSuRegistryWorksheetHandler<SuTicket> {
    protected static final int START_ROW_INDEX = 12;

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<BaseSalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        ArrayList tickets = (ArrayList)data.getTickets();
        if (tickets.isEmpty()) {
            return;
        }
        int lineNumber = 12;
        String[] colNames = new String[]{"A", "B", "C", "D", "E", "F"};
        for (BaseSalesReportTicket t : tickets) {
            SuTicket ticket = (SuTicket)t;
            ExcelUtils.insertRow((HSSFSheet)sheet, (int)lineNumber, (int)6, (int)10);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)1, (String)(ticket.getTicketSeries() + " " + ticket.getTicketNumber()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)2, (String)ticket.getTicketRouting());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)3, (String)String.format(new Locale("RU"), "%1$te %1$tB", ticket.getIssueDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)4, (BigDecimal)ticket.getEquivalentFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)5, (BigDecimal)BigDecimal.valueOf(ticket.getTaxAmount()));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)6, (String)String.format("SUM(D%1$d:E%1$d)", lineNumber));
            ++lineNumber;
        }
        for (int colIndex = 4; colIndex <= 6; ++colIndex) {
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(lineNumber + 1), (int)1, (int)1, (int)colIndex, (String)String.format("SUM(%1$s%2$d:%1$s%3$d)", colNames[colIndex - 1], 12, lineNumber - 1));
        }
        sheet.setForceFormulaRecalculation(true);
        this.updateGlobalData(sheet, globalData);
    }
}

