/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.vv;

import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.vv.VvRegisterWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.vv.VvTotalWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.stockcontrol.vv.VvStockcontrolReportOverviewRenderHandler;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VvRegistryRender<T extends SuTicket>
extends BasePoiSalesReportRenderHandler<SuTicket> {
    @Override
    protected List<PoiWorksheetData<SuTicket>> createDataList() {
        ArrayList<PoiWorksheetData<SuTicket>> worksheetData = new ArrayList<PoiWorksheetData<SuTicket>>();
        worksheetData.add(new BaseWorksheetData<SuTicket>(){

            @Override
            public String getBatchId() {
                return "TOTAL";
            }

            @Override
            public PoiWorksheetDefinition<SuTicket> getDefinition() {
                return Definitions.TOTAL;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        worksheetData.add(new BaseWorksheetData<SuTicket>(){

            @Override
            public String getBatchId() {
                return "STOCK";
            }

            @Override
            public PoiWorksheetDefinition<SuTicket> getDefinition() {
                return Definitions.STOCK;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        worksheetData.add(new BaseWorksheetData<SuTicket>(){

            @Override
            public String getBatchId() {
                return "SALE";
            }

            @Override
            public PoiWorksheetDefinition<SuTicket> getDefinition() {
                return Definitions.REGISTER;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        return worksheetData;
    }

    @Override
    protected String getTemplateFileName() {
        return "VvReport.xls";
    }

    @Override
    protected void initializeDataList(List<PoiWorksheetData<SuTicket>> dataList, Map<String, Object> data) {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList == null) {
            return;
        }
        for (ReportBatchData batchData : batchDataList) {
            for (PoiWorksheetData<SuTicket> wd : dataList) {
                if (!MiscUtil.equals((Object)wd.getBatchId(), (Object)batchData.getBatchId())) continue;
                wd.getTickets().addAll(batchData.getTickets());
            }
        }
    }

    @Override
    public String getId() {
        return null;
    }

    public static enum Definitions implements PoiWorksheetDefinition<SuTicket>
    {
        REGISTER{

            @Override
            public PoiWorksheetHandler<SuTicket> getHandler() {
                return new VvRegisterWorksheetHandler();
            }
        }
        ,
        TOTAL{

            @Override
            public PoiWorksheetHandler<SuTicket> getHandler() {
                return new VvTotalWorksheetHandler();
            }
        }
        ,
        STOCK{

            @Override
            public PoiWorksheetHandler<SuTicket> getHandler() {
                return new VvStockcontrolReportOverviewRenderHandler();
            }
        };


        @Override
        public String getWorksheetTemplateName() {
            return this.name();
        }
    }
}

