/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.xf;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFTicket;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XFRegistryExchangeListWorksheetHandler
implements PoiWorksheetHandler<XFTicket> {
    private static final int TICKETS_ROW_OFFSET = 5;

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<XFTicket> data, Map<String, Object> globalData) throws Exception {
        BaseReportParameters parameters = (BaseReportParameters)globalData.get("key-report-params");
        Date startDate = parameters.getPeriodBegin();
        Date endDate = parameters.getPeriodEnd();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_START", (String)dateFormat.format(startDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_END", (String)dateFormat.format(endDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)globalData.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)((String)globalData.get("AGENCY_DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)globalData.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_CHIEF_MUTUAL", (String)((String)globalData.get("AGENCY_CHIEF_MUTUAL")));
        List<XFTicket> tickets = data.getTickets();
        if (tickets.isEmpty()) {
            return;
        }
        int shiftLinesCount = sheet.getLastRowNum() - 5;
        int lineNumber = 5;
        for (int i = 0; i < tickets.size(); ++i) {
            XFTicket ticket = tickets.get(i);
            ++lineNumber;
            if (i < tickets.size() - 1) {
                ExcelUtils.insertRow((HSSFSheet)sheet, (int)lineNumber, (int)12, (int)shiftLinesCount);
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)1, (int)(i + 1));
            String number = XFReportHelper.getNumberString(ticket.getBlankOwnerCode(), ticket.getPreviousProductSystemNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)2, (int)1, (int)1, (String)number);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)3, (int)1, (int)1, (Date)ticket.getPreviousProductIssueDate());
            String flightNumbers = XFReportHelper.getFlightNumbersString(ticket.getPreviousProductFlightNumbers());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)4, (int)1, (int)1, (String)flightNumbers);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)5, (int)1, (int)1, (String)ticket.getPreviousProductRouting());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)6, (int)1, (int)1, (Date)ticket.getPreviousProductFirstFlightDepartureDate());
            String fareBasises = XFReportHelper.getFareBasisesString(ticket.getPreviousProductFareBasises());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)7, (int)1, (int)1, (String)fareBasises);
            number = XFReportHelper.getNumberString(ticket.getBlankOwnerCode(), ticket.getNextProductSystemNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)8, (int)1, (int)1, (String)number);
            fareBasises = XFReportHelper.getFareBasisesString(ticket.getNextProductFareBasises());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)9, (int)1, (int)1, (String)fareBasises);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)10, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getNextProductEquivalentFare()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)11, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getPreviousProductEquivalentFare()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)12, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getExchangeProductEquivalentExcessFare()));
            String mcoSystemNumbers = XFReportHelper.getMCOSystemNumbersString(ticket.getMCOSystemNumbers());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)13, (int)1, (int)1, (String)mcoSystemNumbers);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)14, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getMCOEquivalentFares()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)15, (int)1, (int)1, (Double)ReportHelper.getNonNullValue(ticket.getExchangeProductVendorCommissionRate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)16, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getExchangeProductEquivalentExcessVendorCommissionAmount()));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)17, (int)1, (int)1, (String)String.format("=L%s+N%s-P%s", lineNumber, lineNumber, lineNumber));
        }
        Integer startRangeIndex = 6;
        Integer endRangeIndex = 6 + tickets.size() - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(++lineNumber), (int)10, (int)1, (int)1, (String)String.format("=SUM(J%s:J%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)11, (int)1, (int)1, (String)String.format("=SUM(K%s:K%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)12, (int)1, (int)1, (String)String.format("=SUM(L%s:L%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)14, (int)1, (int)1, (String)String.format("=SUM(N%s:N%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)16, (int)1, (int)1, (String)String.format("=SUM(P%s:P%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)17, (int)1, (int)1, (String)String.format("=SUM(Q%s:Q%s)", startRangeIndex, endRangeIndex));
    }
}

