/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.xf;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFRegistryExchangeListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFRegistryRefundListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFRegistrySellListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFSettlementLetterMVLListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFSettlementLetterVVLListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFTicket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XFSalesReportRenderHandler
extends BasePoiSalesReportRenderHandler<XFTicket> {
    @Override
    protected List<PoiWorksheetData<XFTicket>> createDataList() {
        ArrayList<PoiWorksheetData<XFTicket>> result = new ArrayList<PoiWorksheetData<XFTicket>>();
        result.add(new BaseWorksheetData<XFTicket>(){

            @Override
            public String getBatchId() {
                return "SETTLEMENT_LETTER_VVL";
            }

            @Override
            public PoiWorksheetDefinition<XFTicket> getDefinition() {
                return Definitions.SETTLEMENT_LETTER_VVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<XFTicket>(){

            @Override
            public String getBatchId() {
                return "SETTLEMENT_LETTER_MVL";
            }

            @Override
            public PoiWorksheetDefinition<XFTicket> getDefinition() {
                return Definitions.SETTLEMENT_LETTER_MVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<XFTicket>(){

            @Override
            public String getBatchId() {
                return "REGISTER_SELL_VVL";
            }

            @Override
            public PoiWorksheetDefinition<XFTicket> getDefinition() {
                return Definitions.REGISTER_SELL_VVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<XFTicket>(){

            @Override
            public String getBatchId() {
                return "REGISTER_SELL_MVL";
            }

            @Override
            public PoiWorksheetDefinition<XFTicket> getDefinition() {
                return Definitions.REGISTER_SELL_MVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<XFTicket>(){

            @Override
            public String getBatchId() {
                return "REGISTER_REFUND_VVL";
            }

            @Override
            public PoiWorksheetDefinition<XFTicket> getDefinition() {
                return Definitions.REGISTER_REFUND_VVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<XFTicket>(){

            @Override
            public String getBatchId() {
                return "REGISTER_REFUND_MVL";
            }

            @Override
            public PoiWorksheetDefinition<XFTicket> getDefinition() {
                return Definitions.REGISTER_REFUND_MVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<XFTicket>(){

            @Override
            public String getBatchId() {
                return "REGISTER_EXCHANGE_VVL";
            }

            @Override
            public PoiWorksheetDefinition<XFTicket> getDefinition() {
                return Definitions.REGISTER_EXCHANGE_VVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<XFTicket>(){

            @Override
            public String getBatchId() {
                return "REGISTER_EXCHANGE_MVL";
            }

            @Override
            public PoiWorksheetDefinition<XFTicket> getDefinition() {
                return Definitions.REGISTER_EXCHANGE_MVL;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        return result;
    }

    @Override
    protected void initializeDataList(List<PoiWorksheetData<XFTicket>> dataList, Map<String, Object> data) {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList == null) {
            return;
        }
        for (ReportBatchData batchData : batchDataList) {
            String batchID = batchData.getBatchId();
            for (PoiWorksheetData<XFTicket> wd : dataList) {
                Definitions definition = (Definitions)wd.getDefinition();
                if (!(("SELL_VVL".equals(batchID) || "VOID_VVL".equals(batchID)) && definition == Definitions.REGISTER_SELL_VVL || ("SELL_MVL".equals(batchID) || "VOID_MVL".equals(batchID)) && definition == Definitions.REGISTER_SELL_MVL || "REFUND_VVL".equals(batchID) && definition == Definitions.REGISTER_REFUND_VVL || "REFUND_MVL".equals(batchID) && definition == Definitions.REGISTER_REFUND_MVL || "EXCHANGE_VVL".equals(batchID) && definition == Definitions.REGISTER_EXCHANGE_VVL) && (!"EXCHANGE_MVL".equals(batchID) || definition != Definitions.REGISTER_EXCHANGE_MVL)) continue;
                wd.getTickets().addAll(batchData.getTickets());
            }
        }
    }

    @Override
    protected String getTemplateFileName() {
        return "VladivistokAviaSalesReport.xls";
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        String part1 = (String)data.get("AIRLINE_IATA_CODE") + "_" + (String)data.get("AGENCY_IATA_CODE") + "_";
        String part2 = (String)data.get("KEY_REPORT_FILENAME");
        return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_reportTitle, (Object[])new Object[]{part1, part2}).toString();
    }

    @Override
    public String getId() {
        return "xf-sales-report-render-handler";
    }

    public static enum Definitions implements PoiWorksheetDefinition<XFTicket>
    {
        SETTLEMENT_LETTER_VVL{

            @Override
            public PoiWorksheetHandler<XFTicket> getHandler() {
                return new XFSettlementLetterVVLListWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_letterVvl, (Object[])new Object[0]).toString();
            }
        }
        ,
        SETTLEMENT_LETTER_MVL{

            @Override
            public PoiWorksheetHandler<XFTicket> getHandler() {
                return new XFSettlementLetterMVLListWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_letterMvl, (Object[])new Object[0]).toString();
            }
        }
        ,
        REGISTER_SELL_VVL{

            @Override
            public PoiWorksheetHandler<XFTicket> getHandler() {
                return new XFRegistrySellListWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_sellVvl, (Object[])new Object[0]).toString();
            }
        }
        ,
        REGISTER_SELL_MVL{

            @Override
            public PoiWorksheetHandler<XFTicket> getHandler() {
                return new XFRegistrySellListWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_sellMvl, (Object[])new Object[0]).toString();
            }
        }
        ,
        REGISTER_REFUND_VVL{

            @Override
            public PoiWorksheetHandler<XFTicket> getHandler() {
                return new XFRegistryRefundListWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_refundVvl, (Object[])new Object[0]).toString();
            }
        }
        ,
        REGISTER_REFUND_MVL{

            @Override
            public PoiWorksheetHandler<XFTicket> getHandler() {
                return new XFRegistryRefundListWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_refundMvl, (Object[])new Object[0]).toString();
            }
        }
        ,
        REGISTER_EXCHANGE_VVL{

            @Override
            public PoiWorksheetHandler<XFTicket> getHandler() {
                return new XFRegistryExchangeListWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_exchangeVvl, (Object[])new Object[0]).toString();
            }
        }
        ,
        REGISTER_EXCHANGE_MVL{

            @Override
            public PoiWorksheetHandler<XFTicket> getHandler() {
                return new XFRegistryExchangeListWorksheetHandler();
            }

            @Override
            public String getWorksheetTemplateName() {
                return L10nResourcesManager.createL10nMessage((String)Messages.XFSalesReportRenderHandler_exchangeMvl, (Object[])new Object[0]).toString();
            }
        };

    }
}

