/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.xf;

import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFTicket;
import java.io.Serializable;
import java.math.BigDecimal;

public class XFSettlementLetterData
implements Serializable {
    private static final long serialVersionUID = 8112882032875881920L;
    private BigDecimal totalSellEquivalentFare;
    private BigDecimal totalSellOtherTaxesAmount;
    private BigDecimal totalSellYRTaxesAmount;
    private BigDecimal totalSellEquivalentVendorCommissionAmount;
    private BigDecimal totalMCOEquivalentFare;
    private BigDecimal totalMCOPenaltyAmount;
    private BigDecimal totalMCOEquivalentVendorCommissionAmount;
    private BigDecimal totalRefundEquivalentFare;
    private BigDecimal totalRefundOtherTaxesAmount;
    private BigDecimal totalRefundPenaltyAmount;
    private BigDecimal totalRefundYRTaxesAmount;
    private BigDecimal totalRefundEquivalentVendorCommissionAmount;
    private BigDecimal totalExchangeEquivalentExcessFare;
    private BigDecimal totalExchangeEquivalentExcessVendorCommissionAmount;

    public void update(XFTicket ticket) {
        if (ticket.getProductCategory() == ProductCategory.MCO) {
            this.updateMCO(ticket);
        } else {
            String batchID = ticket.getBatchId();
            if (batchID.equals("SELL_VVL") || batchID.equals("SELL_MVL")) {
                this.updateSell(ticket);
            } else if (batchID.equals("REFUND_VVL") || batchID.equals("REFUND_MVL")) {
                this.updateRefund(ticket);
            } else if (batchID.equals("EXCHANGE_VVL") || batchID.equals("EXCHANGE_MVL")) {
                this.updateExchange(ticket);
            }
        }
    }

    private void updateMCO(XFTicket ticket) {
        BigDecimal equivalentVendorCommissionAmount;
        BigDecimal penalty = ticket.getEquivalentFare();
        if (penalty != null) {
            BigDecimal bigDecimal = this.totalMCOPenaltyAmount = this.totalMCOPenaltyAmount != null ? this.totalMCOPenaltyAmount.add(penalty) : penalty;
        }
        if ((equivalentVendorCommissionAmount = ticket.getVendorEquivalentCommission()) != null) {
            this.totalMCOEquivalentVendorCommissionAmount = this.totalMCOEquivalentVendorCommissionAmount != null ? this.totalMCOEquivalentVendorCommissionAmount.add(equivalentVendorCommissionAmount) : equivalentVendorCommissionAmount;
        }
    }

    private void updateSell(XFTicket ticket) {
        BigDecimal equivalentVendorCommissionAmount;
        BigDecimal yrTaxesAmount;
        BigDecimal otherTaxesAmount;
        BigDecimal equivalentFare = ticket.getEquivalentFare();
        if (equivalentFare != null) {
            BigDecimal bigDecimal = this.totalSellEquivalentFare = this.totalSellEquivalentFare != null ? this.totalSellEquivalentFare.add(equivalentFare) : equivalentFare;
        }
        if ((otherTaxesAmount = ticket.getOtherTaxesAmount()) != null) {
            BigDecimal bigDecimal = this.totalSellOtherTaxesAmount = this.totalSellOtherTaxesAmount != null ? this.totalSellOtherTaxesAmount.add(otherTaxesAmount) : otherTaxesAmount;
        }
        if ((yrTaxesAmount = ticket.getYRTaxesAmount()) != null) {
            BigDecimal bigDecimal = this.totalSellYRTaxesAmount = this.totalSellYRTaxesAmount != null ? this.totalSellYRTaxesAmount.add(yrTaxesAmount) : yrTaxesAmount;
        }
        if ((equivalentVendorCommissionAmount = ticket.getVendorEquivalentCommission()) != null) {
            this.totalSellEquivalentVendorCommissionAmount = this.totalSellEquivalentVendorCommissionAmount != null ? this.totalSellEquivalentVendorCommissionAmount.add(equivalentVendorCommissionAmount) : equivalentVendorCommissionAmount;
        }
    }

    private void updateRefund(XFTicket ticket) {
        BigDecimal equivalentVendorCommissionAmount;
        BigDecimal yrTaxesAmount;
        BigDecimal penaltyAmount;
        BigDecimal otherTaxesAmount;
        BigDecimal equivalentFare = ticket.getEquivalentFare();
        if (equivalentFare != null) {
            BigDecimal bigDecimal = this.totalRefundEquivalentFare = this.totalRefundEquivalentFare != null ? this.totalRefundEquivalentFare.add(equivalentFare) : equivalentFare;
        }
        if ((otherTaxesAmount = ticket.getOtherTaxesAmount()) != null) {
            BigDecimal bigDecimal = this.totalRefundOtherTaxesAmount = this.totalRefundOtherTaxesAmount != null ? this.totalRefundOtherTaxesAmount.add(otherTaxesAmount) : otherTaxesAmount;
        }
        if ((penaltyAmount = ticket.getPenalty()) != null) {
            BigDecimal bigDecimal = this.totalRefundPenaltyAmount = this.totalRefundPenaltyAmount != null ? this.totalRefundPenaltyAmount.add(penaltyAmount) : penaltyAmount;
        }
        if ((yrTaxesAmount = ticket.getYRTaxesAmount()) != null) {
            BigDecimal bigDecimal = this.totalRefundYRTaxesAmount = this.totalRefundYRTaxesAmount != null ? this.totalRefundYRTaxesAmount.add(yrTaxesAmount) : yrTaxesAmount;
        }
        if ((equivalentVendorCommissionAmount = ticket.getVendorEquivalentCommission()) != null) {
            this.totalRefundEquivalentVendorCommissionAmount = this.totalRefundEquivalentVendorCommissionAmount != null ? this.totalRefundEquivalentVendorCommissionAmount.add(equivalentVendorCommissionAmount) : equivalentVendorCommissionAmount;
        }
    }

    private void updateExchange(XFTicket ticket) {
        BigDecimal equivalentExcessVendorCommissionAmount;
        BigDecimal equivalentExcessFare = ticket.getExchangeProductEquivalentExcessFare();
        if (equivalentExcessFare != null) {
            BigDecimal bigDecimal = this.totalExchangeEquivalentExcessFare = this.totalExchangeEquivalentExcessFare != null ? this.totalExchangeEquivalentExcessFare.add(equivalentExcessFare) : equivalentExcessFare;
        }
        if ((equivalentExcessVendorCommissionAmount = ticket.getExchangeProductEquivalentExcessVendorCommissionAmount()) != null) {
            this.totalExchangeEquivalentExcessVendorCommissionAmount = this.totalExchangeEquivalentExcessVendorCommissionAmount != null ? this.totalExchangeEquivalentExcessVendorCommissionAmount.add(equivalentExcessVendorCommissionAmount) : equivalentExcessVendorCommissionAmount;
        }
    }

    public BigDecimal getTotalSellEquivalentFare() {
        return this.totalSellEquivalentFare;
    }

    public BigDecimal getTotalSellOtherTaxesAmount() {
        return this.totalSellOtherTaxesAmount;
    }

    public BigDecimal getTotalSellYRTaxesAmount() {
        return this.totalSellYRTaxesAmount;
    }

    public BigDecimal getTotalSellEquivalentVendorCommissionAmount() {
        return this.totalSellEquivalentVendorCommissionAmount;
    }

    public BigDecimal getTotalMCOEquivalentFare() {
        return this.totalMCOEquivalentFare;
    }

    public BigDecimal getTotalMCOPenaltyAmount() {
        return this.totalMCOPenaltyAmount;
    }

    public BigDecimal getTotalMCOEquivalentVendorCommissionAmount() {
        return this.totalMCOEquivalentVendorCommissionAmount;
    }

    public BigDecimal getTotalRefundEquivalentFare() {
        return this.totalRefundEquivalentFare;
    }

    public BigDecimal getTotalRefundOtherTaxesAmount() {
        return this.totalRefundOtherTaxesAmount;
    }

    public BigDecimal getTotalRefundPenaltyAmount() {
        return this.totalRefundPenaltyAmount;
    }

    public BigDecimal getTotalRefundYRTaxesAmount() {
        return this.totalRefundYRTaxesAmount;
    }

    public BigDecimal getTotalRefundEquivalentVendorCommissionAmount() {
        return this.totalRefundEquivalentVendorCommissionAmount;
    }

    public BigDecimal getTotalExchangeEquivalentExcessFare() {
        return this.totalExchangeEquivalentExcessFare;
    }

    public BigDecimal getTotalExchangeEquivalentExcessVendorCommissionAmount() {
        return this.totalExchangeEquivalentExcessVendorCommissionAmount;
    }
}

