/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.ReportRenderHandler;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public abstract class BasePoiStockcontrolReportRender
implements ReportRenderHandler {
    public EntityContainer<ReportDocument> renderReport(Map<String, Object> parameters) throws Exception {
        return this.prepareReport(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityContainer<ReportDocument> prepareReport(Map<String, Object> data) throws Exception {
        try (InputStream is = IoUtil.getResourceInputStream((File)this.getTemplateFile());){
            EntityContainer entityContainer;
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                this.prepareReport(wb, data);
                wb.write((OutputStream)os);
                ReportFile file = new ReportFile();
                String reportTitle = ReportHelper.cleanUpFileName(this.getReportTitle(data));
                file.setTitle(reportTitle);
                file.setContentType(ContentType.EXCEL);
                file.setContent(os.toByteArray());
                file.setName(ReportHelper.cleanUpFileName(this.getReportFileName(data)));
                EntityContainer result = new EntityContainer(ReportDocument.class);
                ((ReportDocument)result.getEntity()).getFiles().add(file);
                List messages = (List)data.get("key-messages");
                if (messages != null) {
                    ((ReportDocument)result.getEntity()).getMessages().addAll(messages);
                }
                ((ReportDocument)result.getEntity()).setParameters((ReportParameters)data.get("key-report-params"));
                ((ReportDocument)result.getEntity()).setCreated(new Date());
                entityContainer = result;
            }
            catch (Throwable throwable) {
                os.close();
                throw throwable;
            }
            os.close();
            return entityContainer;
        }
    }

    protected abstract void prepareReport(HSSFWorkbook var1, Map<String, Object> var2) throws Exception;

    protected File getTemplateFile() throws IOException {
        File result = IoUtil.url2file((URL)BasePoiStockcontrolReportRender.class.getResource("/stockcontrolreports/" + this.getTemplateFileName()));
        if (!result.exists()) {
            throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.PoiStockControl_noTemplateFound, (Object[])new Object[]{result.getCanonicalPath()}).toString());
        }
        return result;
    }

    protected abstract String getTemplateFileName();

    protected abstract String getReportTitle(Map<String, Object> var1);

    protected String getReportFileName(Map<String, Object> data) {
        return this.getTemplateFileName();
    }
}

