/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.stockcontrol.BlankOrderLogItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BasePoiStockcontrolReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStockcontrolOverviewReportRender
extends BasePoiStockcontrolReportRender {
    protected final Set<String> blankTypeCodes = new HashSet<String>();
    protected EntityReference<BaseProfile> currentLocation = null;
    protected static final BlankBatchTrigger TRIGGER_ONTT = new BlankBatchTrigger(){

        @Override
        public boolean isSameBatch(StockBlank blank1, StockBlank blank2) {
            if (MiscUtil.equals((Object)blank1, (Object)blank2)) {
                return true;
            }
            return FormattedNumberUtil.isInRange((String)blank2.getNumber(), (String)blank1.getNumber(), (long)1L) && MiscUtil.equals((Object)blank1.getOwner(), (Object)blank2.getOwner()) && MiscUtil.equals((Object)blank1.getType(), (Object)blank2.getType());
        }
    };

    protected abstract Map<String, StockOverviewBatchList> createDataMap(Map<String, Object> var1);

    protected void initializeDataMap(Map<String, StockOverviewBatchList> dataMap, Map<String, Object> data) {
        SearchCriterion searchCriterion;
        Set blanks = (Set)data.get("key-batch-data-list");
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        Date beginDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        if (blanks == null) {
            return;
        }
        SearchCriterion.SimpleCriterion simpleCriterion = null;
        Iterator iterator = params.getAdditionalCriterions().iterator();
        while (!(!iterator.hasNext() || (searchCriterion = (SearchCriterion)iterator.next()) instanceof SearchCriterion.SimpleCriterion && (simpleCriterion = (SearchCriterion.SimpleCriterion)searchCriterion).getProperty().equals(StockBlankIndex.Property.currentLocation.name()) && simpleCriterion.getValue() != null && simpleCriterion.getValue() instanceof EntityReference)) {
        }
        this.currentLocation = simpleCriterion != null ? (EntityReference)simpleCriterion.getValue() : null;
        this.blankTypeCodes.clear();
        for (StockBlank blank : blanks) {
            for (StockOverviewBatchList list : dataMap.values()) {
                list.addBlank(blank, beginDate, endDate);
            }
        }
    }

    public static List<BlankBatch> aggregateBatches(Collection<StockBlank> blanks, BlankBatchTrigger trigger) {
        StockBlank startBlank;
        if (blanks == null || blanks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StockBlank> list = new ArrayList<StockBlank>(blanks);
        Collections.sort(list, new Comparator<StockBlank>(){

            @Override
            public int compare(StockBlank o1, StockBlank o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        ArrayList<BlankBatch> result = new ArrayList<BlankBatch>();
        StockBlank prevBlank = startBlank = (StockBlank)list.get(0);
        int count = 0;
        for (StockBlank blank : list) {
            ++count;
            if (!trigger.isSameBatch(prevBlank, blank)) {
                result.add(BaseStockcontrolOverviewReportRender.createBatch(startBlank, count - 1));
                count = 1;
                startBlank = blank;
            }
            prevBlank = blank;
        }
        if (count > 0) {
            result.add(BaseStockcontrolOverviewReportRender.createBatch(startBlank, count));
        }
        return result;
    }

    protected static BlankBatch createBatch(final StockBlank blank, final int count) {
        return new BlankBatch(){

            @Override
            public int getBlanksCount() {
                return count;
            }

            @Override
            public String getFirstBlankNumber() {
                return blank.getNumber();
            }

            @Override
            public String getLastBlankNumber() {
                if (count <= 0) {
                    return "";
                }
                if (count == 1) {
                    return blank.getNumber();
                }
                return FormattedNumberUtil.add((String)blank.getNumber(), (long)(count - 1));
            }
        };
    }

    public static String getLastDiffNumbers(String number1, String number2, int len) {
        String result = "-?";
        if (number1 == null || number2 == null || len <= 0) {
            return result;
        }
        if (number1.length() < len || number2.length() < len) {
            return result;
        }
        if (number1.length() != number2.length()) {
            return result;
        }
        int startIndex = number1.length() - len;
        if (number1.substring(startIndex).equals(number2.substring(startIndex))) {
            return BaseStockcontrolOverviewReportRender.getLastDiffNumbers(number1, number2, len + 1);
        }
        return "-" + number2.substring(startIndex);
    }

    protected static String getBlankName(DictionaryReference<BlankType> blankTypeRef) {
        if (blankTypeRef == null) {
            return null;
        }
        BlankType bt = (BlankType)DictionaryCache.get().resolveReference(blankTypeRef);
        if (bt != null) {
            return bt.getName();
        }
        return blankTypeRef.getCode();
    }

    protected Logger getLog() {
        return LoggerFactory.getLogger(this.getClass());
    }

    protected EntityReference<? extends BaseProfile> getBlankCurrentLocation(StockBlank blank, Date endDate) {
        EntityReference blankCurrentLocation = null;
        for (BlankOrderLogItem blankOrderLogItem : blank.getOrderLogItems()) {
            if (blankOrderLogItem.getOperationDate().compareTo(endDate) > 0) continue;
            blankCurrentLocation = blankOrderLogItem.getBlankLocation();
        }
        return blankCurrentLocation;
    }

    public abstract class BaseEndStockOverviewBatchList
    extends AbstractStockOverviewBatchList {
        @Override
        public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
            boolean isVPDateAfter;
            boolean isNotNullVPDate;
            boolean isNullOperDate;
            if (blank.getUsageStatus() == null) {
                return false;
            }
            if (blank.getRegistrationDate() == null) {
                return false;
            }
            boolean isRegistrationDateBefor = MiscUtil.compare((Date)blank.getRegistrationDate(), (Date)endDate) <= 0;
            boolean bl = isNullOperDate = blank.getOperationDate() == null;
            boolean isOperDateAfter = blank.getOperationDate() == null ? false : MiscUtil.compare((Date)blank.getOperationDate(), (Date)endDate) > 0;
            boolean bl2 = isNotNullVPDate = blank.getVendorPaymentDate() != null;
            boolean bl3 = blank.getVendorPaymentDate() == null ? false : (isVPDateAfter = MiscUtil.compare((Date)blank.getVendorPaymentDate(), (Date)endDate) > 0);
            if (isRegistrationDateBefor && (isNullOperDate || isOperDateAfter || isNotNullVPDate && isVPDateAfter) && this.isAdditionalConditionsCompleted(blank, beginDate, endDate)) {
                return super.addBlank(blank);
            }
            return false;
        }

        @Override
        public boolean isAdditionalConditionsCompleted(StockBlank blank, Date beginDate, Date endDate) {
            if (BaseStockcontrolOverviewReportRender.this.currentLocation != null) {
                EntityReference<? extends BaseProfile> blankCurrentLocation = BaseStockcontrolOverviewReportRender.this.getBlankCurrentLocation(blank, endDate);
                return blankCurrentLocation != null && blankCurrentLocation.equals(BaseStockcontrolOverviewReportRender.this.currentLocation);
            }
            return true;
        }
    }

    public abstract class BaseOutStockOverviewBatchList
    extends AbstractStockOverviewBatchList {
        @Override
        public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
            boolean isVPDateBetween;
            boolean isNotNullVPDate;
            boolean isNotNullOperDate;
            if (blank.getUsageStatus() == null) {
                return false;
            }
            boolean bl = isNotNullOperDate = blank.getOperationDate() != null;
            boolean isOperDateBetween = blank.getOperationDate() == null ? false : MiscUtil.compare((Date)blank.getOperationDate(), (Date)beginDate) >= 0 && MiscUtil.compare((Date)blank.getOperationDate(), (Date)endDate) <= 0;
            boolean bl2 = isNotNullVPDate = blank.getVendorPaymentDate() != null;
            boolean bl3 = blank.getVendorPaymentDate() == null ? false : (isVPDateBetween = MiscUtil.compare((Date)blank.getVendorPaymentDate(), (Date)beginDate) >= 0 && MiscUtil.compare((Date)blank.getVendorPaymentDate(), (Date)endDate) <= 0);
            if (isNotNullOperDate && isOperDateBetween || isNotNullVPDate && isVPDateBetween || this.isAdditionalConditionsCompleted(blank, beginDate, endDate)) {
                return super.addBlank(blank);
            }
            return false;
        }

        @Override
        public boolean isAdditionalConditionsCompleted(StockBlank blank, Date beginDate, Date endDate) {
            if (BaseStockcontrolOverviewReportRender.this.currentLocation != null) {
                EntityReference<? extends BaseProfile> blankCurrentLocation = BaseStockcontrolOverviewReportRender.this.getBlankCurrentLocation(blank, endDate);
                return blankCurrentLocation != null && !blankCurrentLocation.equals(BaseStockcontrolOverviewReportRender.this.currentLocation);
            }
            return false;
        }
    }

    public abstract class BaseInStockOverviewBatchList
    extends AbstractStockOverviewBatchList {
        @Override
        public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
            boolean isRegistredBetween;
            if (blank.getRegistrationDate() == null) {
                return false;
            }
            boolean bl = isRegistredBetween = MiscUtil.compare((Date)blank.getRegistrationDate(), (Date)beginDate) >= 0 && MiscUtil.compare((Date)blank.getRegistrationDate(), (Date)endDate) <= 0;
            if (isRegistredBetween) {
                return super.addBlank(blank);
            }
            return false;
        }
    }

    public abstract class BaseStartStockOverviewBatchList
    extends AbstractStockOverviewBatchList {
        @Override
        public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
            boolean isVPDateBetween;
            boolean isNotNullVPDate;
            boolean isNullOperDate;
            if (blank.getUsageStatus() == null) {
                return false;
            }
            if (blank.getRegistrationDate() == null) {
                return false;
            }
            boolean isRegistredBefore = MiscUtil.compare((Date)blank.getRegistrationDate(), (Date)beginDate) < 0;
            boolean bl = isNullOperDate = blank.getOperationDate() == null;
            boolean isOperDateBetween = blank.getOperationDate() == null ? false : MiscUtil.compare((Date)blank.getOperationDate(), (Date)beginDate) >= 0;
            boolean bl2 = isNotNullVPDate = blank.getVendorPaymentDate() != null;
            boolean bl3 = blank.getVendorPaymentDate() == null ? false : (isVPDateBetween = MiscUtil.compare((Date)blank.getVendorPaymentDate(), (Date)beginDate) >= 0);
            if (isRegistredBefore && (isNullOperDate || isOperDateBetween || isNotNullVPDate && isVPDateBetween)) {
                return super.addBlank(blank);
            }
            return false;
        }
    }

    public abstract class AbstractStockOverviewBatchList
    implements StockOverviewBatchList {
        protected Map<String, List<StockBlank>> blankMap = new HashMap<String, List<StockBlank>>();

        @Override
        public Map<String, List<StockBlank>> getBlanks() {
            return this.blankMap;
        }

        @Override
        public List<BlankBatch> getList(String blankTypeCode) {
            List<StockBlank> list = this.blankMap.get(blankTypeCode);
            if (list == null || list.isEmpty()) {
                return Collections.emptyList();
            }
            return BaseStockcontrolOverviewReportRender.aggregateBatches(list, TRIGGER_ONTT);
        }

        public boolean addBlank(StockBlank blank) {
            String blankTypeCode = BaseStockcontrolOverviewReportRender.getBlankName((DictionaryReference<BlankType>)blank.getType());
            if (blankTypeCode != null) {
                List<StockBlank> list = this.blankMap.get(blankTypeCode);
                if (list == null) {
                    list = new ArrayList<StockBlank>();
                    this.blankMap.put(blankTypeCode, list);
                }
                list.add(blank);
                BaseStockcontrolOverviewReportRender.this.blankTypeCodes.add(blankTypeCode);
                return true;
            }
            return false;
        }

        @Override
        public boolean isAdditionalConditionsCompleted(StockBlank blank, Date startDate, Date endDate) {
            return true;
        }
    }

    protected static interface BlankBatchTrigger {
        public boolean isSameBatch(StockBlank var1, StockBlank var2);
    }

    public static interface StockOverviewBatchList {
        public Map<String, List<StockBlank>> getBlanks();

        public List<BlankBatch> getList(String var1);

        public boolean addBlank(StockBlank var1, Date var2, Date var3);

        public boolean isAdditionalConditionsCompleted(StockBlank var1, Date var2, Date var3);

        public StockOverviewDefinition getDefinition();
    }

    protected static interface StockOverviewDefinition {
        public int[] getStartPosition(String var1);
    }
}

