/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.fv;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class FvStockcontrolReportOverviewRenderHandler
extends BaseStockcontrolOverviewReportRender {
    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return "fv-StockOverview.xls";
    }

    @Override
    protected String getTemplateFileName() {
        return "FvStockOverview.xls";
    }

    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        dataLists.put(ListDefinitions.START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.START;
            }
        });
        dataLists.put(ListDefinitions.IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.IN;
            }
        });
        dataLists.put(ListDefinitions.OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.OUT;
            }
        });
        dataLists.put(ListDefinitions.END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.END;
            }
        });
        return dataLists;
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) {
        Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData = this.createDataMap(data);
        this.initializeDataMap(workbookData, data);
        List messages = (List)data.get("key-messages");
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            SystemHelper.addMessage((Collection)messages, (String)L10nResourcesManager.createL10nMessage((String)Messages.FvStockcontrolReportOverviewRenderHandler_cantFindWorkbookSheet, (Object[])new Object[0]).toString(), null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        sheet.setForceFormulaRecalculation(true);
        this.addBatchRows(workbookData.get(ListDefinitions.END.name()), sheet, workbookData);
        this.addBatchRows(workbookData.get(ListDefinitions.OUT.name()), sheet, workbookData);
        this.addBatchRows(workbookData.get(ListDefinitions.IN.name()), sheet, workbookData);
        this.addBatchRows(workbookData.get(ListDefinitions.START.name()), sheet, workbookData);
        try {
            this.updateReportHeader(sheet, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (wb.getNumberOfSheets() > 0) {
            wb.getSheetAt(0).setActive(true);
        }
    }

    private void addBatchRows(BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchList, HSSFSheet sheet, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData) {
        int startRow;
        if (batchList.getBlanks().keySet().isEmpty()) {
            return;
        }
        List<BlankBatch> batches = null;
        int batchSize = 0;
        int rowsTotal = 0;
        int y = startRow = batchList.getDefinition().getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            batchSize = batches.size();
            rowsTotal += batchSize;
            try {
                for (int i = 5; i < rowsTotal; ++i) {
                    ExcelUtils.copyRows((HSSFSheet)sheet, (int)(startRow + 3), (int)(startRow + 3));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int cnt = 0; cnt < batchSize; ++cnt) {
                this.addBatchRow(sheet, batches.get(cnt), 3, y + cnt);
            }
            y += batchSize;
        }
    }

    private void addBatchRow(HSSFSheet sheet, BlankBatch blankBatch, int x, int y) {
        try {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)1, (String)blankBatch.getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)2, (String)blankBatch.getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)3, (int)blankBatch.getBlanksCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateReportHeader(HSSFSheet sheet, Map<String, Object> data) throws Exception {
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)((String)data.get("AGENCY_DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)data.get("AGENCY_ACCOUNTANT")));
    }

    @Override
    public String getId() {
        return "fv-stock-control-report";
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{11};
            }
        }
        ,
        IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{17};
            }
        }
        ,
        OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{23};
            }
        }
        ,
        END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{35};
            }
        };

    }
}

