/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.hy;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class HyStockControlReportOverviewRenderHandler
extends BaseStockcontrolOverviewReportRender {
    private static String summarySheetName = L10nResourcesManager.createL10nMessage((String)Messages.HyStockControlReportOverviewRenderHandler_summary, (Object[])new Object[0]).toString();
    private static String f1SheetName = L10nResourcesManager.createL10nMessage((String)Messages.HyStockControlReportOverviewRenderHandler_f1, (Object[])new Object[0]).toString();
    private static String f2SheetName = L10nResourcesManager.createL10nMessage((String)Messages.HyStockControlReportOverviewRenderHandler_f2, (Object[])new Object[0]).toString();
    private static String f3SheetName = L10nResourcesManager.createL10nMessage((String)Messages.HyStockControlReportOverviewRenderHandler_f3, (Object[])new Object[0]).toString();

    @Override
    public String getId() {
        return "hy-stock-control-report";
    }

    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        dataLists.put(ListDefinitions.AIR_START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.AIR_START;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.AIR;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.AIR_IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.AIR_IN;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.AIR;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.AIR_OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.AIR_OUT;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.AIR;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.AIR_END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.AIR_END;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.AIR;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.MCO_START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.MCO_START;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.MCO;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.MCO_IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.MCO_IN;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.MCO;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.MCO_OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.MCO_OUT;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.MCO;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.MCO_END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.MCO_END;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.MCO;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.EXCESS_BAGAGE_START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.EXCESS_BAGAGE_START;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.EXCESS_BAGAGE;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.EXCESS_BAGAGE_IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.EXCESS_BAGAGE_IN;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.EXCESS_BAGAGE;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.EXCESS_BAGAGE_OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.EXCESS_BAGAGE_OUT;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.EXCESS_BAGAGE;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        dataLists.put(ListDefinitions.EXCESS_BAGAGE_END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.EXCESS_BAGAGE_END;
            }

            @Override
            public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
                boolean result = false;
                BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
                if (blankType != null) {
                    boolean bl = result = blankType.getProductCategory() == ProductCategory.EXCESS_BAGAGE;
                }
                if (result) {
                    return super.addBlank(blank, beginDate, endDate);
                }
                return result;
            }
        });
        return dataLists;
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData = this.createDataMap(data);
        this.initializeDataMap(workbookData, data);
        List messages = (List)data.get("key-messages");
        this.renderSummaryReport(data, messages, workbookData, wb);
        this.renderF1(data, messages, workbookData, wb);
        this.renderF2(data, messages, workbookData, wb);
        this.renderF3(data, messages, workbookData, wb);
    }

    private void renderSummaryReport(Map<String, Object> data, List<Message> messages, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData, HSSFWorkbook wb) throws Exception {
        HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)summarySheetName);
        if (sheet == null) {
            SystemHelper.addMessage(messages, (String)Messages.HyStockcontrolReportOverviewRenderHandler_cantFindWorkbookSheet, (String)summarySheetName, null, (Object[])new Object[]{MessageType.ERROR});
            return;
        }
        this.updateReportHeader(sheet, data);
        int startRow = ListDefinitions.MCO_OUT.getStartPosition(null)[0];
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchList = workbookData.get(ListDefinitions.MCO_END.name());
        List<BlankBatch> batches = null;
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.EXCESS_BAGAGE_END.name());
        startRow = ListDefinitions.EXCESS_BAGAGE_IN.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.AIR_END.name());
        startRow = ListDefinitions.AIR_START.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
    }

    private void renderF1(Map<String, Object> data, List<Message> messages, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData, HSSFWorkbook wb) throws Exception {
        HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)f1SheetName);
        if (sheet == null) {
            SystemHelper.addMessage(messages, (String)Messages.HyStockcontrolReportOverviewRenderHandler_cantFindWorkbookSheet, (String)f1SheetName, null, (Object[])new Object[]{MessageType.ERROR});
            return;
        }
        this.updateReportHeader(sheet, data);
        int startRow = ListDefinitions.AIR_END.getStartPosition(null)[0];
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchList = workbookData.get(ListDefinitions.AIR_END.name());
        List<BlankBatch> batches = null;
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.AIR_OUT.name());
        startRow = ListDefinitions.AIR_OUT.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.AIR_IN.name());
        startRow = ListDefinitions.AIR_IN.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.AIR_START.name());
        startRow = ListDefinitions.AIR_START.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
    }

    private void renderF2(Map<String, Object> data, List<Message> messages, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData, HSSFWorkbook wb) throws Exception {
        HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)f2SheetName);
        if (sheet == null) {
            SystemHelper.addMessage(messages, (String)Messages.HyStockcontrolReportOverviewRenderHandler_cantFindWorkbookSheet, (String)f2SheetName, null, (Object[])new Object[]{MessageType.ERROR});
            return;
        }
        this.updateReportHeader(sheet, data);
        int startRow = ListDefinitions.MCO_END.getStartPosition(null)[0];
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchList = workbookData.get(ListDefinitions.MCO_END.name());
        List<BlankBatch> batches = null;
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.MCO_OUT.name());
        startRow = ListDefinitions.MCO_OUT.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.MCO_IN.name());
        startRow = ListDefinitions.MCO_IN.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.MCO_START.name());
        startRow = ListDefinitions.MCO_START.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
    }

    private void renderF3(Map<String, Object> data, List<Message> messages, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData, HSSFWorkbook wb) throws Exception {
        HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)f3SheetName);
        if (sheet == null) {
            SystemHelper.addMessage(messages, (String)Messages.HyStockcontrolReportOverviewRenderHandler_cantFindWorkbookSheet, (String)f3SheetName, null, (Object[])new Object[]{MessageType.ERROR});
            return;
        }
        this.updateReportHeader(sheet, data);
        int startRow = ListDefinitions.EXCESS_BAGAGE_END.getStartPosition(null)[0];
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchList = workbookData.get(ListDefinitions.EXCESS_BAGAGE_END.name());
        List<BlankBatch> batches = null;
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.EXCESS_BAGAGE_OUT.name());
        startRow = ListDefinitions.EXCESS_BAGAGE_OUT.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.EXCESS_BAGAGE_IN.name());
        startRow = ListDefinitions.EXCESS_BAGAGE_IN.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
        batchList = workbookData.get(ListDefinitions.EXCESS_BAGAGE_START.name());
        startRow = ListDefinitions.EXCESS_BAGAGE_START.getStartPosition(null)[0];
        for (String blankType : batchList.getBlanks().keySet()) {
            batches = batchList.getList(blankType);
            startRow = this.addRows(sheet, startRow, batches.size(), batches);
        }
    }

    private int addRows(HSSFSheet sheet, int startRow, int rowCounter, List<BlankBatch> batches) throws Exception {
        if (batches.isEmpty()) {
            return startRow;
        }
        for (int i = 1; i < rowCounter; ++i) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)startRow, (int)startRow);
        }
        int endRow = 0;
        int currentRow = startRow + 1;
        for (BlankBatch batch : batches) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)batch.getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (String)batch.getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (int)batch.getBlanksCount());
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (String)String.format("SUM(E%s:E%s)", startRow + 1, endRow));
        return currentRow;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.HyStockControlReportOverview_reportTitle, (Object[])new Object[]{data.get("AGENCY_NAME"), data.get("KEY_REPORT_FILENAME")}).toString();
    }

    @Override
    protected String getTemplateFileName() {
        return "HyStockOverview.xls";
    }

    @Override
    protected String getReportFileName(Map<String, Object> data) {
        return this.getReportTitle(data) + ".xls";
    }

    private void updateReportHeader(HSSFSheet sheet, Map<String, Object> data) {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_END", (String)df.format(params.getPeriodEnd()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"VENDOR_NAME", (String)params.getBlankOwner().getCaption());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)data.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)((String)data.get("REPORT_PERIOD")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)((String)data.get("AGENCY_DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)data.get("AGENCY_ACCOUNTANT")));
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        AIR_START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{9};
            }
        }
        ,
        AIR_IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{12};
            }
        }
        ,
        AIR_OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{15};
            }
        }
        ,
        AIR_END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{19};
            }
        }
        ,
        MCO_START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{9};
            }
        }
        ,
        MCO_IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{12};
            }
        }
        ,
        MCO_OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{15};
            }
        }
        ,
        MCO_END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{19};
            }
        }
        ,
        EXCESS_BAGAGE_START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{9};
            }
        }
        ,
        EXCESS_BAGAGE_IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{12};
            }
        }
        ,
        EXCESS_BAGAGE_OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{15};
            }
        }
        ,
        EXCESS_BAGAGE_END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{19};
            }
        };

    }
}

