/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.s7;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class S7StockcontrolReportOverviewRenderHandler
extends BaseStockcontrolOverviewReportRender {
    private static final int START_POS = 2;
    private static final int IN_POS = 5;
    private static final int OUT_POS = 8;
    private static final int END_POS = 11;
    protected static final String blankTypeMco401 = "401";
    protected static final String blankTypeMco402 = "402";
    protected static final String blankTypeEbt451 = "451";
    protected static final String blankTypeEbt452 = "452";

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return "s7-StockOverview.xls";
    }

    @Override
    protected String getTemplateFileName() {
        return "S7StockOverview.xls";
    }

    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        dataLists.put(ListDefinitions.START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.START;
            }
        });
        dataLists.put(ListDefinitions.IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.IN;
            }
        });
        dataLists.put(ListDefinitions.OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.OUT;
            }
        });
        dataLists.put(ListDefinitions.END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.END;
            }
        });
        return dataLists;
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) {
        Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData = this.createDataMap(data);
        this.initializeDataMap(workbookData, data);
        List messages = (List)data.get("key-messages");
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            SystemHelper.addMessage((Collection)messages, (String)"Unable to find sheet ", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            return;
        }
        sheet.setForceFormulaRecalculation(true);
        this.addBatchRows(wb, sheet, blankTypeEbt452, workbookData);
        this.addBatchRows(wb, sheet, blankTypeEbt451, workbookData);
        this.addBatchRows(wb, sheet, blankTypeMco402, workbookData);
        this.addBatchRows(wb, sheet, blankTypeMco401, workbookData);
        try {
            this.updateReportHeader(sheet, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (wb.getNumberOfSheets() > 0) {
            wb.getSheetAt(0).setActive(true);
        }
    }

    private void updateReportHeader(HSSFSheet sheet, Map<String, Object> data) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Date_Start", (String)df.format(startDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Date_End", (String)df.format(endDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Name", (String)((String)data.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Code", (String)((String)data.get("AGENCY_IATA_CODE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Location", (String)((String)data.get("AGENT_LOCATION")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Director", (String)((String)data.get("DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Accountant", (String)((String)data.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agent_Name", (String)((String)data.get("AGENT_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Airline_Name", (String)((String)data.get("AIRLINE_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Email", (String)((String)data.get("AGENCY_EMAIL")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Phone", (String)((String)data.get("AGENCY_PHONE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Date_Create", (String)df.format(new Date()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)((String)data.get("REPORT_PERIOD")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)((String)data.get("CONTRACT_NO")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_ISSUE_DATE", (String)((String)data.get("CONTRACT_ISSUE_DATE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"EQ_CUR_CODE", (String)DictHelper.getLocalCurrency());
        ExcelUtils.replace((HSSFSheet)sheet, (String)"COUNTRY_NAME", (String)DictHelper.getDomesticCountryRussianName());
    }

    private void addBatchRows(HSSFWorkbook wb, HSSFSheet sheet, String blankType, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData) {
        if (blankType == null) {
            return;
        }
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListStart = workbookData.get(ListDefinitions.START.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListIn = workbookData.get(ListDefinitions.IN.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListOut = workbookData.get(ListDefinitions.OUT.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListEnd = workbookData.get(ListDefinitions.END.name());
        List<BlankBatch> bbStart = batchListStart.getList(blankType);
        List<BlankBatch> bbIn = batchListIn.getList(blankType);
        List<BlankBatch> bbOut = batchListOut.getList(blankType);
        List<BlankBatch> bbEnd = batchListEnd.getList(blankType);
        int maxSize = bbStart.size();
        if (bbIn.size() > maxSize) {
            maxSize = bbIn.size();
        }
        if (bbOut.size() > maxSize) {
            maxSize = bbOut.size();
        }
        if (bbEnd.size() > maxSize) {
            maxSize = bbEnd.size();
        }
        if (maxSize == 0) {
            return;
        }
        int xStart = batchListStart.getDefinition().getStartPosition(blankType)[0];
        int xIn = batchListIn.getDefinition().getStartPosition(blankType)[0];
        int xOut = batchListOut.getDefinition().getStartPosition(blankType)[0];
        int xEnd = batchListEnd.getDefinition().getStartPosition(blankType)[0];
        int y = batchListStart.getDefinition().getStartPosition(blankType)[1];
        try {
            if (maxSize > 2) {
                for (int i = 2; i <= maxSize - 1; ++i) {
                    this.addRow(wb, sheet, y + i - 1);
                }
                ExcelUtils.mergeCells((HSSFSheet)sheet, (int)y, (int)(y + maxSize - 1), (int)1, (int)1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int cnt = 0; cnt < maxSize; ++cnt) {
            if (bbStart.size() > cnt) {
                this.addBatchRow(sheet, bbStart.get(cnt), xStart, y + cnt);
            }
            if (bbIn.size() > cnt) {
                this.addBatchRow(sheet, bbIn.get(cnt), xIn, y + cnt);
            }
            if (bbOut.size() > cnt) {
                this.addBatchRow(sheet, bbOut.get(cnt), xOut, y + cnt);
            }
            if (bbEnd.size() <= cnt) continue;
            this.addBatchRow(sheet, bbEnd.get(cnt), xEnd, y + cnt);
        }
    }

    private void addBatchRow(HSSFSheet sheet, BlankBatch blankBatch, int x, int y) {
        try {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)1, (String)blankBatch.getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)2, (String)blankBatch.getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)3, (int)blankBatch.getBlanksCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getId() {
        return "s7-stock-control";
    }

    private void addRow(HSSFWorkbook wb, HSSFSheet sheet, int rowIndex) throws Exception {
        ExcelUtils.copyRows((HSSFSheet)sheet, (int)(rowIndex - 1), (int)(rowIndex - 1));
        for (int col = 2; col < 14; ++col) {
            HSSFCellStyle style = ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)rowIndex, (int)col);
            HSSFCellStyle clone = wb.createCellStyle();
            if (style != null) {
                clone.cloneStyleFrom(style);
            }
            clone.setBorderBottom((short)1);
            ExcelUtils.setCellStyle((HSSFSheet)sheet, (int)rowIndex, (int)col, (HSSFCellStyle)clone);
        }
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeMco401)) {
                    return new int[]{2, 14};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeMco402)) {
                    return new int[]{2, 16};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeEbt451)) {
                    return new int[]{2, 20};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeEbt452)) {
                    return new int[]{2, 22};
                }
                return null;
            }
        }
        ,
        IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeMco401)) {
                    return new int[]{5, 14};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeMco402)) {
                    return new int[]{5, 16};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeEbt451)) {
                    return new int[]{5, 20};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeEbt452)) {
                    return new int[]{5, 22};
                }
                return null;
            }
        }
        ,
        OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeMco401)) {
                    return new int[]{8, 14};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeMco402)) {
                    return new int[]{8, 16};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeEbt451)) {
                    return new int[]{8, 20};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeEbt452)) {
                    return new int[]{8, 22};
                }
                return null;
            }
        }
        ,
        END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeMco401)) {
                    return new int[]{11, 14};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeMco402)) {
                    return new int[]{11, 16};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeEbt451)) {
                    return new int[]{11, 20};
                }
                if (blankTypeCode.equals(S7StockcontrolReportOverviewRenderHandler.blankTypeEbt452)) {
                    return new int[]{11, 22};
                }
                return null;
            }
        };

    }
}

