/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.su;

import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SuStockcontrolReportOverviewRenderHandler
extends BaseStockcontrolOverviewReportRender {
    protected static final String blankType24 = "24";
    protected static final String blankType44 = "44";
    protected static final String blankTypeMco401 = "401";
    protected static final String blankTypeMco402 = "402";
    protected static final String blankTypeEbt451 = "451";
    protected static final String blankTypeEbt452 = "452";
    private static BlankTypeReference bpuReference = null;

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        Object agencyCode;
        String title = "";
        Object airlineIATACode = data.get("AIRLINE_IATA_CODE");
        if (airlineIATACode != null) {
            title = title + airlineIATACode + "_";
        }
        if ((agencyCode = data.get("AGENCY_IATA_CODE")) != null) {
            title = title + agencyCode + "_";
        }
        title = title + "\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435 \u0411\u0421\u041e";
        Object reportFilename = data.get("KEY_REPORT_FILENAME");
        if (reportFilename != null) {
            title = title + (String)reportFilename;
        }
        title = title + ".xls";
        return title;
    }

    @Override
    protected String getTemplateFileName() {
        return "SuStockOverview.xls";
    }

    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        dataLists.put(ListDefinitions.START.name(), new SuStartStockOverviewBatchList());
        dataLists.put(ListDefinitions.IN.name(), new SuInStockOverviewBatchList());
        dataLists.put(ListDefinitions.OUT.name(), new SuOutStockOverviewBatchList());
        dataLists.put(ListDefinitions.END.name(), new SuEndStockOverviewBatchList());
        return dataLists;
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) {
        Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData = this.createDataMap(data);
        this.initializeDataMap(workbookData, data);
        List messages = (List)data.get("key-messages");
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.SuStockcontrolReportOverview_unableFindSheet, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            return;
        }
        sheet.setForceFormulaRecalculation(true);
        this.addBatchRows(wb, sheet, blankTypeEbt452, workbookData);
        this.addBatchRows(wb, sheet, blankTypeEbt451, workbookData);
        this.addBatchRows(wb, sheet, blankTypeMco402, workbookData);
        this.addBatchRows(wb, sheet, blankTypeMco401, workbookData);
        this.addBatchRows(wb, sheet, blankType44, workbookData);
        this.addBatchRows(wb, sheet, blankType24, workbookData);
        this.addBlockRegularSummary(wb, sheet, workbookData);
        try {
            this.updateReportHeader(sheet, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (wb.getNumberOfSheets() > 0) {
            wb.getSheetAt(0).setActive(true);
        }
    }

    private void updateReportHeader(HSSFSheet sheet, Map<String, Object> data) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Date_Start", (String)df.format(startDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Date_End", (String)df.format(endDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Name", (String)((String)data.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Code", (String)((String)data.get("AGENCY_IATA_CODE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Location", (String)((String)data.get("AGENT_LOCATION")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Director", (String)((String)data.get("DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agency_Accountant", (String)((String)data.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"Agent_Name", (String)((String)data.get("AGENT_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"EQ_CUR_CODE", (String)DictHelper.getLocalCurrency());
    }

    private void addBlockRegularSummary(HSSFWorkbook wb, HSSFSheet sheet, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData) {
        SuStockOverviewBatchList batchListStart = (SuStockOverviewBatchList)((Object)workbookData.get(ListDefinitions.START.name()));
        SuStockOverviewBatchList batchListIn = (SuStockOverviewBatchList)((Object)workbookData.get(ListDefinitions.IN.name()));
        SuStockOverviewBatchList batchListOut = (SuStockOverviewBatchList)((Object)workbookData.get(ListDefinitions.OUT.name()));
        SuStockOverviewBatchList batchListEnd = (SuStockOverviewBatchList)((Object)workbookData.get(ListDefinitions.END.name()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"BLOCK_START", (String)String.valueOf(batchListStart.getBlockTicketsCount()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REGULAR_START", (String)String.valueOf(batchListStart.getRegularTicketsCount()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"BLOCK_IN", (String)String.valueOf(batchListIn.getBlockTicketsCount()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REGULAR_IN", (String)String.valueOf(batchListIn.getRegularTicketsCount()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"BLOCK_OUT", (String)String.valueOf(batchListOut.getBlockTicketsCount()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REGULAR_OUT", (String)String.valueOf(batchListOut.getRegularTicketsCount()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"BLOCK_END", (String)String.valueOf(batchListEnd.getBlockTicketsCount()));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REGULAR_END", (String)String.valueOf(batchListEnd.getRegularTicketsCount()));
    }

    private void addBatchRows(HSSFWorkbook wb, HSSFSheet sheet, String blankType, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData) {
        if (blankType == null) {
            return;
        }
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListStart = workbookData.get(ListDefinitions.START.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListIn = workbookData.get(ListDefinitions.IN.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListOut = workbookData.get(ListDefinitions.OUT.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListEnd = workbookData.get(ListDefinitions.END.name());
        List<BlankBatch> bbStart = batchListStart.getList(blankType);
        List<BlankBatch> bbIn = batchListIn.getList(blankType);
        List<BlankBatch> bbOut = batchListOut.getList(blankType);
        List<BlankBatch> bbEnd = batchListEnd.getList(blankType);
        int maxSize = bbStart.size();
        if (bbIn.size() > maxSize) {
            maxSize = bbIn.size();
        }
        if (bbOut.size() > maxSize) {
            maxSize = bbOut.size();
        }
        if (bbEnd.size() > maxSize) {
            maxSize = bbEnd.size();
        }
        if (maxSize == 0) {
            return;
        }
        int xStart = batchListStart.getDefinition().getStartPosition(blankType)[0];
        int xIn = batchListIn.getDefinition().getStartPosition(blankType)[0];
        int xOut = batchListOut.getDefinition().getStartPosition(blankType)[0];
        int xEnd = batchListEnd.getDefinition().getStartPosition(blankType)[0];
        int y = batchListStart.getDefinition().getStartPosition(blankType)[1];
        try {
            for (int i = 1; i < maxSize; ++i) {
                ExcelUtils.copyRows((HSSFSheet)sheet, (int)(y - 1), (int)(y - 1));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(y + 1), (int)1, (int)1, (int)1, (String)"");
                this.changeBorderStyle(wb, sheet, y, xStart + 2);
                this.changeBorderStyle(wb, sheet, y, xIn + 2);
                this.changeBorderStyle(wb, sheet, y, xOut + 2);
                this.changeBorderStyle(wb, sheet, y, xEnd + 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int cnt = 0; cnt < maxSize; ++cnt) {
            if (bbStart.size() > cnt) {
                this.addBatchRow(sheet, bbStart.get(cnt), xStart, y + cnt);
            }
            if (bbIn.size() > cnt) {
                this.addBatchRow(sheet, bbIn.get(cnt), xIn, y + cnt);
            }
            if (bbOut.size() > cnt) {
                this.addBatchRow(sheet, bbOut.get(cnt), xOut, y + cnt);
            }
            if (bbEnd.size() <= cnt) continue;
            this.addBatchRow(sheet, bbEnd.get(cnt), xEnd, y + cnt);
        }
    }

    private void addBatchRow(HSSFSheet sheet, BlankBatch blankBatch, int x, int y) {
        try {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)1, (String)blankBatch.getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)2, (String)blankBatch.getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)3, (int)blankBatch.getBlanksCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getId() {
        return "su-stock-control-report";
    }

    @Override
    protected String getReportFileName(Map<String, Object> data) {
        return this.getReportTitle(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected BlankTypeReference getBpuReference() {
        if (bpuReference != null) return bpuReference;
        Class<SuStockcontrolReportOverviewRenderHandler> clazz = SuStockcontrolReportOverviewRenderHandler.class;
        synchronized (SuStockcontrolReportOverviewRenderHandler.class) {
            if (bpuReference != null) return bpuReference;
            String bpuCode = "555 24";
            BlankType blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, bpuCode);
            bpuReference = blankType != null ? blankType.toReference() : null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return bpuReference;
        }
    }

    private void changeBorderStyle(HSSFWorkbook wb, HSSFSheet sheet, int row, int cell) throws Exception {
        HSSFCellStyle oldStyle = ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)row, (int)cell);
        HSSFCellStyle newStyle = wb.createCellStyle();
        if (oldStyle != null) {
            newStyle.cloneStyleFrom(oldStyle);
            newStyle.setBorderTop((short)1);
            ExcelUtils.setCellStyle((HSSFSheet)sheet, (int)(row + 1), (int)cell, (HSSFCellStyle)newStyle);
        }
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankType24)) {
                    return new int[]{2, 10};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankType44)) {
                    return new int[]{2, 13};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeMco401)) {
                    return new int[]{2, 17};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeMco402)) {
                    return new int[]{2, 17};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeEbt451)) {
                    return new int[]{2, 20};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeEbt452)) {
                    return new int[]{2, 20};
                }
                return null;
            }
        }
        ,
        IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankType24)) {
                    return new int[]{5, 10};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankType44)) {
                    return new int[]{5, 13};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeMco401)) {
                    return new int[]{5, 17};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeMco402)) {
                    return new int[]{5, 17};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeEbt451)) {
                    return new int[]{5, 20};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeEbt452)) {
                    return new int[]{5, 20};
                }
                return null;
            }
        }
        ,
        OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankType24)) {
                    return new int[]{8, 10};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankType44)) {
                    return new int[]{8, 13};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeMco401)) {
                    return new int[]{8, 17};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeMco402)) {
                    return new int[]{8, 17};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeEbt451)) {
                    return new int[]{8, 20};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeEbt452)) {
                    return new int[]{8, 20};
                }
                return null;
            }
        }
        ,
        END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankType24)) {
                    return new int[]{11, 10};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankType44)) {
                    return new int[]{11, 13};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeMco401)) {
                    return new int[]{11, 17};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeMco402)) {
                    return new int[]{11, 17};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeEbt451)) {
                    return new int[]{11, 20};
                }
                if (blankTypeCode.equals(SuStockcontrolReportOverviewRenderHandler.blankTypeEbt452)) {
                    return new int[]{11, 20};
                }
                return null;
            }
        };

    }

    class SuEndStockOverviewBatchList
    extends BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList
    implements SuStockOverviewBatchList {
        protected int blockTicketsCount;
        protected int regularTicketsCount;

        SuEndStockOverviewBatchList() {
        }

        @Override
        public int getBlockTicketsCount() {
            return this.blockTicketsCount;
        }

        @Override
        public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
            BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
            if (blankType != null && blankType.getProductCategory() == ProductCategory.AIR && blankType.getBlankCategory() == BlankCategory.GENERATED_NUMBER && !blankType.getName().equals(SuStockcontrolReportOverviewRenderHandler.blankType24)) {
                blank.setType((DictionaryReference)SuStockcontrolReportOverviewRenderHandler.this.getBpuReference());
            }
            if (super.addBlank(blank, beginDate, endDate)) {
                if (blank.getTariffType() == TariffType.BLOCKCHARTER || blank.getTariffType() == TariffType.CHARTER) {
                    ++this.blockTicketsCount;
                } else if (blank.getTariffType() == TariffType.REGULAR) {
                    ++this.regularTicketsCount;
                }
                return true;
            }
            return false;
        }

        @Override
        public int getRegularTicketsCount() {
            return this.regularTicketsCount;
        }

        @Override
        public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
            return ListDefinitions.END;
        }
    }

    class SuOutStockOverviewBatchList
    extends BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList
    implements SuStockOverviewBatchList {
        protected int blockTicketsCount;
        protected int regularTicketsCount;

        SuOutStockOverviewBatchList() {
        }

        @Override
        public int getBlockTicketsCount() {
            return this.blockTicketsCount;
        }

        @Override
        public int getRegularTicketsCount() {
            return this.regularTicketsCount;
        }

        @Override
        public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
            BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
            if (blankType != null && blankType.getProductCategory() == ProductCategory.AIR && blankType.getBlankCategory() == BlankCategory.GENERATED_NUMBER && !blankType.getName().equals(SuStockcontrolReportOverviewRenderHandler.blankType24)) {
                blank.setType((DictionaryReference)SuStockcontrolReportOverviewRenderHandler.this.getBpuReference());
            }
            if (super.addBlank(blank, beginDate, endDate)) {
                if (blank.getTariffType() == TariffType.BLOCKCHARTER || blank.getTariffType() == TariffType.CHARTER) {
                    ++this.blockTicketsCount;
                } else if (blank.getTariffType() == TariffType.REGULAR) {
                    ++this.regularTicketsCount;
                }
                return true;
            }
            return false;
        }

        @Override
        public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
            return ListDefinitions.OUT;
        }
    }

    class SuInStockOverviewBatchList
    extends BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList
    implements SuStockOverviewBatchList {
        protected int blockTicketsCount;
        protected int regularTicketsCount;

        SuInStockOverviewBatchList() {
        }

        @Override
        public int getBlockTicketsCount() {
            return this.blockTicketsCount;
        }

        @Override
        public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
            BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
            if (blankType != null && blankType.getProductCategory() == ProductCategory.AIR && blankType.getBlankCategory() == BlankCategory.GENERATED_NUMBER && !blankType.getName().equals(SuStockcontrolReportOverviewRenderHandler.blankType24)) {
                blank.setType((DictionaryReference)SuStockcontrolReportOverviewRenderHandler.this.getBpuReference());
            }
            if (super.addBlank(blank, beginDate, endDate)) {
                if (blank.getTariffType() == TariffType.BLOCKCHARTER || blank.getTariffType() == TariffType.CHARTER) {
                    ++this.blockTicketsCount;
                } else if (blank.getTariffType() == TariffType.REGULAR) {
                    ++this.regularTicketsCount;
                }
                return true;
            }
            return false;
        }

        @Override
        public int getRegularTicketsCount() {
            return this.regularTicketsCount;
        }

        @Override
        public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
            return ListDefinitions.IN;
        }
    }

    class SuStartStockOverviewBatchList
    extends BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList
    implements SuStockOverviewBatchList {
        private int blockTicketsCount;
        private int regularTicketsCount;

        SuStartStockOverviewBatchList() {
        }

        @Override
        public int getBlockTicketsCount() {
            return this.blockTicketsCount;
        }

        @Override
        public boolean addBlank(StockBlank blank, Date beginDate, Date endDate) {
            BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
            if (blankType != null && blankType.getProductCategory() == ProductCategory.AIR && blankType.getBlankCategory() == BlankCategory.GENERATED_NUMBER && !blankType.getName().equals(SuStockcontrolReportOverviewRenderHandler.blankType24)) {
                blank.setType((DictionaryReference)SuStockcontrolReportOverviewRenderHandler.this.getBpuReference());
            }
            if (super.addBlank(blank, beginDate, endDate)) {
                if (blank.getTariffType() == TariffType.BLOCKCHARTER || blank.getTariffType() == TariffType.CHARTER) {
                    ++this.blockTicketsCount;
                } else if (blank.getTariffType() == TariffType.REGULAR) {
                    ++this.regularTicketsCount;
                }
            }
            return false;
        }

        @Override
        public int getRegularTicketsCount() {
            return this.regularTicketsCount;
        }

        @Override
        public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
            return ListDefinitions.START;
        }
    }

    static interface SuStockOverviewBatchList {
        public int getBlockTicketsCount();

        public int getRegularTicketsCount();
    }
}

