/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.u6;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class U6StockControlReportOverviewRenderHandler
extends BaseStockcontrolOverviewReportRender {
    public static final int BLANK_TYPE_CELL_NUM = 1;
    private static String summarySheetName = L10nResourcesManager.createL10nMessage((String)Messages.U6StockControlReportOverviewRenderHandler_summarySheetName, (Object[])new Object[0]).toString();

    @Override
    public String getId() {
        return "u6-stock-control-report";
    }

    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        dataLists.put(ListDefinitions.BLANK_START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.BLANK_START;
            }
        });
        dataLists.put(ListDefinitions.BLANK_IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.BLANK_IN;
            }
        });
        dataLists.put(ListDefinitions.BLANK_OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.BLANK_OUT;
            }
        });
        dataLists.put(ListDefinitions.BLANK_END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.BLANK_END;
            }
        });
        return dataLists;
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData = this.createDataMap(data);
        this.initializeDataMap(workbookData, data);
        List messages = (List)data.get("key-messages");
        this.renderSummaryReport(data, messages, workbookData, wb);
    }

    private void renderSummaryReport(Map<String, Object> data, List<Message> messages, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData, HSSFWorkbook wb) throws Exception {
        HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)summarySheetName);
        if (sheet == null) {
            SystemHelper.addMessage(messages, (String)Messages.U6StockContorlOverviewRenderHandler_noSheetInTemplate, (String)summarySheetName, null, (Object[])new Object[]{MessageType.ERROR});
            return;
        }
        this.substituteAgencyInfo(sheet, data);
        int startRow = ListDefinitions.BLANK_END.getStartPosition(null)[0];
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchList = workbookData.get(ListDefinitions.BLANK_END.name());
        List<BlankBatch> batches = null;
        String blankType = sheet.getRow(startRow).getCell(1).getRichStringCellValue().getString();
        if (!TextUtil.isBlank((String)blankType)) {
            batches = batchList.getList(blankType);
            this.addRows(sheet, startRow, batches);
            if (!batches.isEmpty()) {
                startRow += batches.size() - 1;
            }
        }
        startRow = ListDefinitions.BLANK_OUT.getStartPosition(null)[0];
        batchList = workbookData.get(ListDefinitions.BLANK_OUT.name());
        blankType = sheet.getRow(startRow).getCell(1).getRichStringCellValue().getString();
        if (!TextUtil.isBlank((String)blankType)) {
            batches = batchList.getList(blankType);
            this.addRows(sheet, startRow, batches);
            if (!batches.isEmpty()) {
                startRow += batches.size() - 1;
            }
        }
        startRow = ListDefinitions.BLANK_IN.getStartPosition(null)[0];
        batchList = workbookData.get(ListDefinitions.BLANK_IN.name());
        blankType = sheet.getRow(startRow).getCell(1).getRichStringCellValue().getString();
        if (!TextUtil.isBlank((String)blankType)) {
            batches = batchList.getList(blankType);
            this.addRows(sheet, startRow, batches);
            if (!batches.isEmpty()) {
                startRow += batches.size() - 1;
            }
        }
        startRow = ListDefinitions.BLANK_START.getStartPosition(null)[0];
        batchList = workbookData.get(ListDefinitions.BLANK_START.name());
        blankType = sheet.getRow(startRow).getCell(1).getRichStringCellValue().getString();
        if (!TextUtil.isBlank((String)blankType)) {
            batches = batchList.getList(blankType);
            this.addRows(sheet, startRow, batches);
        }
    }

    private int addRows(HSSFSheet sheet, int startRow, List<BlankBatch> batches) throws Exception {
        if (batches.isEmpty()) {
            return startRow;
        }
        for (int i = 1; i < batches.size(); ++i) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)startRow, (int)startRow);
        }
        int endRow = 0;
        int currentRow = startRow + 1;
        for (BlankBatch batch : batches) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)batch.getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (String)batch.getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (int)batch.getBlanksCount());
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (String)String.format("SUM(E%s:E%s)", startRow + 1, endRow));
        ExcelUtils.mergeCells((HSSFSheet)sheet, (int)(startRow + 1), (int)endRow, (int)1, (int)1);
        ExcelUtils.mergeCells((HSSFSheet)sheet, (int)(startRow + 1), (int)endRow, (int)2, (int)2);
        return currentRow;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.U6StockControlReportOverviewRenderHandler_reportTitle, (Object[])new Object[]{data.get("AGENCY_NAME"), data.get("KEY_REPORT_FILENAME")}).toString();
    }

    @Override
    protected String getTemplateFileName() {
        return "U6StockOverview.xls";
    }

    @Override
    protected String getReportFileName(Map<String, Object> data) {
        return this.getReportTitle(data) + ".xls";
    }

    private void substituteAgencyInfo(HSSFSheet sheet, Map<String, Object> data) {
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)data.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)((String)data.get("REPORT_PERIOD")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)((String)data.get("AGENCY_DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)data.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"EQ_CUR_CODE", (String)DictHelper.getLocalCurrency());
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        BLANK_START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{5};
            }
        }
        ,
        BLANK_IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{7};
            }
        }
        ,
        BLANK_OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{9};
            }
        }
        ,
        BLANK_END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{11};
            }
        };

    }
}

