/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.vv;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class VvStockcontrolReportOverviewRenderHandler
extends BaseStockcontrolOverviewReportRender
implements PoiWorksheetHandler<SuTicket> {
    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        dataLists.put(ListDefinitions.START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.START;
            }
        });
        dataLists.put(ListDefinitions.IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.IN;
            }
        });
        dataLists.put(ListDefinitions.OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.OUT;
            }
        });
        dataLists.put(ListDefinitions.END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.END;
            }
        });
        return dataLists;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return "vv-StockOverview";
    }

    @Override
    protected String getTemplateFileName() {
        return "VvStockOverview.xls";
    }

    protected void renderReport(HSSFWorkbook wb, HSSFSheet sheet, Map<String, Object> data) throws Exception {
        Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData = this.createDataMap(data);
        this.initializeDataMap(workbookData, data);
        List messages = (List)data.get("key-messages");
        if (sheet == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.VvStockcontrolReportOverviewRenderHandler_cantFindWorkbookSheet, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        sheet.setForceFormulaRecalculation(true);
        this.addBatchRows(workbookData.get(ListDefinitions.END.name()), sheet, workbookData);
        this.addBatchRows(workbookData.get(ListDefinitions.OUT.name()), sheet, workbookData);
        this.addBatchRows(workbookData.get(ListDefinitions.IN.name()), sheet, workbookData);
        this.addBatchRows(workbookData.get(ListDefinitions.START.name()), sheet, workbookData);
        try {
            this.updateReportHeader(sheet, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addBatchRows(BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchList, HSSFSheet sheet, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData) {
        if (batchList.getList(null).isEmpty()) {
            return;
        }
        List<BlankBatch> batches = batchList.getList(null);
        int batchSize = batches.size();
        int y = batchList.getDefinition().getStartPosition(null)[0];
        try {
            for (int i = 5; i < batchSize; ++i) {
                ExcelUtils.copyRows((HSSFSheet)sheet, (int)(y + 3), (int)(y + 3));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int cnt = 0; cnt < batchSize; ++cnt) {
            this.addBatchRow(sheet, batches.get(cnt), 2, y + cnt);
        }
    }

    private void addBatchRow(HSSFSheet sheet, BlankBatch blankBatch, int x, int y) {
        try {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)1, (String)blankBatch.getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)2, (String)blankBatch.getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)x, (int)1, (int)3, (int)blankBatch.getBlanksCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateReportHeader(HSSFSheet sheet, Map<String, Object> data) throws Exception {
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)data.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DIRECTOR", (String)((String)data.get("DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)data.get("AGENCY_NAME")));
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_END", (String)dateFormat.format(params.getPeriodEnd()));
    }

    @Override
    public String getId() {
        return "vv-stock-control-report";
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SuTicket> data, Map<String, Object> globalData) throws Exception {
        Map stockControlData = (Map)globalData.get("key-stock-control-data");
        if (stockControlData != null) {
            this.renderReport(wb, sheet, stockControlData);
        }
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{7};
            }
        }
        ,
        IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{13};
            }
        }
        ,
        OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{20};
            }
        }
        ,
        END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{28};
            }
        };

    }
}

