/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.template.common;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportGlobalParameter;
import com.gridnine.xtrip.common.reports.render.template.common.QueryBuilder;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.search.utils.DynamicCriterionsHelper;
import com.gridnine.xtrip.common.system.model.SortOrderData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.MethodClosure;

public final class CommonTemplateReportHelper {
    public static <P extends BaseTemplateReportParameters, D extends BaseSingleFileTemplateReportDescription> List<SearchCriterion> getModifiedCriterions(P params, D description, List<Message> messages) {
        return CommonTemplateReportHelper.getModifiedCriterions(params, description, Collections.emptyList(), messages).getCriteria().getCriterions();
    }

    public static <P extends BaseTemplateReportParameters, D extends BaseSingleFileTemplateReportDescription> SearchQuery getModifiedCriterions(P params, D description, List<SortOrderData> sortOrderData, List<Message> messages) {
        SearchQuery result = null;
        Map<String, Object> dynamicParams = CommonTemplateReportHelper.getDynamicParams(params, description);
        if (TextUtil.isBlank((String)description.getQueryScript())) {
            result = new SearchQuery();
            result.getCriteria().getCriterions().addAll(description.getGlobalCriterions());
            for (SortOrderData item : sortOrderData) {
                result.getCriteria().getOrders().put(item.getPropertyName(), item.getOrder());
            }
        } else {
            result = CommonTemplateReportHelper.createQuery(description.getQueryScript(), dynamicParams, messages);
        }
        DynamicCriterionsHelper.updateQuery((StorageQuery)result, dynamicParams);
        return result;
    }

    protected static SearchQuery createQuery(String queryScript, Map<String, Object> parameters, List<Message> messages) {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding);
        QueryBuilder builder = new QueryBuilder();
        binding.setProperty("query", (Object)new MethodClosure((Object)new QueryClosure(builder), "doAction"));
        binding.setProperty("error", (Object)new MethodClosure((Object)new ErrorClosure(messages), "doAction"));
        binding.setProperty("parameters", parameters);
        shell.evaluate(queryScript);
        return builder.getQuery();
    }

    private static <P extends BaseTemplateReportParameters, D extends BaseTemplateReportDescription> Map<String, Object> getDynamicParams(P params, D description) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(CommonTemplateReportGlobalParameter.TODAY.name(), new Date());
        result.put(CommonTemplateReportGlobalParameter.REPORT_PERIOD_BEGIN.name(), MiscUtil.clearTime((Date)params.getPeriodBegin()));
        result.put(CommonTemplateReportGlobalParameter.REPORT_PERIOD_END.name(), MiscUtil.setDayEndTime((Date)params.getPeriodEnd()));
        for (RequestedParameterValue param : params.getRequestedParameters()) {
            result.put(param.getKey(), param.getValue());
        }
        return result;
    }

    private CommonTemplateReportHelper() {
    }

    static class ErrorClosure {
        private final List<Message> messages;

        ErrorClosure(List<Message> msgs) {
            this.messages = msgs;
        }

        public void doAction(String msg) {
            this.messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)msg, (Object[])new Object[0]));
        }
    }

    static class QueryClosure {
        private final QueryBuilder builder;

        QueryClosure(QueryBuilder bld) {
            this.builder = bld;
        }

        public void doAction(Closure<?> cl) {
            cl.setDelegate((Object)this.builder);
            cl.call();
        }

        public QueryBuilder getBuilder() {
            return this.builder;
        }
    }
}

