/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.timeout;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutTarget;

public class TimeoutFactory {
    private static Logger log = Logger.getLogger(TimeoutFactory.class);
    private static BasicThreadPool DEFAULT_TP = new BasicThreadPool("Timeouts");
    private Timer timer;
    private ThreadPool threadPool;
    static TimeoutFactory singleton;
    static int count;

    public TimeoutFactory(ThreadPool threadPool) {
        DEFAULT_TP.setBlockingMode(BlockingMode.RUN);
        this.threadPool = threadPool;
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                Thread.currentThread().setName("TimeoutFactory-" + count++);
            }
        }, 0L);
    }

    public TimeoutFactory() {
        this(DEFAULT_TP);
    }

    public TimerTask schedule(long time, Runnable run) {
        PooledRunner pr = new PooledRunner(run);
        this.timer.schedule((TimerTask)pr, new Date(time));
        return pr;
    }

    public Timeout schedule(long time, TimeoutTarget target) {
        TimeoutImpl t = new TimeoutImpl(target);
        this.timer.schedule((TimerTask)t, new Date(time));
        return t.timeout;
    }

    private static synchronized TimeoutFactory getSingleton() {
        if (singleton != null) {
            return singleton;
        }
        singleton = new TimeoutFactory(DEFAULT_TP);
        return singleton;
    }

    public static Timeout createTimeout(long time, TimeoutTarget target) {
        return TimeoutFactory.getSingleton().schedule(time, target);
    }

    public void cancel() {
        this.timer.cancel();
    }

    static {
        count = 0;
    }

    private class TimeoutImpl
    extends PooledRunner {
        Timeout timeout;

        public TimeoutImpl(TimeoutTarget target) {
            this.timeout = new Timeout(this){
                private final /* synthetic */ TimeoutImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public void cancel() {
                    this.this$1.cancel();
                }
            };
            this.run = new Runnable(this, target){
                private final /* synthetic */ TimeoutTarget val$target;
                private final /* synthetic */ TimeoutImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$target = val$target;
                }

                public void run() {
                    this.val$target.timedOut(this.this$1.timeout);
                }
            };
        }
    }

    private class PooledRunner
    extends TimerTask {
        Runnable run;

        PooledRunner() {
        }

        public PooledRunner(Runnable run) {
            this.run = run;
        }

        public void run() {
            try {
                TimeoutFactory.this.threadPool.run(this.run);
            }
            catch (Throwable t) {
                log.warn("Unable to pool timeout: " + this.run, t);
                try {
                    this.run.run();
                }
                catch (Throwable t2) {
                    log.error("Timeout failed to run unpooled: " + this.run, t2);
                }
            }
        }
    }
}

