/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.rules;

import com.gridnine.xtrip.common.bus.rules.BusProductPropertiesProvider;
import com.gridnine.xtrip.common.bus.rules.BusTargets;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.BasicCommonTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.DateInterval;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.FastDateFormat;

public enum BusProperties implements RuleProperty
{
    BUS_DEPARTURE_DATES{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_departureDatesSimple);
        }

        public String getRendererId() {
            return ValueTypes.DATE_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{BusTargets.BUS_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsBefore, (Object[])new Object[]{FDF.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsAfter, (Object[])new Object[]{FDF.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsInRange, (Object[])new Object[]{FDF.format(di.getBeginDate()), FDF.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsAfter, (Object[])new Object[]{FDF.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsBefore, (Object[])new Object[]{FDF.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_info_beyond, (Object[])new Object[]{FDF.format(di.getBeginDate()), FDF.format(di.getEndDate())}));
                }
                return;
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BusProductPropertiesProvider ps = (BusProductPropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            Date date = ps.getDepartureDate();
            if (Conditions.PERIOD_WITHIN.equals((Object)condition)) {
                if (di.getBeginDate() == null) {
                    return date != null && date.getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return date != null && date.getTime() >= di.getBeginDate().getTime();
                }
                return date != null && date.getTime() >= di.getBeginDate().getTime() && date.getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals((Object)condition)) {
                if (di.getBeginDate() == null) {
                    return date != null && date.getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return date != null && date.getTime() < di.getBeginDate().getTime();
                }
                return date != null && (date.getTime() < di.getBeginDate().getTime() || date.getTime() > di.getEndDate().getTime());
            }
            return true;
        }
    }
    ,
    BUS_PASSENGER_TYPE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerType);
        }

        public String getRendererId() {
            return ValueTypes.PASSENGER_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{BusTargets.BUS_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerType_info), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BusProductPropertiesProvider ps = (BusProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesDictRestriction((String)ps.getPassengerType(), (Collection)((List)value), (boolean)true);
            }
            return RulesHelper.matchesDictRestriction((String)ps.getPassengerType(), (Collection)((List)value), (boolean)false);
        }
    }
    ,
    BUS_PASSENGER_TYPE_CATEGORIES{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerTypeCategory);
        }

        public String getRendererId() {
            return ValueTypes.PASSENGER_TYPE_CATEGORY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{BusTargets.BUS_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerTypeCategory_info), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BusProductPropertiesProvider ps = (BusProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypeCategories(), (List)((List)value), (boolean)true);
            }
            return RulesHelper.matchesDictRestriction(ps.getPassengerTypeCategories(), (List)((List)value), (boolean)false);
        }
    }
    ,
    BUS_TOTAL_EQUIVALENT_FARE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_totalCost);
        }

        public String getRendererId() {
            return ValueTypes.PRICE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{BusTargets.BUS_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_totalCost_info, (Object[])new Object[]{cond.getDisplayName(), LocaleManager.get().getCurrentLocaleData().getPriceFormat().format(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BigDecimal productTotalEquivalentFare;
            BusProductPropertiesProvider propertiesProvider = (BusProductPropertiesProvider)propertySet;
            BigDecimal ruleTotalEquivalentFare = value != null ? (BigDecimal)value : BigDecimal.ZERO;
            BigDecimal bigDecimal = productTotalEquivalentFare = propertiesProvider.getTotalEquivalentFare() != null ? propertiesProvider.getTotalEquivalentFare() : BigDecimal.ZERO;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) == 0;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) != 0;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) >= 0;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) <= 0;
            }
            return true;
        }
    }
    ,
    BUS_DEPARTURE_LOCATIONS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_departStation);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{BusTargets.BUS_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departStationParameters, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicCommonTicketPropertiesProvider ps = (BasicCommonTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getDepartureLocations(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getDepartureLocations(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    BUS_ARRIVE_LOCATIONS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_destinationStation);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{BusTargets.BUS_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_destinationStationParameters, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicCommonTicketPropertiesProvider ps = (BasicCommonTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getArrivalLocations(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getArrivalLocations(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    BUS_NUMBERS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"Properties_busNumber");
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{BusTargets.BUS_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"Properties_busNumberParameters"), (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BusProductPropertiesProvider ps = (BusProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getBusNumbers(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getBusNumbers(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    BUS_BRANDS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"Properties_busBrand");
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{BusTargets.BUS_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)"Properties_busBrandParameters"), (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BusProductPropertiesProvider ps = (BusProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getBusBrands(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getBusBrands(), (Object)value, (boolean)false);
            }
            return true;
        }
    };

    private static final FastDateFormat FDF;

    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();

    static {
        FDF = FastDateFormat.getInstance((String)"yyyy.MM.dd");
    }
}

