/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.flyArystan.dict.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.gds.flyArystan.l10n.Messages;
import com.gridnine.xtrip.client.fx.gds.flyArystan.model.dict.FarePackageCodeVM;
import com.gridnine.xtrip.client.fx.gds.flyArystan.model.dict.FarePackagePanel;
import com.gridnine.xtrip.client.fx.gds.flyArystan.model.dict.FarePackagePanelController;
import com.gridnine.xtrip.client.fx.gds.flyArystan.model.dict.FarePackagePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.gds.flyArystan.dict.FarePackage;
import com.gridnine.xtrip.common.gds.flyArystan.dict.FarePackageReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class FarePackageHandler
extends BaseDictHandler<FarePackagePanel, FarePackage, FarePackagePanelVM> {
    public Class<FarePackage> getDictType() {
        return FarePackage.class;
    }

    public DictionaryReference<FarePackage> createReference(String code) {
        return new FarePackageReference(code);
    }

    protected void configureStandardListParameters(DictListParameters params) {
        TableColumnSettings groupColumn = DictHandlersHelper.createColumn(this.getDictType(), (String)FarePackage.Property.group.name(), (String)Messages.FareGroup, (Renderer)StandardRenderers.GENERIC);
        TableColumnSettings ancillaryFeeTypeColumn = DictHandlersHelper.createColumn(this.getDictType(), (String)FarePackage.Property.ancillaryFeeType.name(), (String)Messages.AncillaryFeeType, (Renderer)StandardRenderers.GENERIC);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)FarePackage.Property.title.name(), (String)Messages.Title, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(groupColumn);
        params.getColumns().add(ancillaryFeeTypeColumn);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)FarePackage.Property.openDate.name(), (String)Messages.OpenDate, (Renderer)StandardRenderers.DATE));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)FarePackage.Property.closeDate.name(), (String)Messages.CloseDate, (Renderer)StandardRenderers.DATE));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)FarePackage.Property.farePackageCodes.name(), (String)Messages.FarePackageCodes, (Renderer)StandardRenderers.GENERIC_SORTING));
        params.getFilters().add(groupColumn);
        params.getFilters().add(ancillaryFeeTypeColumn);
    }

    protected void configureController(List<BiConsumer<FarePackage, FarePackagePanelVM>> toVM, List<BiConsumer<FarePackagePanelVM, FarePackage>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getMain().setTitle(model.getTitle());
            vm.getMain().setGroup(model.getGroup());
            vm.getMain().setAncillaryFeeType(model.getAncillaryFeeType());
            vm.getMain().setOpenDate(DateUtils.asLocalDate((Date)model.getOpenDate()));
            vm.getMain().setCloseDate(DateUtils.asLocalDate((Date)model.getCloseDate()));
            model.getFarePackageCodes().forEach(code -> {
                FarePackageCodeVM item = new FarePackageCodeVM();
                item.setFarePackageCode(code);
                vm.getFarePackageCodes().getContent().add(item);
            });
        });
        fromVM.add((vm, model) -> {
            model.setTitle(vm.getMain().getTitle());
            model.setGroup(vm.getMain().getGroup());
            model.setAncillaryFeeType(vm.getMain().getAncillaryFeeType());
            model.setOpenDate(DateUtils.asDate((LocalDate)vm.getMain().getOpenDate()));
            model.setCloseDate(DateUtils.asDate((LocalDate)vm.getMain().getCloseDate()));
            model.getFarePackageCodes().clear();
            vm.getFarePackageCodes().getContent().forEach(item -> {
                if (TextUtil.nonBlank((String)item.getFarePackageCode())) {
                    model.getFarePackageCodes().add(item.getFarePackageCode());
                }
            });
        });
    }

    protected FarePackagePanelVM createVM() {
        return new FarePackagePanelVM();
    }

    protected ViewController<FarePackagePanel, FarePackagePanelVM> createController() {
        return new FarePackagePanelController(false);
    }

    public String format(FarePackage dict) {
        return TextUtil.nonBlank((String)dict.getTitle()) ? dict.getTitle().trim() : dict.getCode();
    }
}

