/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorRulePane;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.restriction.BasicRestrictionsWidget;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceField;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperationPermission;
import com.gridnine.xtrip.common.security.acl.rule.AclAction;
import com.gridnine.xtrip.common.security.acl.rule.AclFieldRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;

class AclEditorIndexRulePane
extends AclEditorRulePane {
    private TableWidgetController<TableWidget<ActionWrapper>, ActionWrapper> actionsTable;
    private BasicRestrictionsWidget restrictionsTable;
    private TableWidgetController<TableWidget<FieldWrapper>, FieldWrapper> fieldsTable;
    private final AclChangeRegistry.AclEntryData entryData;

    AclEditorIndexRulePane(AclChangeRegistry.AclEntryData entryData) {
        this.entryData = entryData;
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Pane rulePane = this.createRulePane();
        this.getChildren().setAll((Object[])new Node[]{rulePane});
    }

    private Pane createRulePane() {
        this.actionsTable = new TableWidgetController<TableWidget<ActionWrapper>, ActionWrapper>(){
            private final TableWidget<ActionWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data_to_view);
            }

            public TableWidget<ActionWrapper> getView() {
                return this.view;
            }
        };
        ((TableWidget)this.actionsTable.getView()).setItemsProvider(() -> new ActionWrapper());
        ((TableWidget)this.actionsTable.getView()).setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        ArrayList<ComboBoxWidgetColumn> actionColumns = new ArrayList<ComboBoxWidgetColumn>();
        ComboBoxWidgetColumn operationColumn = new ComboBoxWidgetColumn(action -> action.operation, (action, value) -> {
            action.operation = value;
        });
        operationColumn.setNoNulls(true);
        operationColumn.setItemsSupplier(() -> this.entryData != null ? RestrictionResourcesRegistry.get().getResourceOperations(this.entryData.getEntry().getResourceId()).stream().map(value -> RestrictionResourcesRegistry.get().getOperation(value)).filter(value -> value != null).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList()) : Collections.emptyList());
        operationColumn.setConverter((StringConverter)new StringConverter<RestrictionResourceOperation>(){

            public String toString(RestrictionResourceOperation object) {
                return object != null ? object.getName() : UiUtil.NULL_TEXT;
            }

            public RestrictionResourceOperation fromString(String string) {
                return null;
            }
        });
        operationColumn.setCaption(Messages.Operation);
        operationColumn.setId("operation");
        operationColumn.setPrefWidth(Double.valueOf(50.0));
        actionColumns.add(operationColumn);
        ComboBoxWidgetColumn permissionColumn = new ComboBoxWidgetColumn(wrapper -> wrapper.permission, (wrapper, value) -> {
            wrapper.permission = value;
        });
        permissionColumn.setNoNulls(true);
        permissionColumn.setItemsSupplier(Suppliers.createEnumSupplier(AclResourceOperationPermission.class));
        permissionColumn.setConverter((StringConverter)new StringConverter<AclResourceOperationPermission>(){

            public String toString(AclResourceOperationPermission object) {
                return object != null ? object.getName() : UiUtil.NULL_TEXT;
            }

            public AclResourceOperationPermission fromString(String string) {
                return null;
            }
        });
        permissionColumn.setCaption(Messages.Permission);
        permissionColumn.setId("permission");
        actionColumns.add(permissionColumn);
        ((TableWidget)this.actionsTable.getView()).setColumns(actionColumns);
        this.restrictionsTable = new BasicRestrictionsWidget(false);
        this.fieldsTable = new TableWidgetController<TableWidget<FieldWrapper>, FieldWrapper>(){
            private final TableWidget<FieldWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data_to_view);
            }

            public TableWidget<FieldWrapper> getView() {
                return this.view;
            }
        };
        ((TableWidget)this.fieldsTable.getView()).setItemsProvider(() -> new FieldWrapper());
        ((TableWidget)this.fieldsTable.getView()).setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        ArrayList<ComboBoxWidgetColumn> fieldColumns = new ArrayList<ComboBoxWidgetColumn>();
        ComboBoxWidgetColumn fieldColumn = new ComboBoxWidgetColumn(action -> action.field, (action, value) -> {
            action.field = value;
        });
        fieldColumn.setNoNulls(true);
        fieldColumn.setItemsSupplier(() -> this.entryData != null ? RestrictionResourcesRegistry.get().getResourceFields(this.entryData.getEntry().getResourceId()).stream().map(value -> RestrictionResourcesRegistry.get().getField(value)).filter(value -> value != null).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList()) : Collections.emptyList());
        fieldColumn.setConverter((StringConverter)new StringConverter<RestrictionResourceField>(){

            public String toString(RestrictionResourceField object) {
                return object != null ? object.getName() : UiUtil.NULL_TEXT;
            }

            public RestrictionResourceField fromString(String string) {
                return null;
            }
        });
        fieldColumn.setCaption(Messages.Field);
        fieldColumn.setId("field");
        fieldColumns.add(fieldColumn);
        ((TableWidget)this.fieldsTable.getView()).setColumns(fieldColumns);
        Card actionCard = new Card("actions", UiCardsContainer.Style.STATIC, Messages.Actions, this.actionsTable.getView());
        Card restrictionCard = new Card("rules", UiCardsContainer.Style.STATIC, Messages.Rules, (Node)this.restrictionsTable);
        Card fieldCard = new Card("forbiddenFields", UiCardsContainer.Style.STATIC, Messages.Forbidden_fields, this.fieldsTable.getView());
        CardsContainer ruleCardsPane = new CardsContainer();
        ruleCardsPane.getCards().add((Object)actionCard);
        ruleCardsPane.getCards().add((Object)restrictionCard);
        ruleCardsPane.getCards().add((Object)fieldCard);
        return ruleCardsPane;
    }

    private void createBindings() {
    }

    private void createListeners() {
    }

    private Collection<ActionWrapper> toActionWrappers(Collection<AclAction> actions) {
        ArrayList<ActionWrapper> actionWrappers = new ArrayList<ActionWrapper>();
        Map operations = this.entryData != null ? RestrictionResourcesRegistry.get().getResourceOperations(this.entryData.getEntry().getResourceId()).stream().map(value -> RestrictionResourcesRegistry.get().getOperation(value)).filter(value -> value != null).collect(Collectors.toMap(value -> value.getId(), value -> value)) : Collections.emptyMap();
        for (AclAction action : actions) {
            if (!operations.containsKey(action.getOperationId())) continue;
            ActionWrapper actionWrapper = new ActionWrapper();
            actionWrapper.operation = (RestrictionResourceOperation)operations.get(action.getOperationId());
            actionWrapper.permission = action.getPermission();
            actionWrappers.add(actionWrapper);
        }
        return actionWrappers;
    }

    private Collection<AclAction> toActions(Collection<ActionWrapper> actionWrappers) {
        ArrayList<AclAction> actions = new ArrayList<AclAction>();
        for (ActionWrapper actionWrapper : actionWrappers) {
            AclAction action = new AclAction();
            action.setOperationId(actionWrapper.operation != null ? actionWrapper.operation.getId() : null);
            action.setPermission(actionWrapper.permission);
            actions.add(action);
        }
        return actions;
    }

    private Collection<FieldWrapper> toFieldWrappers(Collection<AclFieldRestriction> fields) {
        ArrayList<FieldWrapper> fieldWrappers = new ArrayList<FieldWrapper>();
        Map fieldss = this.entryData != null ? RestrictionResourcesRegistry.get().getResourceFields(this.entryData.getEntry().getResourceId()).stream().map(value -> RestrictionResourcesRegistry.get().getField(value)).filter(value -> value != null).collect(Collectors.toMap(value -> value.getId(), value -> value)) : Collections.emptyMap();
        for (AclFieldRestriction field : fields) {
            if (!fieldss.containsKey(field.getFieldId())) continue;
            FieldWrapper fieldWrapper = new FieldWrapper();
            fieldWrapper.field = (RestrictionResourceField)fieldss.get(field.getFieldId());
            fieldWrappers.add(fieldWrapper);
        }
        return fieldWrappers;
    }

    private Collection<AclFieldRestriction> toFields(Collection<FieldWrapper> fieldWrappers) {
        ArrayList<AclFieldRestriction> fields = new ArrayList<AclFieldRestriction>();
        for (FieldWrapper fieldWrapper : fieldWrappers) {
            AclFieldRestriction field = new AclFieldRestriction();
            field.setFieldId(fieldWrapper.field != null ? fieldWrapper.field.getId() : null);
            fields.add(field);
        }
        return fields;
    }

    @Override
    public boolean isDataChanged() {
        if (this.actionsTable.isDataChanged()) {
            return true;
        }
        if (this.restrictionsTable.isDataChanged()) {
            return true;
        }
        return this.fieldsTable.isDataChanged();
    }

    @Override
    public void readData(AclRule model) {
        this.actionsTable.readData(this.toActionWrappers(model.getActions()));
        RestrictionsData restrictionsData = new RestrictionsData();
        restrictionsData.setRestrictionId(this.entryData != null ? this.entryData.getEntry().getResourceId() : null);
        restrictionsData.getRestrictions().clear();
        restrictionsData.getRestrictions().addAll(model.getRestrictionGroups());
        this.restrictionsTable.readData(restrictionsData);
        this.fieldsTable.readData(this.toFieldWrappers(model.getFieldRestrictions()));
    }

    @Override
    public void writeData(AclRule model) {
        ArrayList<ActionWrapper> actionWrappers = new ArrayList<ActionWrapper>();
        this.actionsTable.writeData(actionWrappers);
        model.getActions().clear();
        model.getActions().addAll(this.toActions(actionWrappers));
        RestrictionsData restrictionsData = new RestrictionsData();
        this.restrictionsTable.writeData(restrictionsData);
        model.getRestrictionGroups().clear();
        model.getRestrictionGroups().addAll(restrictionsData.getRestrictions());
        ArrayList<FieldWrapper> fieldWrappers = new ArrayList<FieldWrapper>();
        this.fieldsTable.writeData(fieldWrappers);
        model.getFieldRestrictions().clear();
        model.getFieldRestrictions().addAll(this.toFields(fieldWrappers));
    }

    private static class FieldWrapper {
        RestrictionResourceField field;

        private FieldWrapper() {
        }
    }

    private static class ActionWrapper {
        RestrictionResourceOperation operation;
        AclResourceOperationPermission permission;

        private ActionWrapper() {
        }
    }
}

