/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableTreeItem;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorTool;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;

public enum Tools implements AclEditorTool
{
    ADD_GROUP{

        @Override
        public String getName(AclEditorPane editor) {
            return Messages.Create_group;
        }

        @Override
        public String getDescription(AclEditorPane editor) {
            return Messages.Create_new_group;
        }

        @Override
        public boolean isEnabled(AclEditorPane editor) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            return item != null && item.getValue() instanceof AclGroup;
        }

        @Override
        public void execute(AclEditorPane editor, boolean alt) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            if (item != null && item.getValue() instanceof AclGroup) {
                editor.add(item, editor.createGroup());
            }
        }
    }
    ,
    ADD_USER{

        @Override
        public String getName(AclEditorPane editor) {
            return Messages.Create_user;
        }

        @Override
        public String getDescription(AclEditorPane editor) {
            return Messages.Create_new_user;
        }

        @Override
        public boolean isEnabled(AclEditorPane editor) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            return item != null && item.getValue() instanceof AclGroup;
        }

        @Override
        public void execute(AclEditorPane editor, boolean alt) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            if (item != null && item.getValue() instanceof AclGroup) {
                editor.add(item, editor.createUser());
            }
        }
    }
    ,
    DELETE{

        @Override
        public String getName(AclEditorPane editor) {
            return Messages.Delete;
        }

        @Override
        public String getDescription(AclEditorPane editor) {
            return Messages.Delete_selected_group_or_user;
        }

        @Override
        public boolean isEnabled(AclEditorPane editor) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            return item != null && item.isLeaf() && (item.getValue() instanceof AclGroup && !AclHelper.isSpecialGroup((AclGroup)((AclGroup)item.getValue())) || item.getValue() instanceof AclUser && !AclHelper.isSpecialUser((AclUser)((AclUser)item.getValue())));
        }

        @Override
        public void execute(AclEditorPane editor, boolean alt) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            if (item != null && item.isLeaf() && (item.getValue() instanceof AclGroup && !AclHelper.isSpecialGroup((AclGroup)((AclGroup)item.getValue())) || item.getValue() instanceof AclUser && !AclHelper.isSpecialUser((AclUser)((AclUser)item.getValue())))) {
                editor.remove(item, true);
            }
        }
    }
    ,
    REMOVE{

        @Override
        public String getName(AclEditorPane editor) {
            return Messages.Expell_from_group;
        }

        @Override
        public String getDescription(AclEditorPane editor) {
            return Messages.Expell_selected_user_from_current_group;
        }

        @Override
        public boolean isEnabled(AclEditorPane editor) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            return item != null && item.isLeaf() && item.getValue() instanceof AclUser && !AclHelper.isSpecialUser((AclUser)((AclUser)item.getValue())) && ((AclUser)item.getValue()).getGroupIds().size() > 1;
        }

        @Override
        public void execute(AclEditorPane editor, boolean alt) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            if (item != null && item.isLeaf() && item.getValue() instanceof AclUser && !AclHelper.isSpecialUser((AclUser)((AclUser)item.getValue())) && ((AclUser)item.getValue()).getGroupIds().size() > 1) {
                editor.remove(item, false);
            }
        }
    }
    ,
    RELOCATE{

        @Override
        public String getName(AclEditorPane editor) {
            return Messages.Select_groups;
        }

        @Override
        public String getDescription(AclEditorPane editor) {
            return Messages.Change_groups_belong;
        }

        @Override
        public boolean isEnabled(AclEditorPane editor) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            return item != null && (item.getValue() instanceof AclGroup && !AclHelper.isSpecialGroup((AclGroup)((AclGroup)item.getValue())) || item.getValue() instanceof AclUser && !AclHelper.isSpecialUser((AclUser)((AclUser)item.getValue())));
        }

        @Override
        public void execute(AclEditorPane editor, boolean alt) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            if (item != null && (item.getValue() instanceof AclGroup && !AclHelper.isSpecialGroup((AclGroup)((AclGroup)item.getValue())) || item.getValue() instanceof AclUser && !AclHelper.isSpecialUser((AclUser)((AclUser)item.getValue())))) {
                editor.relocate(item);
            }
        }
    }
    ,
    COPY_ENTRIES{

        @Override
        public String getName(AclEditorPane editor) {
            return Messages.Copy_entries;
        }

        @Override
        public String getDescription(AclEditorPane editor) {
            return Messages.Copy_entries_description;
        }

        @Override
        public boolean isEnabled(AclEditorPane editor) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            return item != null && editor.getRegistry().getPrincipalEntries(((AclPrincipal)item.getValue()).getId()).size() > 0;
        }

        @Override
        public void execute(AclEditorPane editor, boolean alt) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            if (item != null && editor.getRegistry().getPrincipalEntries(((AclPrincipal)item.getValue()).getId()).size() > 0) {
                editor.copyEntries(item);
            }
        }
    }
    ,
    PASTE_ENTRIES{

        @Override
        public String getName(AclEditorPane editor) {
            return Messages.Paste_entries;
        }

        @Override
        public String getDescription(AclEditorPane editor) {
            return Messages.Paste_entries_description;
        }

        @Override
        public boolean isEnabled(AclEditorPane editor) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            return item != null && Clipboard.getSystemClipboard().hasContent(DataFormat.PLAIN_TEXT);
        }

        @Override
        public void execute(AclEditorPane editor, boolean alt) {
            SortableTreeItem<AclPrincipal> item = editor.getSelectedItem();
            if (item != null && Clipboard.getSystemClipboard().hasContent(DataFormat.PLAIN_TEXT)) {
                editor.pasteEntries(item);
            }
        }
    };


    @Override
    public double getWeight() {
        return this.ordinal();
    }
}

