/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.assets.navtool;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.assets.AssetHandler;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import javafx.scene.control.SelectionMode;

public class AclUsersListActivityHandler
extends ActivityHandler<AssetsListPane, Void> {
    public static final String TOKEN = "users-browser";
    public static final String TITLE = Messages.Users;
    public static final String DESCRIPTION = Messages.Users;
    private static String ID = "acl-users-list-activity-handler";

    public static AclUsersListActivityHandler get() {
        return (AclUsersListActivityHandler)AclUsersListActivityHandler.forId((String)ID);
    }

    public static void register(ClientRegistry registry) {
        if (!registry.allOf(TYPE).containsKey(ID)) {
            registry.register((RegistryItem)new AclUsersListActivityHandler());
        }
    }

    private AclUsersListActivityHandler() {
    }

    public String getId() {
        return ID;
    }

    protected AssetsListPane createView(ActivityState<AssetsListPane, Void> state) {
        AssetHandler handler = AssetHandler.forAssetClass(AclUser.class);
        AssetsListPane pane = new AssetsListPane(state.getMutex(), handler.getAssetType(), handler.getStandardListParameters(), SelectionMode.MULTIPLE, true);
        EventBus.get().subscribe(AssetModificationEvent.TYPE, pane.getModificationEventHandler());
        return pane;
    }

    protected void onClosed(ActivityState<AssetsListPane, Void> state) {
        AssetsListPane pane = (AssetsListPane)this.getView(state);
        if (pane == null) {
            return;
        }
        EventBus.get().unsubscribe((Object)pane.getModificationEventHandler());
    }

    protected void saveChanges(ActivityState<AssetsListPane, Void> state) {
    }

    protected Serializer<Void> getSerializer() {
        return Serializer.VOID;
    }
}

