/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.util.Arrays;
import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class BalanceEditorManagerHeaderPane
extends GridPane
implements DevTool {
    private final Label caption;
    private final EntityBoxWidget<Organization> organizationWidget;
    private final ComboBoxWidget<EntityReference<ChartOfAccountsElement>> accountWidget;
    private final Label emptyAccountCaption;
    private boolean valueIsChanging = false;

    public BalanceEditorManagerHeaderPane() {
        this.getStyleClass().add((Object)"editor-header-pane");
        this.caption = new Label(Messages.Balance_editor_manager_pane_label);
        this.organizationWidget = new EntityBoxWidget(Organization.class, false);
        this.organizationWidget.setListParametersSupplier(ControllerInterceptorsHelper::getOrganizations);
        this.organizationWidget.setFieldName(Messages.Balance_editor_manager_pane_organization);
        this.organizationWidget.setPrefWidth(250.0);
        this.accountWidget = new ComboBoxWidget(false);
        this.accountWidget.setMinWidth(410.0);
        this.accountWidget.setNoNulls(true);
        this.accountWidget.setLive(true);
        this.emptyAccountCaption = new Label();
        this.accountWidget.setSortItems(false);
        this.accountWidget.valueProperty().addListener((s, o, n) -> {
            if (!this.valueIsChanging) {
                this.valueIsChanging = true;
                if (n != null) {
                    this.emptyAccountCaption.setText(null);
                }
                this.reflow();
                this.valueIsChanging = false;
            }
        });
        this.emptyAccountCaption.textProperty().addListener((s, o, n) -> {
            if (!this.valueIsChanging) {
                this.valueIsChanging = true;
                if (n != null) {
                    this.accountWidget.setValue(null);
                }
                this.reflow();
                this.valueIsChanging = false;
            }
        });
        this.reflow();
    }

    public EntityBoxWidget<Organization> getOrganizationWidget() {
        return this.organizationWidget;
    }

    public ComboBoxWidget<EntityReference<ChartOfAccountsElement>> getAccountWidget() {
        return this.accountWidget;
    }

    public Label getEmptyAccountCaption() {
        return this.emptyAccountCaption;
    }

    private void reflow() {
        this.getChildren().removeAll((Object[])new Node[]{this.caption, this.organizationWidget, this.accountWidget, this.emptyAccountCaption});
        this.addRow(0, this.getNodes());
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Arrays.asList(BalanceEditorManagerHeaderPane.this.getNodes());
            }

            public String getInfo() {
                return ((Object)((Object)BalanceEditorManagerHeaderPane.this)).getClass().getSimpleName();
            }
        };
    }

    private Node[] getNodes() {
        if (this.accountWidget.getValue() != null) {
            return new Node[]{this.caption, this.organizationWidget, this.accountWidget};
        }
        return new Node[]{this.caption, this.organizationWidget, this.emptyAccountCaption};
    }
}

