/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class CardExpirationDateWidget
extends CustomWidget<ValueHolder<LocalDate>>
implements DevTool {
    private LocalDate value;
    private LocalDate readValue;
    private Label label;
    private ComboBoxWidget<Integer> monthWidget;
    private ComboBoxWidget<Integer> yearWidget;
    private final ViewState viewState = new ViewState();
    private boolean internalChange;

    public CardExpirationDateWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"card-exp-date-widget"});
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void setFieldName(String val) {
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void readData(ValueHolder<LocalDate> model) {
        this.readValue = this.value = (LocalDate)model.get();
        this.updateState();
    }

    public void writeData(ValueHolder<LocalDate> model) {
        model.set((Object)this.value);
    }

    public boolean isDataChanged() {
        return !MiscUtil.equals((Object)this.value, (Object)this.readValue);
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.monthWidget = null;
            this.yearWidget = null;
            if (this.label == null) {
                this.label = new CustomLabel();
                this.label.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.label});
            }
            if (this.value == null) {
                this.label.setText("\u2014");
            } else {
                this.label.setText(this.value.format(DateTimeFormatter.ofPattern("LLLL yyyy", LocaleManager.get().getCurrentLocale())));
            }
        } else {
            this.label = null;
            if (this.monthWidget == null || this.yearWidget == null) {
                ChangeListener changeListener = (s, o, n) -> {
                    if (this.internalChange || this.monthWidget == null || this.yearWidget == null) {
                        return;
                    }
                    this.value = this.monthWidget.getValue() == null || this.yearWidget.getValue() == null ? null : LocalDate.of((int)((Integer)this.yearWidget.getValue()), (Integer)this.monthWidget.getValue(), 3);
                };
                this.monthWidget = new ComboBoxWidget(false);
                this.monthWidget.getStyleClass().add((Object)"month");
                this.monthWidget.setSortItems(false);
                this.monthWidget.setItemsSupplier(() -> IntStream.rangeClosed(1, 12).boxed().collect(Collectors.toList()));
                this.monthWidget.setConverter((StringConverter)new StringConverter<Integer>(){
                    private final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("LLLL", LocaleManager.get().getCurrentLocale());

                    public String toString(Integer object) {
                        return object == null ? null : this.fmt.format(Month.of(object));
                    }

                    public Integer fromString(String string) {
                        return null;
                    }
                });
                this.monthWidget.valueProperty().addListener(changeListener);
                HBox.setHgrow(this.monthWidget, (Priority)Priority.ALWAYS);
                this.yearWidget = new ComboBoxWidget(false);
                this.yearWidget.getStyleClass().add((Object)"year");
                this.yearWidget.setSortItems(false);
                this.yearWidget.setItemsSupplier(() -> {
                    int year = LocalDate.now().getYear();
                    return IntStream.rangeClosed(year - 5, year + 10).boxed().collect(Collectors.toList());
                });
                this.yearWidget.valueProperty().addListener(changeListener);
                this.getChildren().setAll((Object[])new Node[]{new HBox(new Node[]{this.monthWidget, this.yearWidget})});
            }
            this.internalChange = true;
            if (this.value == null) {
                this.monthWidget.setValue(null);
                this.yearWidget.setValue(null);
            } else {
                this.monthWidget.setValue((Object)this.value.getMonthValue());
                this.yearWidget.setValue((Object)this.value.getYear());
            }
            this.internalChange = false;
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                if (CardExpirationDateWidget.this.monthWidget != null && CardExpirationDateWidget.this.yearWidget != null) {
                    return Arrays.asList(CardExpirationDateWidget.this.monthWidget, CardExpirationDateWidget.this.yearWidget);
                }
                return Collections.emptyList();
            }

            public String getInfo() {
                return ((Object)((Object)CardExpirationDateWidget.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)CardExpirationDateWidget.this.viewState);
            }
        };
    }
}

