/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.RateMoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionItemVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionsEntryVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionsWidgetVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AirProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionPropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountPropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeePropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeePropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class CommissionsWidget
extends CustomWidget<CommissionsWidgetVM> {
    private static final ProductSettings FAKE_SETTINGS = new ProductSettings(){

        @Override
        public ProductType getProductType() {
            return null;
        }

        @Override
        public Set<ContractType> getHiddenContractTypes() {
            return Collections.emptySet();
        }
    };
    private boolean isDelivery = false;
    static final Supplier<List<SegmentTariff>> FAKE_SUPPLIER = () -> Collections.emptyList();
    private PlaceholderPane placeholderPane;
    private GridPane gridPane;
    Supplier<List<SegmentTariff>> segmentNumbersSupplier = FAKE_SUPPLIER;
    private final ViewState viewState = new ViewState();
    private boolean includeSegments = false;
    private final List<CommissionsEntry> entries = new ArrayList<CommissionsEntry>();
    boolean dataChanged;
    Supplier<ProductSettings> productSettingsSupplier = () -> FAKE_SETTINGS;

    private static int getWeight(ContractType contractType) {
        if (contractType == null) {
            return Integer.MIN_VALUE;
        }
        switch (contractType) {
            case VENDOR: {
                return 1;
            }
            case SUBAGENCY: {
                return 2;
            }
            case CLIENT: {
                return 3;
            }
        }
        return Integer.MAX_VALUE;
    }

    public CommissionsWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"commissions-widget", "table-widget"});
        this.reflow();
        this.viewState.stateProperty().addListener((s, o, n) -> this.reflow());
    }

    public void setSegmentNumbersSupplier(Supplier<List<SegmentTariff>> value) {
        this.segmentNumbersSupplier = value;
        for (CommissionsEntry entry : this.entries) {
            for (CommissionItem commissionItem : entry.commissionItems) {
                commissionItem.segmentNumberWidget.setItemsSupplier(this.segmentNumbersSupplier == null ? FAKE_SUPPLIER : this.segmentNumbersSupplier);
            }
            for (FeeItem feeItem : entry.feeItems) {
                feeItem.segmentNumberWidget.setItemsSupplier(this.segmentNumbersSupplier == null ? FAKE_SUPPLIER : this.segmentNumbersSupplier);
            }
        }
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.reflow();
            }
        });
    }

    public void setProductSettingsSupplier(Supplier<ProductSettings> value) {
        this.productSettingsSupplier = Objects.requireNonNull(value);
    }

    public void setFieldName(String value) {
    }

    public void readData(CommissionsWidgetVM model) {
        this.entries.clear();
        for (CommissionsEntryVM entryVM : model.getEntries()) {
            CommissionsEntry entry2 = new CommissionsEntry();
            entry2.readData(entryVM);
            this.entries.add(entry2);
        }
        Set existingTypes = this.entries.stream().map(entry -> entry.getContractType()).distinct().collect(Collectors.toSet());
        for (ContractType contractType : ContractType.values()) {
            if (existingTypes.contains(contractType)) continue;
            CommissionsEntry entry3 = new CommissionsEntry();
            CommissionsEntryVM entryVM = new CommissionsEntryVM();
            entryVM.setContractType(contractType);
            entryVM.setCommissionsCaption(Messages.Commission + ' ' + contractType);
            entryVM.setFeesCaption(Messages.Fees + ' ' + contractType);
            entry3.readData(entryVM);
            this.entries.add(entry3);
        }
        this.dataChanged = false;
        this.reflow();
    }

    public void writeData(CommissionsWidgetVM model) {
        model.getEntries().clear();
        for (CommissionsEntry entry : this.entries) {
            CommissionsEntryVM entryVM = new CommissionsEntryVM();
            entry.writeData(entryVM);
            model.getEntries().add(entryVM);
        }
        this.dataChanged = false;
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public boolean isDataChanged() {
        if (this.viewState.isImmutable()) {
            return false;
        }
        if (this.dataChanged) {
            return true;
        }
        for (CommissionsEntry entry : this.entries) {
            if (!entry.isDataChanged()) continue;
            return true;
        }
        return false;
    }

    public void setIncludeSegments(boolean value) {
        this.includeSegments = value;
        this.reflow();
    }

    public void setIsDelivery(boolean value) {
        this.isDelivery = value;
        this.reflow();
    }

    private void reflow() {
        if (this.getScene() == null) {
            return;
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        if (this.entries.isEmpty()) {
            this.gridPane = null;
            if (this.placeholderPane == null) {
                this.placeholderPane = new PlaceholderPane();
                this.placeholderPane.setPlaceholder(new Label(Messages.Commission_and_fees));
            }
            this.getChildren().setAll((Object[])new Node[]{this.placeholderPane});
            return;
        }
        boolean withControls = !this.viewState.isImmutable();
        ArrayList<Object> nodes = new ArrayList<Object>();
        int rowIdx = 0;
        ArrayList<ColumnConstraints> columnConstraints = new ArrayList<ColumnConstraints>(13);
        int colIdx = 0;
        for (int i = 0; i < 2; ++i) {
            Node node;
            ColumnConstraints cc;
            if (i == 1) {
                cc = new ColumnConstraints();
                cc.setHgrow(Priority.NEVER);
                columnConstraints.add(cc);
                node = this.createHeaderCell(" ", colIdx++);
                node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, true);
                nodes.add(node);
            }
            if (this.includeSegments) {
                cc = new ColumnConstraints();
                cc.setHgrow(Priority.NEVER);
                columnConstraints.add(cc);
                node = this.createHeaderCell(Messages.Segment, colIdx++);
                node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, true);
                node.pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, i == 0);
                nodes.add(node);
            }
            cc = new ColumnConstraints();
            cc.setMaxWidth(Double.MAX_VALUE);
            cc.setHgrow(Priority.ALWAYS);
            columnConstraints.add(cc);
            node = this.createHeaderCell(Messages.Name, colIdx++);
            node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, true);
            node.pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, i == 0);
            nodes.add(node);
            cc = new ColumnConstraints();
            cc.setHgrow(Priority.NEVER);
            columnConstraints.add(cc);
            node = this.createHeaderCell(Messages.Rate, colIdx++);
            node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, true);
            nodes.add(node);
            cc = new ColumnConstraints();
            cc.setHgrow(Priority.NEVER);
            columnConstraints.add(cc);
            node = this.createHeaderCell(Messages.Amount, colIdx++);
            node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, true);
            nodes.add(node);
            if (!withControls) continue;
            cc = new ColumnConstraints();
            cc.setHgrow(Priority.NEVER);
            columnConstraints.add(cc);
            node = this.createHeaderCell(null, colIdx++);
            node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, true);
            nodes.add(node);
        }
        ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
        ++rowIdx;
        Set<ContractType> hiddenContractTypes = this.productSettingsSupplier.get().getHiddenContractTypes();
        Predicate<CommissionsEntry> entriesFilter = entry -> !hiddenContractTypes.contains(entry.getContractType());
        int rowsCount = this.entries.stream().filter(entriesFilter).mapToInt(entry -> Math.max(Math.max(entry.commissionItems.size(), entry.feeItems.size()), 1) + 1).sum();
        for (CommissionsEntry entry2 : this.entries.stream().filter(entriesFilter).sorted((lhs, rhs) -> Integer.compare(CommissionsWidget.getWeight(lhs.getContractType()), CommissionsWidget.getWeight(rhs.getContractType()))).collect(Collectors.toList())) {
            int colSpan = this.includeSegments ? 4 : 3;
            int colIdx2 = 0;
            nodes.add(this.createSummaryCell((Node)entry2.commissionsCaptionLabel, colIdx2++, rowIdx, colSpan - 1));
            ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, true);
            colIdx2 += colSpan - 2;
            nodes.add(this.createSummaryCell((Node)entry2.commissionsSumWidget, colIdx2++, rowIdx, 1));
            if (withControls) {
                nodes.add(this.createStubCell(colIdx2++, rowIdx));
            }
            nodes.add(this.createStubCell(colIdx2++, rowIdx));
            ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, true);
            nodes.add(this.createSummaryCell((Node)entry2.feesCaptionLabel, colIdx2++, rowIdx, colSpan - 1));
            colIdx2 += colSpan - 2;
            nodes.add(this.createSummaryCell((Node)entry2.feesSumWidget, colIdx2++, rowIdx, 1));
            if (withControls) {
                nodes.add(this.createStubCell(colIdx2++, rowIdx));
            }
            ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
            ++rowIdx;
            entry2.setReadonly(!withControls);
            int maxItems = Math.max(Math.max(entry2.commissionItems.size(), entry2.feeItems.size()), 1);
            for (int i = 0; i < maxItems; ++i) {
                BaseItem item;
                boolean lastRow;
                colIdx2 = 0;
                boolean bl = lastRow = rowIdx == rowsCount;
                if (i < entry2.commissionItems.size()) {
                    item = entry2.commissionItems.get(i);
                    if (this.includeSegments) {
                        nodes.add(this.createRowCell((Node)item.segmentNumberWidget, colIdx2++, rowIdx));
                        ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                        ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, true);
                    }
                    nodes.add(this.createRowCell((Node)item.propertiesWidget, colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    if (!this.includeSegments) {
                        ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, true);
                    }
                    nodes.add(this.createRowCell((Node)item.valueWidget, colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    nodes.add(this.createRowCell((Node)item.sumWidget, colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    if (withControls) {
                        if (this.isDelivery) {
                            nodes.add(this.createControlsPane(colIdx2++, rowIdx, new Node[0]));
                        } else {
                            nodes.add(this.createControlsPane(colIdx2++, rowIdx, new Node[]{ControlsPane.createButton((ControlsPane.ButtonType)ControlsPane.ButtonType.REMOVE, arg_0 -> this.lambda$reflow$8(entry2, (CommissionItem)item, arg_0)), ControlsPane.createButton((ControlsPane.ButtonType)ControlsPane.ButtonType.ADD, arg_0 -> this.lambda$reflow$9(entry2, (CommissionItem)item, arg_0))}));
                        }
                        ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    }
                    nodes.add(this.createStubCell(colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, true);
                } else if (i == 0) {
                    nodes.add(this.createPlaceholder(colIdx2, rowIdx, colSpan));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, true);
                    colIdx2 += colSpan;
                    if (withControls) {
                        if (this.isDelivery) {
                            nodes.add(this.createControlsPane(colIdx2++, rowIdx, new Node[0]));
                        } else {
                            nodes.add(this.createControlsPane(colIdx2++, rowIdx, new Node[]{ControlsPane.createButton((ControlsPane.ButtonType)ControlsPane.ButtonType.ADD, evt -> {
                                entry.commissionItems.add(new CommissionItem(entry2));
                                this.dataChanged = true;
                                this.reflow();
                            })}));
                        }
                        ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    }
                    nodes.add(this.createStubCell(colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, true);
                } else {
                    nodes.add(this.createStubCell(colIdx2, rowIdx));
                    GridPane.setColumnSpan((Node)((Node)nodes.get(nodes.size() - 1)), (Integer)(withControls ? colSpan + 1 : colSpan));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, true);
                    colIdx2 += withControls ? colSpan + 1 : colSpan;
                    nodes.add(this.createStubCell(colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, true);
                }
                if (i < entry2.feeItems.size()) {
                    item = entry2.feeItems.get(i);
                    if (this.includeSegments) {
                        nodes.add(this.createRowCell((Node)((FeeItem)item).segmentNumberWidget, colIdx2++, rowIdx));
                        ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    }
                    nodes.add(this.createRowCell((Node)((FeeItem)item).propertiesWidget, colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    nodes.add(this.createRowCell((Node)((FeeItem)item).valueWidget, colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    nodes.add(this.createRowCell((Node)((FeeItem)item).sumWidget, colIdx2++, rowIdx));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    if (withControls) {
                        if (this.isDelivery && !entry2.feesCaptionLabel.getText().equals(Messages.Fees + ' ' + ContractType.CLIENT)) {
                            nodes.add(this.createControlsPane(colIdx2++, rowIdx, new Node[0]));
                        } else {
                            nodes.add(this.createControlsPane(colIdx2++, rowIdx, new Node[]{ControlsPane.createButton((ControlsPane.ButtonType)ControlsPane.ButtonType.REMOVE, arg_0 -> this.lambda$reflow$11(entry2, (FeeItem)item, arg_0)), ControlsPane.createButton((ControlsPane.ButtonType)ControlsPane.ButtonType.ADD, arg_0 -> this.lambda$reflow$12(entry2, (FeeItem)item, arg_0))}));
                        }
                        ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    }
                } else if (i == 0) {
                    nodes.add(this.createPlaceholder(colIdx2, rowIdx, colSpan));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                    colIdx2 += colSpan;
                    if (withControls) {
                        if (this.isDelivery && !entry2.feesCaptionLabel.getText().equals(Messages.Fees + ' ' + ContractType.CLIENT)) {
                            nodes.add(this.createControlsPane(colIdx2++, rowIdx, new Node[0]));
                        } else {
                            nodes.add(this.createControlsPane(colIdx2++, rowIdx, new Node[]{ControlsPane.createButton((ControlsPane.ButtonType)ControlsPane.ButtonType.ADD, evt -> {
                                entry.feeItems.add(new FeeItem(entry2));
                                this.dataChanged = true;
                                this.reflow();
                            })}));
                            ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                        }
                    }
                } else {
                    nodes.add(this.createStubCell(colIdx2, rowIdx));
                    GridPane.setColumnSpan((Node)((Node)nodes.get(nodes.size() - 1)), (Integer)(withControls ? colSpan + 1 : colSpan));
                    ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
                }
                ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
                ++rowIdx;
            }
        }
        this.placeholderPane = null;
        if (this.gridPane == null) {
            this.gridPane = new GridPane();
            this.gridPane.getStyleClass().add((Object)"grid-frame");
        }
        this.gridPane.getColumnConstraints().setAll(columnConstraints);
        this.gridPane.getChildren().setAll(nodes);
        this.getChildren().setAll((Object[])new Node[]{this.gridPane});
    }

    private Node createHeaderCell(String text, int col) {
        StackPane result = new StackPane(new Node[]{new CustomLabel(text)});
        result.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
        GridPane.setConstraints((Node)result, (int)col, (int)0);
        return result;
    }

    private Node createSummaryCell(Node widget, int col, int row, int colSpan) {
        Styles.addStyle((Styleable)widget, (String)"row-cell");
        Styles.addStyle((Styleable)widget, (String)"summary-cell");
        Styles.addStyle((Styleable)widget, (String)"grid-cell");
        GridPane.setConstraints((Node)widget, (int)col, (int)row, (int)colSpan, (int)1);
        return widget;
    }

    private Node createRowCell(Node widget, int col, int row) {
        Styles.addStyle((Styleable)widget, (String)"row-cell");
        Styles.addStyle((Styleable)widget, (String)"grid-cell");
        GridPane.setConstraints((Node)widget, (int)col, (int)row);
        return widget;
    }

    private Node createStubCell(int col, int row) {
        Region result = new Region();
        result.setMaxWidth(Double.MAX_VALUE);
        result.setMaxHeight(Double.MAX_VALUE);
        result.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
        GridPane.setConstraints((Node)result, (int)col, (int)row);
        return result;
    }

    private ControlsPane createControlsPane(int col, int row, Node ... widgets) {
        ControlsPane result = new ControlsPane();
        result.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
        result.getChildren().addAll((Object[])widgets);
        GridPane.setConstraints((Node)result, (int)col, (int)row);
        return result;
    }

    private Node createPlaceholder(int col, int row, int colSpan) {
        PlaceholderPane pp = new PlaceholderPane();
        pp.setPlaceholder((Label)new CustomLabel(Messages.No_data));
        StackPane result = new StackPane(new Node[]{pp});
        result.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
        GridPane.setConstraints((Node)result, (int)col, (int)row);
        if (colSpan > 1) {
            GridPane.setColumnSpan((Node)result, (Integer)colSpan);
        }
        return result;
    }

    private /* synthetic */ void lambda$reflow$12(CommissionsEntry entry, FeeItem item, MouseEvent evt) {
        entry.feeItems.add(entry.feeItems.indexOf(item) + 1, new FeeItem(entry));
        this.dataChanged = true;
        this.reflow();
    }

    private /* synthetic */ void lambda$reflow$11(CommissionsEntry entry, FeeItem item, MouseEvent evt) {
        entry.feeItems.remove(item);
        entry.recalc();
        this.dataChanged = true;
        this.reflow();
    }

    private /* synthetic */ void lambda$reflow$9(CommissionsEntry entry, CommissionItem item, MouseEvent evt) {
        entry.commissionItems.add(entry.commissionItems.indexOf(item) + 1, new CommissionItem(entry));
        this.dataChanged = true;
        this.reflow();
    }

    private /* synthetic */ void lambda$reflow$8(CommissionsEntry entry, CommissionItem item, MouseEvent evt) {
        entry.commissionItems.remove(item);
        entry.recalc();
        this.dataChanged = true;
        this.reflow();
    }

    private abstract class BaseItem<P extends BaseCommissionProperties> {
        private final CommissionsEntry entry;
        final ComboBoxWidget<SegmentTariff> segmentNumberWidget;
        final EntityBoxWidget<P> propertiesWidget;
        final RateMoneyValueWidget valueWidget;
        final MoneyValueWidget sumWidget;
        private CommissionItemVM data;
        private boolean reading;

        BaseItem(CommissionsEntry entry, Class<P> propertiesClass) {
            this.entry = entry;
            this.segmentNumberWidget = new ComboBoxWidget(CommissionsWidget.this.viewState.isImmutable());
            this.segmentNumberWidget.setMinWidth(Double.NEGATIVE_INFINITY);
            this.segmentNumberWidget.setMaxWidth(Double.NEGATIVE_INFINITY);
            this.segmentNumberWidget.setConverter((StringConverter)new StringConverter<SegmentTariff>(){

                public String toString(SegmentTariff st) {
                    return AirProductFXHelper.getSegmentsDataDescription(st);
                }

                public SegmentTariff fromString(String string) {
                    return null;
                }
            });
            this.segmentNumberWidget.setItemsSupplier(CommissionsWidget.this.segmentNumbersSupplier == null ? FAKE_SUPPLIER : CommissionsWidget.this.segmentNumbersSupplier);
            this.propertiesWidget = new EntityBoxWidget(propertiesClass, CommissionsWidget.this.viewState.isImmutable());
            this.propertiesWidget.setFieldName(Messages.Name);
            this.valueWidget = new RateMoneyValueWidget(CommissionsWidget.this.viewState.isImmutable());
            this.sumWidget = new MoneyValueWidget(CommissionsWidget.this.viewState.isImmutable());
            this.sumWidget.setFixedCurrency(true);
            this.valueWidget.valueProperty().addListener((src, o, n) -> {
                EntityReference property = this.propertiesWidget.getValue();
                if (this.reading || n == null || n.getMoney() == null || property == null || property.getType().isAssignableFrom(DiscountProperties.class)) {
                    return;
                }
                this.sumWidget.setValue(n.getMoney());
            });
            this.sumWidget.valueProperty().addListener((src, o, n) -> {
                if (this.reading) {
                    return;
                }
                EntityReference property = this.propertiesWidget.getValue();
                if (n == null && !property.getType().isAssignableFrom(DiscountProperties.class)) {
                    this.valueWidget.setValue(null);
                } else if (n != null && (this.valueWidget.getValue() == null || this.valueWidget.getValue().getRate() == null)) {
                    Money money;
                    Money money2 = money = this.valueWidget.getValue() == null ? null : this.valueWidget.getValue().getMoney();
                    if (money == null) {
                        money = new Money();
                    }
                    if (!MiscUtil.equals((Object)money.getValue(), (Object)n.getValue())) {
                        money.setValue(n.getValue());
                        RateMoney rm = new RateMoney();
                        rm.setMoney(money);
                        this.valueWidget.setValue(rm);
                    }
                }
                entry.recalc();
            });
        }

        void readData(CommissionItemVM model) {
            this.reading = true;
            this.data = model;
            this.segmentNumberWidget.setValue((Object)model.getSegmentTariff());
            this.propertiesWidget.setValue(model.getCommissionProperties());
            boolean fake = model.getUid() != null && model.getUid().startsWith("fake");
            this.propertiesWidget.setInactive(fake);
            this.propertiesWidget.getViewState().setNotEditable(fake);
            RateMoney rm = model.getValue();
            this.valueWidget.setValue(rm);
            this.sumWidget.setValue(model.getSum());
            this.entry.recalc();
            this.reading = false;
        }

        void writeData(CommissionItemVM model) {
            model.setUid(this.data == null ? null : this.data.getUid());
            model.setSegmentTariff((SegmentTariff)this.segmentNumberWidget.getValue());
            model.setCommissionProperties(this.propertiesWidget.getValue());
            model.setValue(this.valueWidget.getValue());
            model.setSum(this.sumWidget.getValue());
            this.data = model;
        }

        void setReadonly(boolean value) {
            this.segmentNumberWidget.getViewState().setReadonly(value);
            this.propertiesWidget.getViewState().setReadonly(value);
            this.valueWidget.getViewState().setReadonly(value);
            this.sumWidget.getViewState().setReadonly(value);
        }

        boolean isDataChanged() {
            if (!MiscUtil.equals((Object)(this.data == null ? null : this.data.getSegmentTariff()), (Object)this.segmentNumberWidget.getValue())) {
                return true;
            }
            if (!MiscUtil.equals((Object)(this.data == null ? null : this.data.getCommissionProperties()), (Object)this.propertiesWidget.getValue())) {
                return true;
            }
            if (!MoneyHelper.isSame((RateMoney)(this.data == null ? null : this.data.getValue()), (RateMoney)this.valueWidget.getValue())) {
                return true;
            }
            return !MiscUtil.equals((Object)(this.data == null ? null : this.data.getSum()), (Object)this.sumWidget.getValue());
        }
    }

    private class FeeItem
    extends BaseItem<FeeProperties> {
        FeeItem(CommissionsEntry entry) {
            super(entry, FeeProperties.class);
            this.propertiesWidget.setListParametersSupplier(new MultiSupplier<IndexListParameters<FeeProperties, ?>>(){
                IndexListParameters<FeeProperties, FeePropertiesIndex> comPropIndex;
                Supplier<IndexListParameters<?, ?>[]> parameters = new Supplier(){

                    public IndexListParameters<?, ?>[] get() {
                        comPropIndex = EntityIndexHandler.forIndexClass(FeePropertiesIndex.class).createListParameters();
                        ProductType productType = CommissionsWidget.this.productSettingsSupplier.get().getProductType();
                        if (productType != null) {
                            comPropIndex.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)FeePropertiesIndex.Property.productTypes.name(), (Object)productType), SearchCriterion.isEmpty((String)FeePropertiesIndex.Property.productTypes.name())}));
                        }
                        IndexListParameters[] listParameters = new IndexListParameters[]{comPropIndex, EntityIndexHandler.forIndexClass(PaymentFeePropertiesIndex.class).createListParameters()};
                        return listParameters;
                    }
                };

                public String getDisplayName(int idx) {
                    return MetaRegistryHelper.getDisplayName((Class)this.parameters.get()[idx].getIndexType());
                }

                public IndexListParameters<FeeProperties, ?> get(int idx) {
                    return this.parameters.get()[idx];
                }

                public int count() {
                    return this.parameters.get().length;
                }
            });
        }
    }

    private class CommissionItem
    extends BaseItem<BaseCommissionProperties> {
        <T extends BaseCommissionProperties> CommissionItem(CommissionsEntry entry) {
            super(entry, BaseCommissionProperties.class);
            this.propertiesWidget.setListParametersSupplier(new MultiSupplier<IndexListParameters<BaseCommissionProperties, ?>>(){
                IndexListParameters<CommissionProperties, CommissionPropertiesIndex> comPropIndex;
                Supplier<IndexListParameters<?, ?>[]> parameters = new Supplier(){

                    public IndexListParameters<?, ?>[] get() {
                        comPropIndex = EntityIndexHandler.forIndexClass(CommissionPropertiesIndex.class).createListParameters();
                        ProductType productType = CommissionsWidget.this.productSettingsSupplier.get().getProductType();
                        if (productType != null) {
                            comPropIndex.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)FeePropertiesIndex.Property.productTypes.name(), (Object)productType), SearchCriterion.isEmpty((String)FeePropertiesIndex.Property.productTypes.name())}));
                        }
                        IndexListParameters[] listParameters = new IndexListParameters[]{comPropIndex, EntityIndexHandler.forIndexClass(DiscountPropertiesIndex.class).createListParameters()};
                        return listParameters;
                    }
                };

                public String getDisplayName(int idx) {
                    return MetaRegistryHelper.getDisplayName((Class)this.parameters.get()[idx].getIndexType());
                }

                public IndexListParameters<BaseCommissionProperties, ?> get(int idx) {
                    return this.parameters.get()[idx];
                }

                public int count() {
                    return this.parameters.get().length;
                }
            });
        }
    }

    private class CommissionsEntry {
        final Label commissionsCaptionLabel = new CustomLabel();
        final MoneyValueWidget commissionsSumWidget = new MoneyValueWidget(true);
        final List<CommissionItem> commissionItems = new ArrayList<CommissionItem>();
        final Label feesCaptionLabel = new CustomLabel();
        final MoneyValueWidget feesSumWidget = new MoneyValueWidget(true);
        final List<FeeItem> feeItems = new ArrayList<FeeItem>();
        private ContractType contractType;
        private String uid;

        CommissionsEntry() {
        }

        ContractType getContractType() {
            return this.contractType;
        }

        void recalc() {
            this.commissionsSumWidget.setValue(this.calcSum(this.commissionItems));
            this.feesSumWidget.setValue(this.calcSum(this.feeItems));
        }

        private Money calcSum(List<? extends BaseItem<?>> items) {
            String currency = null;
            BigDecimal sum = BigDecimal.ZERO;
            for (BaseItem<?> item : items) {
                Money value = item.sumWidget.getValue();
                if (value == null || value.getValue() == null || value.getCurrency() == null) continue;
                if (currency == null) {
                    currency = value.getCurrency();
                } else if (!currency.equals(value.getCurrency())) {
                    return null;
                }
                sum = sum.add(value.getValue());
            }
            return currency == null ? null : MoneyHelper.buildMoney((BigDecimal)sum, currency);
        }

        void readData(CommissionsEntryVM model) {
            BaseItem item;
            this.uid = model.getUid();
            this.contractType = model.getContractType();
            this.commissionsCaptionLabel.setText(model.getCommissionsCaption());
            this.feesCaptionLabel.setText(model.getFeesCaption());
            this.commissionItems.clear();
            for (CommissionItemVM itemVM : model.getCommissions()) {
                item = new CommissionItem(this);
                item.readData(itemVM);
                this.commissionItems.add((CommissionItem)item);
            }
            this.feeItems.clear();
            for (CommissionItemVM itemVM : model.getFees()) {
                item = new FeeItem(this);
                item.readData(itemVM);
                this.feeItems.add((FeeItem)item);
            }
            this.recalc();
        }

        void writeData(CommissionsEntryVM model) {
            CommissionItemVM itemVM;
            model.setUid(this.uid);
            model.setContractType(this.contractType);
            model.getCommissions().clear();
            for (CommissionItem commissionItem : this.commissionItems) {
                itemVM = new CommissionItemVM();
                commissionItem.writeData(itemVM);
                model.getCommissions().add(itemVM);
            }
            model.getFees().clear();
            for (FeeItem feeItem : this.feeItems) {
                itemVM = new CommissionItemVM();
                feeItem.writeData(itemVM);
                model.getFees().add(itemVM);
            }
        }

        void setReadonly(boolean value) {
            for (CommissionItem commissionItem : this.commissionItems) {
                commissionItem.setReadonly(value);
            }
            for (FeeItem feeItem : this.feeItems) {
                feeItem.setReadonly(value);
            }
        }

        boolean isDataChanged() {
            for (CommissionItem commissionItem : this.commissionItems) {
                if (!commissionItem.isDataChanged()) continue;
                return true;
            }
            for (FeeItem feeItem : this.feeItems) {
                if (!feeItem.isDataChanged()) continue;
                return true;
            }
            return false;
        }
    }

    public static interface ProductSettings {
        public ProductType getProductType();

        public Set<ContractType> getHiddenContractTypes();
    }
}

