/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.booking.ProductPeriodType;
import com.gridnine.xtrip.common.model.system.ProductPeriodData;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class ProductPeriodDataWidget
extends CustomWidget<ProductPeriodData>
implements DevTool {
    private ProductPeriodType originalProductPeriodType;
    private boolean originalUseAsShipmentPeriod;
    private final ObjectProperty<ProductPeriodType> productPeriodType = new SimpleObjectProperty();
    private final ObjectProperty<Boolean> useAsShipmentPeriod = new SimpleObjectProperty();
    private Label label;
    private ComboBoxWidget<ProductPeriodType> productPeriodTypeWidget;
    private BooleanValueWidget useAsShipmentPeriodWidget;
    private final ViewState viewState = new ViewState();

    public ProductPeriodDataWidget(boolean readOnly) {
        this.viewState.setReadonly(readOnly);
        this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.update());
        this.getStyleClass().addAll((Object[])new String[]{"product-period-data-widget"});
        this.update();
    }

    public void setFieldName(String val) {
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void readData(ProductPeriodData model) {
        this.setValue(model);
    }

    public void writeData(ProductPeriodData model) {
        ProductPeriodData value = this.getValue();
        if (value != null) {
            model.setProductPeriodType(value.getProductPeriodType());
            model.setUseAsShipmentPeriod(value.isUseAsShipmentPeriod());
        }
    }

    public boolean isDataChanged() {
        return MiscUtil.equals((Object)this.originalUseAsShipmentPeriod, (Object)this.useAsShipmentPeriod.get()) && MiscUtil.equals((Object)this.originalProductPeriodType, (Object)this.productPeriodType.get());
    }

    public void setValue(ProductPeriodData value) {
        if (value != null) {
            this.originalProductPeriodType = value.getProductPeriodType();
            this.originalUseAsShipmentPeriod = value.isUseAsShipmentPeriod();
            this.productPeriodType.set((Object)value.getProductPeriodType());
            this.useAsShipmentPeriod.set((Object)value.isUseAsShipmentPeriod());
        }
        this.update();
    }

    public ProductPeriodData getValue() {
        if (this.productPeriodType.get() != null) {
            ProductPeriodData value = new ProductPeriodData();
            value.setProductPeriodType((ProductPeriodType)this.productPeriodType.get());
            if (this.useAsShipmentPeriod.get() != null) {
                value.setUseAsShipmentPeriod(((Boolean)this.useAsShipmentPeriod.get()).booleanValue());
            }
            return value;
        }
        return null;
    }

    public ObjectProperty<Boolean> useAsShipmentPeriodProperty() {
        return this.useAsShipmentPeriod;
    }

    public ObjectProperty<ProductPeriodType> productPeriodTypeProperty() {
        return this.productPeriodType;
    }

    private void update() {
        if (this.viewState.isImmutable()) {
            this.productPeriodTypeWidget = null;
            this.useAsShipmentPeriodWidget = null;
            if (this.label == null) {
                this.label = new CustomLabel();
                this.label.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.label});
            }
            this.label.setText(this.productPeriodType.get() != null && this.useAsShipmentPeriod.get() != null ? this.productPeriodType.get() + " / " + ((Boolean)this.useAsShipmentPeriod.get() != false ? Messages.General_Yes : Messages.General_No) : UiUtil.NULL_TEXT);
        } else {
            this.label = null;
            if (this.productPeriodTypeWidget == null && this.useAsShipmentPeriodWidget == null) {
                this.productPeriodTypeWidget = new ComboBoxWidget(false);
                this.productPeriodTypeWidget.getStyleClass().add((Object)"productPeriodType");
                this.productPeriodTypeWidget.setItemsSupplier(Suppliers.createEnumSupplier(ProductPeriodType.class));
                this.productPeriodTypeWidget.setSortItems(false);
                this.productPeriodTypeWidget.setNoNulls(true);
                this.productPeriodTypeWidget.guessPrefWidth();
                this.productPeriodTypeWidget.valueProperty().addListener((observable, oldValue, newValue) -> this.productPeriodType.set(newValue));
                this.useAsShipmentPeriodWidget = new BooleanValueWidget(true, false);
                this.useAsShipmentPeriodWidget.getStyleClass().add((Object)"useAsShipmentPeriod");
                this.useAsShipmentPeriodWidget.valueProperty().addListener((observable, oldValue, newValue) -> this.useAsShipmentPeriod.set(newValue));
                HBox.setHgrow((Node)this.useAsShipmentPeriodWidget, (Priority)Priority.ALWAYS);
                this.getChildren().setAll((Object[])new Node[]{new HBox(new Node[]{this.productPeriodTypeWidget, this.useAsShipmentPeriodWidget})});
            }
            if (this.productPeriodTypeWidget != null) {
                this.productPeriodTypeWidget.setValue(this.productPeriodType.get());
            }
            if (this.useAsShipmentPeriodWidget != null && this.useAsShipmentPeriod.get() != null) {
                this.useAsShipmentPeriodWidget.setValue(((Boolean)this.useAsShipmentPeriod.get()).booleanValue());
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                if (ProductPeriodDataWidget.this.useAsShipmentPeriodWidget != null && ProductPeriodDataWidget.this.productPeriodTypeWidget != null) {
                    return Arrays.asList(ProductPeriodDataWidget.this.useAsShipmentPeriodWidget, ProductPeriodDataWidget.this.productPeriodTypeWidget);
                }
                return Collections.emptyList();
            }

            public String getInfo() {
                return ((Object)((Object)ProductPeriodDataWidget.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)ProductPeriodDataWidget.this.viewState);
            }
        };
    }
}

