/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import javafx.scene.Node;

public enum RendererCustomParameters {
    STRING{

        @Override
        public Node createWidget(boolean readonly, Class<?> clazz) {
            return new TextFieldWidget(readonly);
        }

        @Override
        public void setValue(Node node, Object value) {
            if (value == null || value instanceof String) {
                ((TextFieldWidget)node).setValue((String)value);
            }
        }

        @Override
        public Object getValue(Node node) {
            return ((TextFieldWidget)node).getValue();
        }
    }
    ,
    NUMBER{

        @Override
        public Node createWidget(boolean readonly, Class<?> clazz) {
            return new PriceValueWidget(readonly);
        }

        @Override
        public void setValue(Node node, Object value) {
            if (value == null || value instanceof BigDecimal) {
                ((PriceValueWidget)node).setValue((Number)((BigDecimal)value));
            }
        }

        @Override
        public Object getValue(Node node) {
            return ((PriceValueWidget)node).getValue();
        }
    }
    ,
    DATE{

        @Override
        public Node createWidget(boolean readonly, Class<?> clazz) {
            return new DateValueWidget(readonly);
        }

        @Override
        public void setValue(Node node, Object value) {
            if (value == null || value instanceof Date) {
                ((DateValueWidget)node).setValue(DateUtils.asLocalDate((Date)((Date)value)));
            }
        }

        @Override
        public Object getValue(Node node) {
            return DateUtils.asDate((LocalDate)((DateValueWidget)node).getValue());
        }
    }
    ,
    DATE_TIME{

        @Override
        public Node createWidget(boolean readonly, Class<?> clazz) {
            return new DateTimeValueWidget(readonly);
        }

        @Override
        public void setValue(Node node, Object value) {
            if (value == null || value instanceof Date) {
                ((DateTimeValueWidget)node).setValue(DateUtils.asLocalDateTime((Date)((Date)value)));
            }
        }

        @Override
        public Object getValue(Node node) {
            return DateUtils.asDate((LocalDateTime)((DateTimeValueWidget)node).getValue());
        }
    }
    ,
    DICTIONARY{

        @Override
        public Node createWidget(boolean readonly, Class<?> clazz) {
            if (!BaseDictionary.class.isAssignableFrom(clazz)) {
                throw Xeption.forDeveloper((String)String.format("%s not extends BaseDictionary", clazz), (Object[])new Object[0]);
            }
            return new DictBoxWidget(clazz, readonly);
        }

        @Override
        public void setValue(Node node, Object value) {
            if (value == null || value instanceof DictionaryReference) {
                ((DictBoxWidget)node).setValue((DictionaryReference)value);
            }
        }

        @Override
        public Object getValue(Node node) {
            return ((DictBoxWidget)node).getValue();
        }
    }
    ,
    BOOLEAN{

        @Override
        public Node createWidget(boolean readonly, Class<?> clazz) {
            return new BooleanValueWidget(false, readonly);
        }

        @Override
        public Object getValue(Node node) {
            return ((BooleanValueWidget)node).getValue();
        }

        @Override
        public void setValue(Node node, Object value) {
            if (value == null || value instanceof Boolean) {
                ((BooleanValueWidget)node).setValue(value == null ? false : (Boolean)value);
            }
        }
    };


    public abstract Node createWidget(boolean var1, Class<?> var2);

    public abstract void setValue(Node var1, Object var2);

    public abstract Object getValue(Node var1);
}

