/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.helpers.SabreMaskHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.Popup;
import javafx.stage.Window;

public class SabreMaskWidget
extends CustomWidget<ValueHolder<String>> {
    private String value;
    private String readValue;
    private final ViewState viewState = new ViewState();
    private Label readonlyLabel;
    private ClearableTextField textField;
    private boolean internalChange;
    private boolean popupChange;
    private Supplier<String> maskSupplier = () -> null;
    private BiConsumer<String, String> popupListener;
    private ActionData actionData;
    private final List<String> excludedSymbols = new ArrayList<String>();

    public void setExcludedSymbols(List<String> excludedSymbols) {
        this.excludedSymbols.clear();
        Optional.ofNullable(excludedSymbols).ifPresent(this.excludedSymbols::addAll);
    }

    public SabreMaskWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"text-field-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void setFieldName(String val) {
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void readData(ValueHolder<String> model) {
        this.readValue = this.value = (String)model.get();
        this.updateState();
    }

    public void writeData(ValueHolder<String> model) {
        model.set((Object)this.value);
    }

    public boolean isDataChanged() {
        return !CustomTextField.sameNormalizedText((String)this.value, (String)this.readValue);
    }

    public void setMaskSupplier(Supplier<String> val) {
        this.maskSupplier = Objects.requireNonNull(val);
    }

    public void setPopupListener(BiConsumer<String, String> listener) {
        this.popupListener = listener;
    }

    public void setItemsSupplier(Supplier<List<String>> val) {
        if (val == null) {
            this.setActionHandler(null, null, null);
        } else {
            this.setActionHandler((IconShape)StandardIconShapes.COMBOBOX_DOWN_ARROW, Messages.General_Choose_value_from_list, node -> this.showItemsPopup((Node)node, val));
        }
    }

    public boolean hasItemsSupplier() {
        return this.actionData != null;
    }

    private void setActionHandler(IconShape iconShape, String tooltip, Consumer<Node> handler) {
        this.actionData = handler == null ? null : new ActionData(Objects.requireNonNull(iconShape), tooltip, handler);
        this.updateState();
    }

    private void showItemsPopup(Node anchor, Supplier<List<String>> itemsSupplier) {
        Popup popup = new Popup();
        popup.setAutoFix(true);
        popup.setAutoHide(true);
        popup.setHideOnEscape(true);
        ListView listView = new ListView();
        listView.getItems().addAll((Collection)itemsSupplier.get());
        listView.setCellFactory(TextFieldListCell.forListView());
        listView.setOnMouseClicked(me -> {
            if (me.getButton() == MouseButton.PRIMARY) {
                this.popupChange = true;
                this.textField.setText((String)listView.getSelectionModel().getSelectedItem());
                this.popupChange = false;
                popup.hide();
            }
        });
        StackPane sp = new StackPane(new Node[]{listView});
        sp.getStyleClass().addAll((Object[])new String[]{"combo-box-popup", "xtrip-scroll-alt"});
        sp.setPrefHeight((double)Math.min(10, listView.getItems().size()) * 32.5 + 9.0);
        sp.setMinHeight(Double.NEGATIVE_INFINITY);
        sp.setMaxHeight(Double.NEGATIVE_INFINITY);
        int chars = 10;
        for (String item : listView.getItems()) {
            if (item == null) continue;
            chars = Math.max(chars, item.length());
        }
        chars = Math.min(30, chars);
        sp.setPrefWidth((double)(chars * 15));
        sp.setMinWidth(Double.NEGATIVE_INFINITY);
        sp.setMaxWidth(Double.NEGATIVE_INFINITY);
        popup.getContent().add((Object)sp);
        popup.sizeToScene();
        Window window = anchor.getScene().getWindow();
        popup.show(anchor, window.getX() + anchor.localToScene(0.0, 0.0).getX() + anchor.getScene().getX(), window.getY() + anchor.localToScene(0.0, 0.0).getY() + anchor.getScene().getY() + 28.0);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.readValue = value;
        this.updateState();
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.textField = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
            this.readonlyLabel.setText(TextUtil.isBlank((String)this.value) ? "\u2014" : this.value);
        } else {
            this.readonlyLabel = null;
            if (this.textField == null) {
                this.textField = new ClearableTextField(){

                    public void clear() {
                        this.setText(null);
                    }
                };
                this.textField.setPromptText(UiUtil.NULL_TEXT);
                this.textField.textProperty().addListener((s, o, n) -> {
                    if (this.popupChange) {
                        this.popupListener.accept(this.value, this.textField.getText());
                    }
                    if (this.internalChange) {
                        return;
                    }
                    this.value = this.textField.getText();
                    if (this.value != null) {
                        this.value = this.value.replace('\u2666', ' ');
                        if (TextUtil.isBlank((String)this.value)) {
                            this.value = null;
                        }
                    }
                });
                SabreMaskHelper mask = new SabreMaskHelper(() -> this.maskSupplier.get());
                this.textField.setTextFormatter(new TextFormatter(change -> this.handleChange(mask, (TextFormatter.Change)change, this.excludedSymbols)));
                this.textField.focusedProperty().addListener((s, o, n) -> {
                    if (n.booleanValue() || TextUtil.isBlank((String)this.value)) {
                        return;
                    }
                    if (!mask.isValid(this.value)) {
                        UiUtil.blink((Node)this.textField);
                    }
                });
            }
            if (this.actionData != null) {
                HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
                Button button = new Button();
                button.setOnAction(evt -> this.actionData.handler.accept((Node)button));
                button.setGraphic((Node)new IconNode(this.actionData.shape, (Styleable)button, (IconIntention)StandardIconIntentions.COMBOBOX_LIST_ARROW_ACTION, (Styleable)button));
                if (TextUtil.nonBlank((String)this.actionData.tooltip)) {
                    UiUtil.setTooltip((Node)button, (String)this.actionData.tooltip);
                }
                button.getStyleClass().add((Object)"xtrip-button");
                this.getChildren().setAll((Object[])new Node[]{new HBox(new Node[]{this.textField, button})});
            } else {
                this.getChildren().setAll((Object[])new Node[]{this.textField});
            }
            this.internalChange = true;
            this.textField.setText(this.value);
            this.textField.setDisable(this.actionData != null);
            this.internalChange = false;
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    private TextFormatter.Change handleChange(SabreMaskHelper mask, TextFormatter.Change change, List<String> excludedSymbols) {
        mask.actualizeMask();
        List chars = mask.getChars();
        if (CollectionUtil.isNotEmpty(excludedSymbols) && excludedSymbols.stream().anyMatch(excludedSymbol -> change.getText().contains((CharSequence)excludedSymbol))) {
            change.setText("");
            return change;
        }
        if (chars.isEmpty() || !change.isContentChange()) {
            return change;
        }
        if (change.isAdded() && !change.isReplaced()) {
            boolean denyChange;
            boolean bl = denyChange = change.getControlNewText().length() > chars.size();
            if (!denyChange) {
                char[] arr = change.getText().toCharArray();
                for (int i = 0; i < arr.length; ++i) {
                    char corrected;
                    int idx = change.getRangeStart() + i;
                    if (idx >= chars.size() || (corrected = ((SabreMaskHelper.Char)chars.get(idx)).correct(arr[i])) == '\u2666') {
                        denyChange = true;
                        break;
                    }
                    arr[i] = corrected;
                }
                if (!denyChange) {
                    change.setText(new String(arr));
                }
            }
            if (denyChange) {
                change.setText("");
                change.selectRange(change.getRangeStart(), change.getRangeStart());
            }
            return change;
        }
        char[] textAfterChange = change.getControlNewText().toCharArray();
        char[] newText = new char[Math.min(textAfterChange.length, chars.size())];
        for (int i = 0; i < newText.length; ++i) {
            newText[i] = ((SabreMaskHelper.Char)chars.get(i)).correct(textAfterChange[i]);
        }
        change.setRange(0, change.getControlText().length());
        change.setText(new String(newText));
        return change;
    }

    private static class ActionData {
        final IconShape shape;
        final String tooltip;
        final Consumer<Node> handler;

        ActionData(IconShape is, String tt, Consumer<Node> h) {
            this.shape = is;
            this.tooltip = tt;
            this.handler = h;
        }
    }
}

