/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.custom.UniversalProductCustomParametersVM;
import com.gridnine.xtrip.client.fx.standard.custom.RendererCustomParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameter;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class UniversalProductCustomParametersWidget
extends CustomWidget<UniversalProductCustomParametersVM>
implements DevTool {
    private final GridContainer container = new GridContainer();
    private final Map<String, MiscUtil.Pair<Node, Object>> mapWidget = new HashMap<String, MiscUtil.Pair<Node, Object>>();
    private final Map<String, RendererCustomParameters> mapIdRenderer = new HashMap<String, RendererCustomParameters>();
    private final ViewState viewState = new ViewState();

    public UniversalProductCustomParametersWidget(boolean readonly) {
        this.viewState.setReadonly(readonly);
        this.getStyleClass().add((Object)"universal-product-params-widget");
        this.container.setColumnsCount(4);
        this.getChildren().add((Object)this.container);
        FxUtil.addListener((ObservableValue)this.viewState.stateProperty(), (s, o, n) -> {
            for (GridCell cell : this.container.getCells()) {
                if (!(cell.getPayload() instanceof HasViewState)) continue;
                ((HasViewState)cell.getPayload()).getViewState().setState(n.intValue());
            }
        });
    }

    public void setFieldName(String value) {
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void readData(UniversalProductCustomParametersVM model) {
        this.preFillingMapWidgetIdFromDescription(model);
        this.preFillingMapWidgetValueFromParameters(model);
        this.fillingMapWidgetRendererAndCreateRenderer(model);
    }

    private void preFillingMapWidgetIdFromDescription(UniversalProductCustomParametersVM model) {
        model.getCustomParametersDescription().forEach(des -> this.mapWidget.put(des.getId(), (MiscUtil.Pair<Node, Object>)new MiscUtil.Pair(null, null)));
    }

    private void preFillingMapWidgetValueFromParameters(UniversalProductCustomParametersVM model) {
        model.getCustomParameters().forEach(param -> this.mapWidget.put(param.getId(), (MiscUtil.Pair<Node, Object>)new MiscUtil.Pair(null, param.getValue())));
    }

    private void fillingMapWidgetRendererAndCreateRenderer(UniversalProductCustomParametersVM model) {
        ArrayList tempList = new ArrayList();
        model.getCustomParametersDescription().forEach(des -> {
            Node widget;
            String type = des.getType().name();
            RendererCustomParameters typeRenderer = RendererCustomParameters.valueOf(type);
            try {
                widget = typeRenderer.createWidget(this.viewState.isImmutable(), des.getTypeAdditionalInfo() == null ? null : Class.forName((String)des.getTypeAdditionalInfo()));
            }
            catch (ClassNotFoundException e) {
                throw Xeption.forDeveloper((String)String.format("%s not found", (String)des.getTypeAdditionalInfo()), (Throwable)e, (Object[])new Object[0]);
            }
            GridCell cell = new GridCell(widget);
            cell.setCaption(des.getDisplayName());
            MiscUtil.Pair<Node, Object> pair = this.mapWidget.get(des.getId());
            pair.setFirst((Object)widget);
            this.mapIdRenderer.put(des.getId(), typeRenderer);
            typeRenderer.setValue(widget, pair.getSecond());
            tempList.add(cell);
        });
        this.container.getCells().setAll(tempList);
    }

    public void writeData(UniversalProductCustomParametersVM model) {
        model.getCustomParameters().clear();
        this.mapWidget.forEach((idParam, pair) -> {
            Node widget = (Node)pair.getFirst();
            if (widget == null) {
                return;
            }
            RendererCustomParameters type = this.mapIdRenderer.get(idParam);
            Object value = type.getValue(widget);
            UniversalProductCustomParameter param = new UniversalProductCustomParameter();
            param.setValue(value);
            param.setId(idParam);
            model.getCustomParameters().add(param);
        });
    }

    public boolean isDataChanged() {
        return this.mapWidget.entrySet().stream().anyMatch(entry -> {
            Node widget = (Node)((MiscUtil.Pair)entry.getValue()).getFirst();
            if (widget == null) {
                return false;
            }
            RendererCustomParameters type = this.mapIdRenderer.get(entry.getKey());
            if (type.getValue(widget) == null) {
                return ((MiscUtil.Pair)entry.getValue()).getSecond() != null;
            }
            if (((MiscUtil.Pair)entry.getValue()).getSecond() == null) {
                return type.getValue(widget) != null;
            }
            return !type.getValue(widget).equals(((MiscUtil.Pair)entry.getValue()).getSecond());
        });
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(UniversalProductCustomParametersWidget.this.container);
            }

            public String getInfo() {
                return ((Object)((Object)UniversalProductCustomParametersWidget.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)UniversalProductCustomParametersWidget.this.viewState);
            }
        };
    }
}

