/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom.metadata;

import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BusinessType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.dict.ServicePlatform;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import java.time.LocalDate;
import java.util.Arrays;
import javafx.beans.property.ObjectProperty;

public enum MetadataWidgetValueWrapper {
    STRING{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            return new TextFieldWidget(ro);
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((TextFieldWidget)widget).setValue(value != null ? value.toString() : null);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((TextFieldWidget)widget).getValue();
        }
    }
    ,
    BOOLEAN{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            return new BooleanValueWidget(false, ro);
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((BooleanValueWidget)widget).setValue((value != null ? (Boolean)value : Boolean.FALSE).booleanValue());
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((BooleanValueWidget)widget).getValue();
        }
    }
    ,
    DATE{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            return new DateValueWidget(ro);
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((DateValueWidget)widget).setValue((LocalDate)value);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((DateValueWidget)widget).getValue();
        }
    }
    ,
    COUNTRY{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            return new DictBoxWidget(Country.class, ro);
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((DictBoxWidget)widget).setValue((DictionaryReference)value);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((DictBoxWidget)widget).getValue();
        }
    }
    ,
    PERSON{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            return new EntityBoxWidget(Person.class, ro);
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((EntityBoxWidget)widget).setValue((EntityReference)value);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((EntityBoxWidget)widget).getValue();
        }
    }
    ,
    AGENCY{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            EntityBoxWidget widget = new EntityBoxWidget(Organization.class, ro);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
            return widget;
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((EntityBoxWidget)widget).setValue((EntityReference)value);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((EntityBoxWidget)widget).getValue();
        }
    }
    ,
    HOLDING{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            EntityBoxWidget widget = new EntityBoxWidget(Holding.class, ro);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getHoldings);
            return widget;
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((EntityBoxWidget)widget).setValue((EntityReference)value);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((EntityBoxWidget)widget).getValue();
        }
    }
    ,
    SALES_POINT{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            EntityBoxWidget widget = new EntityBoxWidget(SalesPoint.class, ro);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getSalesPoints);
            return widget;
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((EntityBoxWidget)widget).setValue((EntityReference)value);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((EntityBoxWidget)widget).getValue();
        }
    }
    ,
    BUSINESS_TYPE{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            return new DictBoxWidget(BusinessType.class, ro);
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((DictBoxWidget)widget).setValue((DictionaryReference)value);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((DictBoxWidget)widget).getValue();
        }
    }
    ,
    PROFILE_GROUP{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            return new DictBoxWidget(ProfileGroup.class, ro);
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((DictBoxWidget)widget).setValue((DictionaryReference)value);
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((DictBoxWidget)widget).getValue();
        }
    }
    ,
    SERVICE_PLATFORM{

        @Override
        HasValue<?> createValueWidget(boolean ro) {
            ComboBoxWidget widget = new ComboBoxWidget(ro);
            widget.setItemsSupplier(() -> Arrays.asList(ServicePlatform.values()));
            return widget;
        }

        @Override
        void setValue(HasValue<?> widget, Object value) {
            ((ComboBoxWidget)widget).setValue((Object)((ServicePlatform)value));
        }

        @Override
        Object getValue(HasValue<?> widget) {
            return ((ComboBoxWidget)widget).getValue();
        }
    };


    abstract HasValue<?> createValueWidget(boolean var1);

    abstract void setValue(HasValue<?> var1, Object var2);

    abstract Object getValue(HasValue<?> var1);

    ObjectProperty<?> getValueProperty(HasValue<?> widget) {
        return widget.valueProperty();
    }
}

