/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModification;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModificationEvent;
import com.gridnine.xtrip.client.fx.core.dicts.editor.DictEditorPane;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.service.DictEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.dicts.DictEditorParameters;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;

public class DictEditorActivityHandler
extends ActivityHandler<DictEditorPane<?>, DictEditorParameters> {
    private static String ID = "dict-editor-activity-handler";
    private final Consumer<DictionaryModificationEvent> modificationEventHandler = evt -> {
        List refs = evt.getModifications().stream().filter(mod -> mod.getType() == DictionaryModification.ModificationType.DELETE).map(mod -> mod.getReference()).collect(Collectors.toList());
        if (refs.isEmpty()) {
            return;
        }
        FxUtil.runInFxThread(() -> this.closeActivities(refs));
    };

    public static DictEditorActivityHandler get() {
        return (DictEditorActivityHandler)DictEditorActivityHandler.forId((String)ID);
    }

    public static String buildToken(DictHandler<?> handler, String dictCode) {
        return handler.getId() + '|' + dictCode;
    }

    public static void register(ClientRegistry registry) {
        if (!registry.allOf(TYPE).containsKey(ID)) {
            registry.register((RegistryItem)new DictEditorActivityHandler());
        }
    }

    private DictEditorActivityHandler() {
        Environment.publish(DictEditingService.class, ref -> {
            DictHandler handler = DictHandler.forDictClass((Class)ref.getType());
            if (handler == null) {
                StandardNotifications.VIEWER_NOT_SUPPORTED.show(ref.getType() == null ? "null" : ref.getType().getName());
                return;
            }
            NavigationParameters parameters = new NavigationParameters();
            parameters.setParameters((Object)new DictEditorParameters(handler.getId(), ref.getCode()));
            ActivityManager.get().navigate(DictEditorActivityHandler.buildToken(handler, ref.getCode()), (ActivityHandler)DictEditorActivityHandler.get(), parameters);
        });
        EventBus.get().subscribe(DictionaryModificationEvent.TYPE, this.modificationEventHandler);
    }

    private void closeActivities(List<DictionaryReference<?>> refs) {
        for (DictionaryReference<?> ref : refs) {
            DictHandler handler = DictHandler.forDictClass((Class)ref.getType());
            if (handler == null) continue;
            ActivityManager.get().remove(DictEditorActivityHandler.buildToken(handler, ref.getCode()), true);
        }
    }

    public String getId() {
        return ID;
    }

    protected boolean isHighlighted(ActivityState<DictEditorPane<?>, DictEditorParameters> state) {
        return true;
    }

    protected DictEditorPane<?> createView(ActivityState<DictEditorPane<?>, DictEditorParameters> state) {
        state.setStateful(((DictEditorParameters)state.getParameters()).getDictCode() != null);
        DictHandler handler = DictHandler.forId((String)((DictEditorParameters)state.getParameters()).getHandlerId());
        DictEditorPane result = new DictEditorPane(state.getMutex(), handler, ((DictEditorParameters)state.getParameters()).getDictCode());
        FxUtil.bind((Property)state.titleProperty(), (ObservableValue)result.titleProperty());
        FxUtil.bind((Property)state.descriptionProperty(), (ObservableValue)result.descriptionProperty());
        result.codeProperty().addListener((obj, oldValue, newValue) -> {
            ((DictEditorParameters)state.getParameters()).setDictCode((String)newValue);
            state.setStateful(newValue != null);
            state.parametersChanged();
            state.setToken(DictEditorActivityHandler.buildToken(handler, newValue));
        });
        Notifications.get().submitTask(() -> result.reloadData(), result.getMutex());
        return result;
    }

    protected boolean hasChanges(ActivityState<DictEditorPane<?>, DictEditorParameters> state) {
        DictEditorPane view = (DictEditorPane)this.getView(state);
        return view != null && view.isDataChanged();
    }

    protected void saveChanges(ActivityState<DictEditorPane<?>, DictEditorParameters> state) throws Exception {
        DictEditorPane view = (DictEditorPane)this.getView(state);
        if (view == null) {
            return;
        }
        view.saveData();
    }

    protected Serializer<DictEditorParameters> getSerializer() {
        return DictEditorParameters.SERIALIZER;
    }
}

