/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModification;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModificationEvent;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListAction;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.standard.dicts.actions.DictActionsHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class DeleteDictListAction
implements DictsListAction {
    public ActionIcon getIcon(DictsListPane context) {
        return StandardActionIcons.DELETE;
    }

    public String getId() {
        return "dict-delete";
    }

    public double getWeight() {
        return 20.0;
    }

    public boolean isAvailable(DictsListPane context) {
        return !((DictionaryType)MetaRegistry.get().getDictionaries().get(context.getDictHandler().getDictType().getName())).isInternal() && !context.getDictHandler().isReadonly();
    }

    public boolean isEnabled(DictsListPane context) {
        if (context.getDictHandler() == null || context.getSelectedItems().isEmpty()) {
            return false;
        }
        return !DictActionsHelper.areAllPredefined(context.getSelectedItems());
    }

    public void execute(Control source, DictsListPane context, boolean alt) {
        List items = context.getSelectedItems();
        if (items.isEmpty()) {
            return;
        }
        Dialog dialog = new Dialog();
        dialog.setMessage(Messages.Delete_selected_elements);
        dialog.addButton(DialogButtonStyle.DECLINE, Messages.Cancel, () -> ((Dialog)dialog).close());
        dialog.addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Delete, () -> Notifications.get().submitTask(() -> DeleteDictListAction.deleteItems(items), context.getMutex()));
        dialog.show((Node)context);
    }

    public static void deleteItems(List<DictItem<?>> items) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        int count = 0;
        for (DictItem<?> item2 : items) {
            if (DictActionsHelper.isPredefined(item2)) continue;
            dictService.delete(sic, item2.getReference());
            ++count;
        }
        int count2 = count;
        StandardNotifications.DELETED.show(Messages.Deleted_records + count2);
        EventBus.get().publishAsync((Event)new DictionaryModificationEvent((Collection)items.stream().map(item -> new DictionaryModification(item.getReference(), DictionaryModification.ModificationType.DELETE)).collect(Collectors.toList())));
    }
}

