/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dicts.editor.DictEditorAction;
import com.gridnine.xtrip.client.fx.core.dicts.editor.DictEditorPane;
import com.gridnine.xtrip.client.fx.standard.dicts.actions.DictActionsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DictEditorHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.DateFormat;
import javafx.scene.control.Control;

public class DictVersionsAction
implements DictEditorAction {
    public ActionIcon getIcon(DictEditorPane<?> context) {
        return StandardActionIcons.VERSIONS;
    }

    public String getId() {
        return "dict-versions";
    }

    public double getWeight() {
        return 10.0;
    }

    public boolean isEnabled(DictEditorPane<?> context) {
        return context.getData() != null && !DictActionsHelper.isPredefined(context.getData());
    }

    public String getDescription(DictEditorPane<?> context) {
        if (context.getData() == null) {
            return super.getDescription(context);
        }
        BaseDictionary dict = context.getData();
        StringBuilder buf = new StringBuilder();
        DateFormat dtf = LocaleManager.get().getCurrentLocaleData().getDateTimeFormat();
        buf.append(Messages.Version_Created);
        if (dict.getCreated() != null) {
            buf.append(' ').append(dtf.format(dict.getModified()));
        }
        buf.append(' ').append(dict.getModifiedBy()).append('\n');
        buf.append(Messages.Version_Modified);
        if (dict.getModified() != null) {
            buf.append(' ').append(dtf.format(dict.getModified()));
        }
        buf.append(' ').append(dict.getModifiedBy());
        if (!TextUtil.isBlank((String)dict.getDataSource())) {
            buf.append('\n').append(Messages.Version_Data_Source).append(dict.getDataSource());
        }
        if (!TextUtil.isBlank((String)dict.getVersionNotes())) {
            buf.append('\n').append(Messages.Version_Comment).append(dict.getVersionNotes());
        }
        return buf.toString();
    }

    public void execute(Control source, DictEditorPane<?> context, boolean alt) {
        DictEditorHelper.showVersionsDialog(context.getData(), context, context.getMutex());
    }
}

