/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.filters;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;

public class BooleanValueActualDictFilterFactory
implements ListPaneFilterFactory {
    public boolean isApplicableTo(TableColumnSettings settings) {
        return "boolean-actual-dict".equals(settings.getType());
    }

    public FilterHandler createFor(final TableColumnSettings settings, Supplier<List<?>> itemsSupplier) {
        return new FilterHandler(){
            private BooleanValueWidget control;

            public void reset() {
                this.control.setValue(false);
            }

            public List<Object> getData() {
                Boolean value = this.control.getValue();
                return value == null ? null : new ArrayList<Boolean>(Collections.singletonList(value));
            }

            public void setData(List<Object> value) {
                if (value.isEmpty()) {
                    this.reset();
                } else {
                    this.control.setValue(((Boolean)value.get(0)).booleanValue());
                }
            }

            public void build(Pane pane) {
                this.control = new BooleanValueWidget(false, false);
                this.control.setConverter((StringConverter)new StringConverter<Boolean>(){

                    public String toString(Boolean object) {
                        return object != false ? Messages.show_only_irrelevant : Messages.show_only_relevant;
                    }

                    public Boolean fromString(String string) {
                        return string.equals(Messages.show_only_irrelevant);
                    }
                });
                FilterHandler.buildFilter((Pane)pane, (String)settings.getDisplayName(), (Node)this.control);
            }
        };
    }
}

