/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.LocaleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.dict.CodeVariantsPanelController;
import com.gridnine.xtrip.client.fx.model.dict.CodeVariantsPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.TranslationVM;
import com.gridnine.xtrip.client.fx.model.dict.TranslationsPanelController;
import com.gridnine.xtrip.client.fx.model.dict.TranslationsPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.scene.Node;

public abstract class BaseDictHandler<V extends Node, M extends BaseDictionary, VM>
implements DictHandler<M> {
    private DictListParameters standardListParameters;
    private List<BiConsumer<M, VM>> toVMtranslators;
    private List<BiConsumer<VM, M>> fromVMtranslators;

    public final DictListParameters getStandardListParameters() {
        if (this.standardListParameters == null) {
            this.standardListParameters = new DictListParameters();
            this.configureStandardListParameters(this.standardListParameters);
        }
        return this.standardListParameters;
    }

    public final ViewController<?, M> createEditorController() {
        if (this.toVMtranslators == null) {
            this.toVMtranslators = new ArrayList<BiConsumer<M, VM>>();
            this.fromVMtranslators = new ArrayList<BiConsumer<VM, M>>();
            this.configureController(this.toVMtranslators, this.fromVMtranslators);
        }
        return new ViewController<Node, M>(){
            private ViewController<V, VM> controller;
            private M data;

            private ViewController<V, VM> getController() {
                if (this.controller == null) {
                    this.controller = BaseDictHandler.this.createController();
                }
                return this.controller;
            }

            public V getView() {
                return this.getController().getView();
            }

            public M getData() {
                return this.data;
            }

            public void readData(M model) {
                this.data = model;
                Object vm = BaseDictHandler.this.createVM();
                BaseDictHandler.this.toVM(model, vm);
                this.getController().readData(vm);
            }

            public void writeData(M model) {
                this.data = model;
                Object vm = BaseDictHandler.this.createVM();
                BaseDictHandler.this.toVM(model, vm);
                this.getController().writeData(vm);
                BaseDictHandler.this.fromVM(vm, model);
            }

            public boolean isReadonly() {
                return this.getController().isReadonly();
            }

            public void setReadonly(boolean readonly) {
                this.getController().setReadonly(readonly);
            }

            public void setNotEditable(boolean notEditable) {
                this.getController().setNotEditable(notEditable);
            }

            public void setAclNotEditable(boolean aclNotEditable) {
                this.getController().setAclNotEditable(aclNotEditable);
            }

            public boolean isDataChanged() {
                return this.getController().isDataChanged();
            }

            public void validateData(List<Message> messages) {
                this.getController().validateData(messages);
            }
        };
    }

    final void toVM(M model, VM vm) {
        this.toVMtranslators.forEach(tr -> tr.accept(model, vm));
    }

    final void fromVM(VM vm, M model) {
        this.fromVMtranslators.forEach(tr -> tr.accept(vm, model));
    }

    protected abstract void configureStandardListParameters(DictListParameters var1);

    protected abstract void configureController(List<BiConsumer<M, VM>> var1, List<BiConsumer<VM, M>> var2);

    protected abstract VM createVM();

    protected abstract ViewController<V, VM> createController();

    public boolean isAvaibleInConfiguration() {
        DictionaryType dt = (DictionaryType)MetaRegistry.get().getDictionaries().get(this.getDictType().getName());
        return AppConfigHelper.isInScope(dt);
    }

    static {
        ControllersRegistry.register((ControllerInterceptor)new ControllerInterceptor<TranslationsPanelVM, TranslationsPanelController>(){

            protected Class<TranslationsPanelController> getControllerClass() {
                return TranslationsPanelController.class;
            }

            protected void onCreate(TranslationsPanelController controller) {
                ValueHolder selectedLocales = new ValueHolder();
                ((TableWidget)controller.getView().getContent()).setOnRowsAction(evt -> selectedLocales.set(null));
                ((LocaleValueWidgetColumn)((TableWidget)controller.getView().getContent()).getColumn("locale")).setNoNulls(true);
                ((LocaleValueWidgetColumn)((TableWidget)controller.getView().getContent()).getColumn("locale")).setExtendedCode(true);
                ((LocaleValueWidgetColumn)((TableWidget)controller.getView().getContent()).getColumn("locale")).setFilter(locale -> {
                    if (selectedLocales.get() == null) {
                        selectedLocales.set(((TableWidget)controller.getView().getContent()).getRowsData().stream().filter(vm -> vm.getLocale() != null).map(TranslationVM::getLocale).collect(Collectors.toSet()));
                    }
                    return !((Set)selectedLocales.get()).contains(locale);
                });
            }
        });
        ControllersRegistry.register((ControllerInterceptor)new ControllerInterceptor<CodeVariantsPanelVM, CodeVariantsPanelController>(){

            protected Class<CodeVariantsPanelController> getControllerClass() {
                return CodeVariantsPanelController.class;
            }

            protected void onCreate(CodeVariantsPanelController controller) {
                ((ComboBoxWidgetColumn)((TableWidget)controller.getView().getContent()).getColumn("codeSystem")).setNoNulls(true);
            }
        });
    }
}

