/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.BrandNamePanel;
import com.gridnine.xtrip.client.fx.model.dict.BrandNamePanelController;
import com.gridnine.xtrip.client.fx.model.dict.BrandNamePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.BrandName;
import com.gridnine.xtrip.common.model.dict.BrandNameReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.BiConsumer;

public class BrandNameClassHandler
extends BaseDictHandler<BrandNamePanel, BrandName, BrandNamePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BrandName.Property.airlineCode.name(), Messages.Airline, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    protected void configureController(List<BiConsumer<BrandName, BrandNamePanelVM>> toVM, List<BiConsumer<BrandNamePanelVM, BrandName>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getAirline().setAirlineCode(model.getAirlineCode());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getNames().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setAirlineCode(vm.getAirline().getAirlineCode());
            DictHandlersHelper.translationsFromVM(vm.getNames().getContent(), model.getTranslations());
        });
    }

    @Override
    protected BrandNamePanelVM createVM() {
        return new BrandNamePanelVM();
    }

    @Override
    protected ViewController<BrandNamePanel, BrandNamePanelVM> createController() {
        return new BrandNamePanelController(false);
    }

    public Class<BrandName> getDictType() {
        return BrandName.class;
    }

    public DictionaryReference<BrandName> createReference(String code) {
        return new BrandNameReference(code);
    }
}

