/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.dict.CarsSupplierPanel;
import com.gridnine.xtrip.client.fx.model.dict.CarsSupplierPanelController;
import com.gridnine.xtrip.client.fx.model.dict.CarsSupplierPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.CarsSupplier;
import com.gridnine.xtrip.common.model.dict.CarsSupplierReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class CarsSupplierHandler
extends BaseDictHandler<CarsSupplierPanel, CarsSupplier, CarsSupplierPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    protected void configureController(List<BiConsumer<CarsSupplier, CarsSupplierPanelVM>> toVM, List<BiConsumer<CarsSupplierPanelVM, CarsSupplier>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setCarsSupplier(model.getCode());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getCarsSupplier()));
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<CarsSupplier> getDictType() {
        return CarsSupplier.class;
    }

    public DictionaryReference<CarsSupplier> createReference(String code) {
        return new CarsSupplierReference(code);
    }

    @Override
    protected CarsSupplierPanelVM createVM() {
        return new CarsSupplierPanelVM();
    }

    @Override
    protected ViewController<CarsSupplierPanel, CarsSupplierPanelVM> createController() {
        return new CarsSupplierPanelController(false);
    }
}

