/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.dict.ClassOfServiceCodeMainPanel;
import com.gridnine.xtrip.client.fx.model.dict.ClassOfServiceCodeMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.ClassOfServiceCodePanel;
import com.gridnine.xtrip.client.fx.model.dict.ClassOfServiceCodePanelController;
import com.gridnine.xtrip.client.fx.model.dict.ClassOfServiceCodePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictQueryPseudoProperties;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCodeReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;

public class ClassOfServiceCodeHandler
extends BaseDictHandler<ClassOfServiceCodePanel, ClassOfServiceCode, ClassOfServiceCodePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ClassOfServiceCode.Property.classOfService.name(), Messages.Class_of_Service, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ClassOfServiceCode.Property.codes.name(), Messages.Codes, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ClassOfServiceCode.Property.airline.name(), Messages.Marketing_carrier, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ClassOfServiceCode.Property.operatingAirline.name(), Messages.Operating_carrier, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ClassOfServiceCode.Property.startDate.name(), Messages.Start_date2, (Renderer)StandardRenderers.DATE));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ClassOfServiceCode.Property.endDate.name(), Messages.Finish_date2, (Renderer)StandardRenderers.DATE));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ClassOfServiceCode.Property.noUpdate.name(), Messages.No_update, (Renderer)StandardRenderers.BOOLEAN));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ClassOfServiceCode.Property.transportationType.name(), Messages.Transportation_type, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().addAll(Arrays.asList(DictHandlersHelper.createColumn(ClassOfServiceCode.class, ClassOfServiceCode.Property.classOfService.name(), Messages.Class_of_Service, (Renderer)StandardRenderers.GENERIC), DictHandlersHelper.createColumn(ClassOfServiceCode.class, ClassOfServiceCode.Property.airline.name(), Messages.Marketing_carrier, (Renderer)StandardRenderers.GENERIC)));
        TableColumnSettings codesFilter = new TableColumnSettings();
        codesFilter.setId(DictQueryPseudoProperties.CLASS_OF_SERVICE_CODES);
        codesFilter.setType(String.class.getSimpleName());
        codesFilter.setDisplayName(Messages.Codes);
        codesFilter.setRenderer((Renderer)StandardRenderers.GENERIC);
        params.getFilters().add(codesFilter);
    }

    @Override
    protected void configureController(List<BiConsumer<ClassOfServiceCode, ClassOfServiceCodePanelVM>> toVM, List<BiConsumer<ClassOfServiceCodePanelVM, ClassOfServiceCode>> fromVM) {
        toVM.add((model, vm) -> {
            ClassOfServiceCodeMainPanelVM main = vm.getMain();
            main.setType(model.getClassOfService());
            StringBuilder buf = new StringBuilder();
            Iterator it = model.getCodes().iterator();
            while (it.hasNext()) {
                buf.append((String)it.next());
                if (!it.hasNext()) continue;
                buf.append(',');
            }
            main.setCodes(buf.toString());
            main.setMarketingCarrier(model.getAirline());
            main.setOperatingCarrier(model.getOperatingAirline());
            main.setOpenedDate(DateUtils.asLocalDate((Date)model.getStartDate()));
            main.setClosedDate(DateUtils.asLocalDate((Date)model.getEndDate()));
            main.setUpdate(model.isNoUpdate());
            main.setTransportationType(model.getTransportationType());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            String[] strings;
            ClassOfServiceCodeMainPanelVM main = vm.getMain();
            Set workSet = model.getCodes();
            workSet.clear();
            for (String str : strings = main.getCodes().trim().split(",")) {
                workSet.add(str);
            }
            model.setClassOfService(main.getType());
            model.setAirline(main.getMarketingCarrier());
            model.setOperatingAirline(main.getOperatingCarrier());
            model.setStartDate(DateUtils.asDate((LocalDate)main.getOpenedDate()));
            model.setEndDate(DateUtils.asDate((LocalDate)main.getClosedDate()));
            model.setNoUpdate(vm.getMain().isUpdate());
            model.setTransportationType(vm.getMain().getTransportationType());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<ClassOfServiceCode> getDictType() {
        return ClassOfServiceCode.class;
    }

    public DictionaryReference<ClassOfServiceCode> createReference(String code) {
        return new ClassOfServiceCodeReference(code);
    }

    @Override
    protected ClassOfServiceCodePanelVM createVM() {
        return new ClassOfServiceCodePanelVM();
    }

    @Override
    protected ViewController<ClassOfServiceCodePanel, ClassOfServiceCodePanelVM> createController() {
        ClassOfServiceCodePanelController controller = new ClassOfServiceCodePanelController(false);
        ((ClassOfServiceCodeMainPanel)controller.getView().getMainCard().getContent()).getTransportationTypeNode().setItemsSupplier(() -> Arrays.asList(TransportationType.DOMESTIC, TransportationType.INTERNATIONAL));
        return controller;
    }
}

