/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.CountryPanel;
import com.gridnine.xtrip.client.fx.model.dict.CountryPanelController;
import com.gridnine.xtrip.client.fx.model.dict.CountryPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.GeoRegionVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.CountryControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class CountryHandler
extends BaseDictHandler<CountryPanel, Country, CountryPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Country.Property.domestic.name(), Messages.Inner, (Renderer)StandardRenderers.BOOLEAN));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Country.Property.regions.name(), Messages.Regions, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Country.Property.ruPassportAllowed.name(), Messages.Alowed_passport_RF, (Renderer)StandardRenderers.BOOLEAN));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Country.Property.phoneCode.name(), Messages.Telephone_code, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.COL_NOT_UPDATE);
    }

    @Override
    protected void configureController(List<BiConsumer<Country, CountryPanelVM>> toVM, List<BiConsumer<CountryPanelVM, Country>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CountryControllerInterceptor());
        toVM.add((model, vm) -> {
            vm.getMain().setNotUpdate(model.isNotUpdatable());
            vm.getMain().setCode(model.getCode());
            vm.getMain().setDomestic(model.isDomestic());
            vm.getMain().setPhoneCode(model.getPhoneCode());
            vm.getMain().setRuPassportAllowed(model.isRuPassportAllowed());
            VMHelper.transfer(model.getRegions(), vm.getRegions(), region -> {
                GeoRegionVM result = new GeoRegionVM();
                result.setRegion(region);
                return result;
            });
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setNotUpdatable(vm.getMain().isNotUpdate());
            model.setCode(StringUtils.trim((String)vm.getMain().getCode()));
            model.setDomestic(vm.getMain().isDomestic());
            model.setPhoneCode(vm.getMain().getPhoneCode());
            model.setRuPassportAllowed(vm.getMain().isRuPassportAllowed());
            VMHelper.transfer(vm.getRegions(), model.getRegions(), regionVM -> regionVM.getRegion());
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<Country> getDictType() {
        return Country.class;
    }

    public DictionaryReference<Country> createReference(String code) {
        return new CountryReference(code);
    }

    @Override
    protected CountryPanelVM createVM() {
        return new CountryPanelVM();
    }

    @Override
    protected ViewController<CountryPanel, CountryPanelVM> createController() {
        return new CountryPanelController(false);
    }
}

