/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.HotelsBrandMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.HotelsBrandPanel;
import com.gridnine.xtrip.client.fx.model.dict.HotelsBrandPanelController;
import com.gridnine.xtrip.client.fx.model.dict.HotelsBrandPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.HotelsBrandReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class HotelsBrandHandler
extends BaseDictHandler<HotelsBrandPanel, HotelsBrand, HotelsBrandPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), HotelsBrand.Property.type.name(), Messages.Type, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), HotelsBrand.Property.parent.name(), Messages.Refers_to, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(this.getDictType(), HotelsBrand.Property.type.name(), Messages.Type, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(this.getDictType(), HotelsBrand.Property.parent.name(), Messages.Refers_to, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    protected void configureController(List<BiConsumer<HotelsBrand, HotelsBrandPanelVM>> toVM, List<BiConsumer<HotelsBrandPanelVM, HotelsBrand>> fromVM) {
        toVM.add((model, vm) -> {
            HotelsBrandMainPanelVM main = vm.getMain();
            main.setId(model.getCode());
            main.setType(model.getType());
            main.setParent(model.getParent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            HotelsBrandMainPanelVM main = vm.getMain();
            model.setCode(StringUtils.trim((String)main.getId()));
            model.setType(main.getType());
            model.setParent(main.getParent());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<HotelsBrand> getDictType() {
        return HotelsBrand.class;
    }

    public DictionaryReference<HotelsBrand> createReference(String code) {
        return new HotelsBrandReference(code);
    }

    @Override
    protected HotelsBrandPanelVM createVM() {
        return new HotelsBrandPanelVM();
    }

    @Override
    protected ViewController<HotelsBrandPanel, HotelsBrandPanelVM> createController() {
        return new HotelsBrandPanelController(false);
    }
}

